/*     */ package org.jboss.kernel.plugins.annotations;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.annotation.ElementType;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.InstallMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ParameterMetaData;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public abstract class InstallationParameterAnnotationPlugin<C extends Annotation> extends AbstractParameterAnnotationPlugin<MethodInfo, C, AbstractInstallMetaData>
/*     */ {
/*     */   protected InstallationParameterAnnotationPlugin(Class<C> annotation, Annotation2ValueMetaDataAdapter[] adapters)
/*     */   {
/*  49 */     super(annotation, adapters);
/*     */   }
/*     */ 
/*     */   protected boolean checkAnnotatedInfo(ElementType type)
/*     */   {
/*  54 */     return ElementType.METHOD == type;
/*     */   }
/*     */ 
/*     */   protected boolean isMetaDataAlreadyPresent(MethodInfo info, C annotation, BeanMetaData beanMetaData)
/*     */   {
/*  59 */     List installs = getInstalls(beanMetaData);
/*  60 */     if ((installs != null) && (!installs.isEmpty()))
/*     */     {
/*  62 */       for (InstallMetaData install : installs)
/*     */       {
/*  65 */         if (install.getBean() != null)
/*     */           continue;
/*  67 */         if (install.getMethodName().equals(info.getName()))
/*     */         {
/*  69 */           List parameters = install.getParameters();
/*  70 */           ParameterInfo[] parameterInfos = info.getParameters();
/*  71 */           if ((parameters == null) && (parameterInfos != null) && (parameterInfos.length == 0))
/*  72 */             return true;
/*  73 */           if ((parameters != null) && (parameters.size() == 0) && (parameterInfos == null))
/*  74 */             return true;
/*  75 */           if ((parameters != null) && (parameterInfos != null) && (parameters.size() == parameterInfos.length))
/*     */           {
/*  77 */             int n = parameters.size();
/*  78 */             String[] typeNames = new String[n];
/*  79 */             TypeInfo[] typeInfos = new TypeInfo[n];
/*  80 */             for (int i = 0; i < n; i++)
/*     */             {
/*  82 */               typeNames[i] = ((ParameterMetaData)parameters.get(i)).getType();
/*  83 */               typeInfos[i] = parameterInfos[i].getParameterType();
/*     */             }
/*  85 */             return Configurator.equals(typeNames, typeInfos);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*  90 */     return false;
/*     */   }
/*     */ 
/*     */   protected abstract List<InstallMetaData> getInstalls(BeanMetaData paramBeanMetaData);
/*     */ 
/*     */   protected ParameterInfo[] getParameters(MethodInfo info)
/*     */   {
/* 103 */     return info.getParameters();
/*     */   }
/*     */ 
/*     */   protected List<? extends MetaDataVisitorNode> handleParameterlessInfo(MethodInfo info, C annotation, BeanMetaData beanMetaData)
/*     */   {
/* 108 */     AbstractInstallMetaData parametrizedMetaData = (AbstractInstallMetaData)createParametrizedMetaData(info, annotation);
/* 109 */     setParameterizedMetaData(parametrizedMetaData, beanMetaData);
/* 110 */     return Collections.singletonList(parametrizedMetaData);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.InstallationParameterAnnotationPlugin
 * JD-Core Version:    0.6.0
 */