/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import org.jboss.beans.metadata.api.annotations.InstallMethod;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.InstallMetaData;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.reflect.spi.MethodInfo;
/*    */ 
/*    */ public class InstallMethodParameterAnnotationPlugin extends InstallationParameterAnnotationPlugin<InstallMethod>
/*    */ {
/*    */   protected InstallMethodParameterAnnotationPlugin(Annotation2ValueMetaDataAdapter[] adapters)
/*    */   {
/* 44 */     super(InstallMethod.class, adapters);
/*    */   }
/*    */ 
/*    */   protected List<InstallMetaData> getInstalls(BeanMetaData beanMetaData)
/*    */   {
/* 49 */     return beanMetaData.getInstalls();
/*    */   }
/*    */ 
/*    */   protected AbstractInstallMetaData createParametrizedMetaData(MethodInfo info, InstallMethod annotation)
/*    */   {
/* 54 */     AbstractInstallMetaData install = new AbstractInstallMetaData();
/* 55 */     install.setMethodName(info.getName());
/* 56 */     if (isAttributePresent(annotation.dependantState()))
/* 57 */       install.setDependentState(new ControllerState(annotation.dependantState()));
/* 58 */     return install;
/*    */   }
/*    */ 
/*    */   protected void setParameterizedMetaData(AbstractInstallMetaData parameterizedMetaData, BeanMetaData beanMetaData)
/*    */   {
/* 63 */     AbstractBeanMetaData abmd = (AbstractBeanMetaData)beanMetaData;
/* 64 */     List installs = beanMetaData.getInstalls();
/* 65 */     if (installs == null)
/*    */     {
/* 67 */       installs = new ArrayList();
/* 68 */       abmd.setInstalls(installs);
/*    */     }
/* 70 */     installs.add(parameterizedMetaData);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.InstallMethodParameterAnnotationPlugin
 * JD-Core Version:    0.6.0
 */