/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import java.util.Set;
/*    */ import org.jboss.beans.metadata.api.annotations.Install;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractCallbackMetaData;
/*    */ import org.jboss.beans.metadata.plugins.InstallCallbackMetaData;
/*    */ import org.jboss.beans.metadata.spi.CallbackMetaData;
/*    */ import org.jboss.dependency.spi.CallbackItem;
/*    */ import org.jboss.dependency.spi.Cardinality;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.dependency.spi.DependencyInfo;
/*    */ import org.jboss.reflect.spi.AnnotatedInfo;
/*    */ 
/*    */ public abstract class InstallCallbackAnnotationPlugin<T extends AnnotatedInfo> extends CallbackAnnotationPlugin<T, Install>
/*    */ {
/*    */   protected InstallCallbackAnnotationPlugin()
/*    */   {
/* 49 */     super(Install.class);
/*    */   }
/*    */ 
/*    */   protected Set<CallbackItem<?>> getCallbacks(DependencyInfo dependency)
/*    */   {
/* 54 */     return dependency.getInstallItems();
/*    */   }
/*    */ 
/*    */   protected AbstractCallbackMetaData createCallback(T info, Install annotation)
/*    */   {
/* 59 */     InstallCallbackMetaData callback = new InstallCallbackMetaData();
/* 60 */     callback.setWhenRequired(new ControllerState(annotation.whenRequired()));
/* 61 */     callback.setDependentState(new ControllerState(annotation.dependentState()));
/* 62 */     if (isAttributePresent(annotation.cardinality()))
/* 63 */       callback.setCardinality(Cardinality.fromString(annotation.cardinality()));
/* 64 */     applyInfo(callback, info);
/* 65 */     return callback;
/*    */   }
/*    */ 
/*    */   protected List<CallbackMetaData> getCallbacks(AbstractBeanMetaData beanMetaData)
/*    */   {
/* 70 */     List callbacks = beanMetaData.getInstallCallbacks();
/* 71 */     if (callbacks == null)
/*    */     {
/* 73 */       callbacks = new ArrayList();
/* 74 */       beanMetaData.setInstallCallbacks(callbacks);
/*    */     }
/* 76 */     return callbacks;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.InstallCallbackAnnotationPlugin
 * JD-Core Version:    0.6.0
 */