/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.HashSet;
/*    */ import java.util.List;
/*    */ import java.util.Set;
/*    */ import org.jboss.beans.metadata.api.annotations.Depends;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ 
/*    */ public class DependsAnnotationPlugin extends ClassAnnotationPlugin<Depends>
/*    */ {
/*    */   public DependsAnnotationPlugin()
/*    */   {
/* 47 */     super(Depends.class);
/*    */   }
/*    */ 
/*    */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, Depends annotation, KernelControllerContext context)
/*    */   {
/* 52 */     BeanMetaData beanMetaData = context.getBeanMetaData();
/* 53 */     Set dependencies = beanMetaData.getDepends();
/* 54 */     if (dependencies == null)
/*    */     {
/* 56 */       dependencies = new HashSet();
/* 57 */       ((AbstractBeanMetaData)beanMetaData).setDepends(dependencies);
/*    */     }
/* 59 */     List nodes = new ArrayList();
/* 60 */     for (String depends : annotation.value())
/*    */     {
/* 62 */       AbstractDependencyMetaData dependency = new AbstractDependencyMetaData(depends);
/* 63 */       if (dependencies.add(dependency))
/* 64 */         nodes.add(dependency);
/*    */     }
/* 66 */     return nodes;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.DependsAnnotationPlugin
 * JD-Core Version:    0.6.0
 */