/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.lang.annotation.ElementType;
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collections;
/*    */ import java.util.List;
/*    */ import org.jboss.beans.metadata.api.annotations.Factory;
/*    */ import org.jboss.beans.metadata.api.annotations.Value;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ 
/*    */ public class ClassFactoryAnnotationPlugin extends AbstractAdaptersAnnotationPlugin<ClassInfo, Factory>
/*    */ {
/*    */   protected ClassFactoryAnnotationPlugin(Annotation2ValueMetaDataAdapter[] adapters)
/*    */   {
/* 49 */     super(Factory.class, adapters);
/*    */   }
/*    */ 
/*    */   protected boolean isElementTypeSupported(ElementType type)
/*    */   {
/* 54 */     return ElementType.TYPE == type;
/*    */   }
/*    */ 
/*    */   protected boolean isMetaDataAlreadyPresent(ClassInfo info, Factory annotation, BeanMetaData beanMetaData)
/*    */   {
/* 59 */     return beanMetaData.getConstructor() != null;
/*    */   }
/*    */ 
/*    */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, Factory annotation, KernelControllerContext context) throws Throwable
/*    */   {
/* 64 */     AbstractBeanMetaData bean = (AbstractBeanMetaData)context.getBeanMetaData();
/* 65 */     AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
/* 66 */     if (isAttributePresent(annotation.factoryClass()))
/*    */     {
/* 68 */       constructor.setFactoryClass(annotation.factoryClass());
/*    */     }
/*    */     else
/*    */     {
/* 72 */       constructor.setFactory(ValueUtil.createValueMetaData(annotation.factory()));
/*    */     }
/* 74 */     constructor.setFactoryMethod(annotation.factoryMethod());
/* 75 */     if (annotation.parameters().length > 0)
/*    */     {
/* 77 */       List parameters = new ArrayList();
/* 78 */       for (Value parameter : annotation.parameters())
/*    */       {
/* 80 */         AbstractParameterMetaData apmd = new AbstractParameterMetaData(ValueUtil.createValueMetaData(parameter));
/* 81 */         if (isAttributePresent(parameter.type()))
/* 82 */           apmd.setType(parameter.type());
/* 83 */         parameters.add(apmd);
/*    */       }
/* 85 */       constructor.setParameters(parameters);
/*    */     }
/* 87 */     bean.setConstructor(constructor);
/* 88 */     return Collections.singletonList(constructor);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.ClassFactoryAnnotationPlugin
 * JD-Core Version:    0.6.0
 */