/*     */ package org.jboss.kernel.plugins.annotations;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.annotation.ElementType;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
/*     */ import org.jboss.beans.metadata.plugins.builder.MutableParameterizedMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.signature.MethodParametersSignature;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ import org.jboss.reflect.spi.AnnotatedInfo;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public abstract class AbstractParameterAnnotationPlugin<T extends AnnotatedInfo, C extends Annotation, P extends MutableParameterizedMetaData> extends AbstractAdaptersAnnotationPlugin<T, C>
/*     */ {
/*     */   protected AbstractParameterAnnotationPlugin(Class<C> annotation, Annotation2ValueMetaDataAdapter[] adapters)
/*     */   {
/*  57 */     super(annotation, adapters);
/*     */   }
/*     */ 
/*     */   protected abstract boolean checkAnnotatedInfo(ElementType paramElementType);
/*     */ 
/*     */   protected boolean isElementTypeSupported(ElementType type)
/*     */   {
/*  71 */     return (ElementType.PARAMETER == type) || (checkAnnotatedInfo(type));
/*     */   }
/*     */ 
/*     */   protected abstract ParameterInfo[] getParameters(T paramT);
/*     */ 
/*     */   protected List<? extends MetaDataVisitorNode> handleParameterlessInfo(T info, C annotation, KernelControllerContext context)
/*     */   {
/*  92 */     return handleParameterlessInfo(info, annotation, context.getBeanMetaData());
/*     */   }
/*     */ 
/*     */   protected abstract List<? extends MetaDataVisitorNode> handleParameterlessInfo(T paramT, C paramC, BeanMetaData paramBeanMetaData);
/*     */ 
/*     */   protected P createParametrizedMetaData(T info, C annotation, KernelControllerContext context)
/*     */   {
/* 115 */     return createParametrizedMetaData(info, annotation, context.getBeanMetaData());
/*     */   }
/*     */ 
/*     */   protected P createParametrizedMetaData(T info, C annotation, BeanMetaData beanMetaData)
/*     */   {
/* 128 */     return createParametrizedMetaData(info, annotation);
/*     */   }
/*     */ 
/*     */   protected P createParametrizedMetaData(T info, C annotation)
/*     */   {
/* 140 */     return createParametrizedMetaData(info);
/*     */   }
/*     */ 
/*     */   protected P createParametrizedMetaData(T info)
/*     */   {
/* 151 */     throw new IllegalArgumentException("Should implement one of createParameterizedMetaData methods!");
/*     */   }
/*     */ 
/*     */   protected void setParameterizedMetaData(P parameterizedMetaData, KernelControllerContext context)
/*     */   {
/* 162 */     setParameterizedMetaData(parameterizedMetaData, context.getBeanMetaData());
/*     */   }
/*     */ 
/*     */   protected abstract void setParameterizedMetaData(P paramP, BeanMetaData paramBeanMetaData);
/*     */ 
/*     */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, MetaData retrieval, C annotation, KernelControllerContext context)
/*     */     throws Throwable
/*     */   {
/* 175 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 177 */     ParameterInfo[] parameters = getParameters(info);
/* 178 */     if ((parameters == null) || (parameters.length == 0))
/*     */     {
/* 180 */       if (trace)
/* 181 */         this.log.trace("Info " + info + " has zero parameters.");
/* 182 */       return handleParameterlessInfo(info, annotation, context);
/*     */     }
/*     */ 
/* 185 */     TypeInfo[] typeInfos = new TypeInfo[parameters.length];
/* 186 */     for (int i = 0; i < parameters.length; i++) {
/* 187 */       typeInfos[i] = parameters[i].getParameterType();
/*     */     }
/* 189 */     List pmds = new ArrayList();
/* 190 */     for (int i = 0; i < parameters.length; i++)
/*     */     {
/* 192 */       ParameterInfo pi = parameters[i];
/* 193 */       Signature pis = new MethodParametersSignature(pi.getName(), Configurator.getParameterTypes(this.log.isTraceEnabled(), typeInfos), i);
/*     */ 
/* 198 */       MetaData mdr = retrieval.getComponentMetaData(pis);
/* 199 */       if (mdr != null)
/*     */       {
/* 201 */         ValueMetaData value = null;
/* 202 */         for (Annotation2ValueMetaDataAdapter adapter : this.adapters)
/*     */         {
/* 205 */           Annotation adapterAnnotation = mdr.getAnnotation(adapter.getAnnotation());
/* 206 */           if (adapterAnnotation != null)
/*     */           {
/* 208 */             value = adapter.createValueMetaData(adapterAnnotation);
/* 209 */             break;
/*     */           }
/*     */         }
/* 212 */         if (value == null)
/* 213 */           throw new IllegalArgumentException("No such Annotation2ValueMetaData adapter or no annotation on ParameterInfo: " + pi);
/* 214 */         if (trace)
/* 215 */           this.log.trace("Adding new ParameterMetaData for annotation: " + value);
/* 216 */         pmds.add(new AbstractParameterMetaData(pi.getParameterType().getName(), value));
/*     */       }
/*     */       else
/*     */       {
/* 220 */         throw new IllegalArgumentException("MetaData for parameter must exist: " + pi);
/*     */       }
/*     */     }
/* 223 */     MutableParameterizedMetaData parameterizedMetaData = createParametrizedMetaData(info, annotation, context);
/* 224 */     setParameterizedMetaData(parameterizedMetaData, context);
/* 225 */     parameterizedMetaData.setParameters(pmds);
/* 226 */     if (!(parameterizedMetaData instanceof MetaDataVisitorNode))
/* 227 */       throw new IllegalArgumentException("ParameterizedMetaData not MetaDataVisitor: " + parameterizedMetaData);
/* 228 */     return Collections.singletonList((MetaDataVisitorNode)parameterizedMetaData);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.AbstractParameterAnnotationPlugin
 * JD-Core Version:    0.6.0
 */