/*     */ package org.jboss.kernel.plugins.annotations;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.annotation.ElementType;
/*     */ import java.lang.annotation.Target;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.metadata.api.annotations.Cleanup;
/*     */ import org.jboss.beans.metadata.api.annotations.CleanupOnly;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.reflect.spi.AnnotatedInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public abstract class AbstractAnnotationPlugin<T extends AnnotatedInfo, C extends Annotation> extends JBossObject
/*     */   implements AnnotationPlugin<T, C>
/*     */ {
/*     */   private Class<C> annotation;
/*     */   private Set<ElementType> types;
/*     */   private boolean isCleanup;
/*     */   private boolean isCleanupOnly;
/*     */ 
/*     */   protected AbstractAnnotationPlugin(Class<C> annotation)
/*     */   {
/*  60 */     if (annotation == null)
/*  61 */       throw new IllegalArgumentException("Null annotation!");
/*  62 */     this.annotation = annotation;
/*  63 */     this.types = new HashSet();
/*  64 */     Target target = (Target)annotation.getAnnotation(Target.class);
/*  65 */     if (target != null)
/*     */     {
/*  67 */       List list = Arrays.asList(target.value());
/*  68 */       for (ElementType type : list)
/*     */       {
/*  70 */         if (isElementTypeSupported(type))
/*     */         {
/*  72 */           this.types.add(type);
/*     */         }
/*     */         else
/*  75 */           this.log.warn("Unsupported type " + type + " on annotation " + annotation);
/*     */       }
/*     */     }
/*  78 */     this.isCleanupOnly = annotation.isAnnotationPresent(CleanupOnly.class);
/*  79 */     this.isCleanup = ((this.isCleanupOnly) || (annotation.isAnnotationPresent(Cleanup.class)));
/*     */   }
/*     */ 
/*     */   protected static boolean isAttributePresent(String value)
/*     */   {
/*  91 */     return ValueUtil.isAttributePresent(value);
/*     */   }
/*     */ 
/*     */   protected abstract boolean isElementTypeSupported(ElementType paramElementType);
/*     */ 
/*     */   public Set<ElementType> getSupportedTypes()
/*     */   {
/* 104 */     return Collections.unmodifiableSet(this.types);
/*     */   }
/*     */ 
/*     */   public Class<C> getAnnotation()
/*     */   {
/* 109 */     return this.annotation;
/*     */   }
/*     */ 
/*     */   protected boolean isMetaDataAlreadyPresent(T info, C annotation, KernelControllerContext context)
/*     */   {
/* 122 */     return isMetaDataAlreadyPresent(info, annotation, context.getBeanMetaData());
/*     */   }
/*     */ 
/*     */   protected boolean isMetaDataAlreadyPresent(T info, C annotation, BeanMetaData beanMetaData)
/*     */   {
/* 135 */     return false;
/*     */   }
/*     */ 
/*     */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, MetaData retrieval, C annotation, KernelControllerContext context)
/*     */     throws Throwable
/*     */   {
/* 150 */     return internalApplyAnnotation(info, annotation, context);
/*     */   }
/*     */ 
/*     */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, C annotation, KernelControllerContext context)
/*     */     throws Throwable
/*     */   {
/* 164 */     return internalApplyAnnotation(info, annotation, context.getBeanMetaData());
/*     */   }
/*     */ 
/*     */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, C annotation, BeanMetaData beanMetaData)
/*     */     throws Throwable
/*     */   {
/* 178 */     this.log.warn("Probably missing annotation apply implementation: " + this);
/* 179 */     return Collections.emptyList();
/*     */   }
/*     */ 
/*     */   public final void applyAnnotation(T info, MetaData retrieval, MetaDataVisitor visitor) throws Throwable
/*     */   {
/* 184 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 186 */     if (!this.isCleanupOnly)
/*     */     {
/* 188 */       Class annotationClass = getAnnotation();
/* 189 */       Annotation annotation = retrieval.getAnnotation(annotationClass);
/* 190 */       if (annotation == null)
/*     */       {
/* 192 */         if (trace)
/* 193 */           this.log.trace("No annotation: " + annotationClass.getName());
/* 194 */         return;
/*     */       }
/* 196 */       if (isMetaDataAlreadyPresent(info, annotation, visitor.getControllerContext()))
/*     */       {
/* 198 */         if (trace)
/* 199 */           this.log.trace("MetaDataAlreadyPresent, ignoring " + annotation);
/* 200 */         return;
/*     */       }
/* 202 */       if (trace)
/* 203 */         this.log.trace("Applying annotation: " + annotation);
/* 204 */       List nodes = internalApplyAnnotation(info, retrieval, annotation, visitor.getControllerContext());
/* 205 */       if ((nodes != null) && (!nodes.isEmpty()))
/*     */       {
/* 207 */         for (MetaDataVisitorNode node : nodes)
/*     */         {
/* 209 */           node.initialVisit(visitor);
/* 210 */           node.describeVisit(visitor);
/*     */         }
/*     */       }
/*     */     }
/* 214 */     else if (trace) {
/* 215 */       this.log.trace("Annotation " + this.annotation + " is @CleanupOnly, nothing to apply on install.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void cleanAnnotation(T info, MetaData retrieval, MetaDataVisitor visitor) throws Throwable {
/* 220 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 222 */     if (this.isCleanup)
/*     */     {
/* 224 */       Class annotationClass = getAnnotation();
/* 225 */       Annotation annotation = retrieval.getAnnotation(annotationClass);
/* 226 */       if (annotation == null)
/*     */       {
/* 228 */         if (trace)
/* 229 */           this.log.trace("No annotation: " + annotationClass.getName());
/*     */       }
/*     */       else
/*     */       {
/* 233 */         if (trace)
/* 234 */           this.log.trace("Cleaning annotation: " + annotation);
/* 235 */         internalCleanAnnotation(info, retrieval, annotation, visitor.getControllerContext());
/*     */       }
/*     */     }
/* 238 */     else if (trace) {
/* 239 */       this.log.trace("Annotation " + this.annotation + " is not a @Cleanup annotation.");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void internalCleanAnnotation(T info, MetaData retrieval, C annotation, KernelControllerContext context)
/*     */     throws Throwable
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 258 */     buffer.append("@annotation=").append(this.annotation);
/* 259 */     buffer.append(" ,types=").append(this.types);
/* 260 */     buffer.append(" ,cleanup=").append(this.isCleanup);
/* 261 */     buffer.append(" ,cleanupOnly=").append(this.isCleanupOnly);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 266 */     buffer.append("@annotation=").append(this.annotation);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.AbstractAnnotationPlugin
 * JD-Core Version:    0.6.0
 */