/*     */ package org.jboss.kernel;
/*     */ 
/*     */ import org.jboss.kernel.spi.bootstrap.KernelInitializer;
/*     */ import org.jboss.kernel.spi.config.KernelConfig;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class KernelFactory
/*     */ {
/*  44 */   private static final KernelFactory singleton = new KernelFactory();
/*     */ 
/*  47 */   protected final Logger log = Logger.getLogger(getClass());
/*     */ 
/*     */   public static Kernel newInstance(KernelConfig cfg)
/*     */   {
/*  67 */     return singleton.assembleNewKernel(cfg);
/*     */   }
/*     */ 
/*     */   protected Kernel assembleNewKernel(KernelConfig cfg)
/*     */     throws RuntimeException
/*     */   {
/*  83 */     long begin = 0L;
/*  84 */     long end = 0L;
/*     */ 
/*  86 */     this.log.debug("Starting JBoss Kernel construction...");
/*  87 */     begin = System.currentTimeMillis();
/*     */ 
/*  90 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/*  92 */     if (trace) {
/*  93 */       this.log.trace("Using KernelConfig: " + cfg);
/*     */     }
/*  95 */     Kernel kernel = createKernel();
/*  96 */     if (trace) {
/*  97 */       this.log.trace("Using Kernel: " + kernel);
/*     */     }
/*  99 */     KernelInitializer initializer = createKernelInitializer(cfg);
/* 100 */     if (trace) {
/* 101 */       this.log.trace("Using KernelInitializer: " + initializer);
/*     */     }
/* 103 */     configureKernel(kernel, cfg);
/* 104 */     if (trace) {
/* 105 */       this.log.trace("Configured kernel from KernelConfig");
/*     */     }
/* 107 */     initializeKernel(kernel, initializer);
/* 108 */     if (trace) {
/* 109 */       this.log.trace("Kernel instance initialzed");
/*     */     }
/* 111 */     end = System.currentTimeMillis();
/* 112 */     this.log.debug("Completed JBoss Kernel construction.  Duration: " + (end - begin) + " milliseconds");
/*     */ 
/* 114 */     return kernel;
/*     */   }
/*     */ 
/*     */   protected Kernel createKernel()
/*     */   {
/* 129 */     return new Kernel();
/*     */   }
/*     */ 
/*     */   protected KernelInitializer createKernelInitializer(KernelConfig config)
/*     */   {
/*     */     String msg;
/*     */     try
/*     */     {
/* 150 */       return config.createKernelInitializer();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 154 */       msg = "Unable to create a KernelInitializer based on the specified KernelConfig";
/*     */     }
/* 156 */     throw new RuntimeException(msg, t);
/*     */   }
/*     */ 
/*     */   protected void configureKernel(Kernel kernel, KernelConfig cfg)
/*     */   {
/* 172 */     kernel.setConfig(cfg);
/*     */     try
/*     */     {
/* 175 */       cfg.setKernel(kernel);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 179 */       String msg = "Unable to update the KernelConfig with the specified Kernel";
/* 180 */       throw new RuntimeException(msg, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initializeKernel(Kernel kernel, KernelInitializer initializer)
/*     */   {
/*     */     try
/*     */     {
/* 198 */       initializer.initKernel(kernel);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 202 */       String msg = "Unable to properly initialize the Kernel";
/* 203 */       throw new RuntimeException(msg, t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.KernelFactory
 * JD-Core Version:    0.6.0
 */