/*     */ package org.jboss.kernel;
/*     */ 
/*     */ import org.jboss.kernel.spi.config.KernelConfig;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.event.KernelEventManager;
/*     */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*     */ import org.jboss.kernel.spi.registry.KernelBus;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistry;
/*     */ 
/*     */ public class Kernel
/*     */ {
/*  44 */   public static final KernelPermission ACCESS = new KernelPermission("access");
/*     */ 
/*  47 */   public static final KernelPermission CONFIGURE = new KernelPermission("configure");
/*     */   private static final boolean enablePermissionChecking;
/*     */   protected KernelBus bus;
/*     */   protected KernelConfig config;
/*     */   protected KernelConfigurator configurator;
/*     */   protected KernelController controller;
/*     */   protected KernelEventManager eventManager;
/*     */   protected KernelMetaDataRepository metaDataRepository;
/*     */   protected KernelRegistry registry;
/*     */ 
/*     */   public static void checkAccess()
/*     */   {
/*  94 */     if (enablePermissionChecking)
/*     */     {
/*  96 */       SecurityManager sm = System.getSecurityManager();
/*  97 */       if (sm != null)
/*  98 */         sm.checkPermission(ACCESS);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void checkConfigure()
/*     */   {
/* 109 */     if (enablePermissionChecking)
/*     */     {
/* 111 */       SecurityManager sm = System.getSecurityManager();
/* 112 */       if (sm != null)
/* 113 */         sm.checkPermission(CONFIGURE);
/*     */     }
/*     */   }
/*     */ 
/*     */   public KernelBus getBus()
/*     */   {
/* 125 */     checkAccess();
/* 126 */     return this.bus;
/*     */   }
/*     */ 
/*     */   public void setBus(KernelBus bus)
/*     */   {
/* 137 */     checkConfigure();
/* 138 */     this.bus = bus;
/*     */   }
/*     */ 
/*     */   public KernelConfig getConfig()
/*     */   {
/* 149 */     checkAccess();
/* 150 */     return this.config;
/*     */   }
/*     */ 
/*     */   public void setConfig(KernelConfig config)
/*     */   {
/* 161 */     checkConfigure();
/* 162 */     this.config = config;
/*     */   }
/*     */ 
/*     */   public KernelConfigurator getConfigurator()
/*     */   {
/* 173 */     checkAccess();
/* 174 */     return this.configurator;
/*     */   }
/*     */ 
/*     */   public void setConfigurator(KernelConfigurator configurator)
/*     */   {
/* 185 */     checkConfigure();
/* 186 */     this.configurator = configurator;
/*     */   }
/*     */ 
/*     */   public KernelController getController()
/*     */   {
/* 197 */     checkAccess();
/* 198 */     return this.controller;
/*     */   }
/*     */ 
/*     */   public void setController(KernelController controller)
/*     */   {
/* 209 */     checkConfigure();
/* 210 */     this.controller = controller;
/*     */   }
/*     */ 
/*     */   public KernelEventManager getEventManager()
/*     */   {
/* 221 */     checkAccess();
/* 222 */     return this.eventManager;
/*     */   }
/*     */ 
/*     */   public void setEventManager(KernelEventManager eventManager)
/*     */   {
/* 233 */     checkConfigure();
/* 234 */     this.eventManager = eventManager;
/*     */   }
/*     */ 
/*     */   public KernelRegistry getRegistry()
/*     */   {
/* 245 */     checkAccess();
/* 246 */     return this.registry;
/*     */   }
/*     */ 
/*     */   public void setRegistry(KernelRegistry registry)
/*     */   {
/* 257 */     checkConfigure();
/* 258 */     this.registry = registry;
/*     */   }
/*     */ 
/*     */   public KernelMetaDataRepository getMetaDataRepository()
/*     */   {
/* 269 */     checkAccess();
/* 270 */     return this.metaDataRepository;
/*     */   }
/*     */ 
/*     */   public void setMetaDataRepository(KernelMetaDataRepository metaDataRepository)
/*     */   {
/* 281 */     checkConfigure();
/* 282 */     this.metaDataRepository = metaDataRepository;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  75 */     boolean checkingEnabled = false;
/*     */     try
/*     */     {
/*  79 */       checkingEnabled = Boolean.getBoolean(KernelPermission.class.getName());
/*     */     }
/*     */     catch (Throwable ignored)
/*     */     {
/*     */     }
/*  84 */     enablePermissionChecking = checkingEnabled;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.Kernel
 * JD-Core Version:    0.6.0
 */