/*    */ package org.jboss.joinpoint.plugins;
/*    */ 
/*    */ import org.jboss.joinpoint.spi.ConstructorJoinpoint;
/*    */ import org.jboss.joinpoint.spi.FieldGetJoinpoint;
/*    */ import org.jboss.joinpoint.spi.FieldSetJoinpoint;
/*    */ import org.jboss.joinpoint.spi.JoinpointException;
/*    */ import org.jboss.joinpoint.spi.JoinpointFactory;
/*    */ import org.jboss.joinpoint.spi.MethodJoinpoint;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ import org.jboss.reflect.spi.ConstructorInfo;
/*    */ import org.jboss.reflect.spi.FieldInfo;
/*    */ import org.jboss.reflect.spi.MethodInfo;
/*    */ import org.jboss.util.JBossObject;
/*    */ import org.jboss.util.JBossStringBuilder;
/*    */ 
/*    */ public class BasicJoinpointFactory extends JBossObject
/*    */   implements JoinpointFactory
/*    */ {
/*    */   protected ClassInfo classInfo;
/*    */ 
/*    */   public BasicJoinpointFactory(ClassInfo classInfo)
/*    */   {
/* 49 */     this.classInfo = classInfo;
/*    */   }
/*    */ 
/*    */   public ClassInfo getClassInfo()
/*    */   {
/* 54 */     return this.classInfo;
/*    */   }
/*    */ 
/*    */   public ConstructorJoinpoint getConstructorJoinpoint(ConstructorInfo constructorInfo) throws JoinpointException
/*    */   {
/* 59 */     return new BasicConstructorJoinPoint(constructorInfo);
/*    */   }
/*    */ 
/*    */   public FieldGetJoinpoint getFieldGetJoinpoint(FieldInfo fieldInfo) throws JoinpointException
/*    */   {
/* 64 */     return new BasicFieldGetJoinPoint(fieldInfo);
/*    */   }
/*    */ 
/*    */   public FieldSetJoinpoint getFieldSetJoinpoint(FieldInfo fieldInfo) throws JoinpointException
/*    */   {
/* 69 */     return new BasicFieldSetJoinPoint(fieldInfo);
/*    */   }
/*    */ 
/*    */   public MethodJoinpoint getMethodJoinpoint(MethodInfo methodInfo) throws JoinpointException
/*    */   {
/* 74 */     return new BasicMethodJoinPoint(methodInfo);
/*    */   }
/*    */ 
/*    */   public void toString(JBossStringBuilder buffer)
/*    */   {
/* 79 */     buffer.append("classInfo=").append(this.classInfo.getName());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.joinpoint.plugins.BasicJoinpointFactory
 * JD-Core Version:    0.6.0
 */