/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.server.endpoint.advised.SessionAdvised;
/*     */ import org.jboss.messaging.core.impl.message.MessageFactory;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.invocation.OnewayInvocation;
/*     */ 
/*     */ public class SessionSendRequest extends RequestSupport
/*     */ {
/*     */   private JBossMessage msg;
/*     */   private boolean checkForDuplicates;
/*     */   private long sequence;
/*     */ 
/*     */   public SessionSendRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SessionSendRequest(String objectId, byte version, JBossMessage msg, boolean checkForDuplicates, long sequence)
/*     */   {
/*  62 */     super(objectId, 312, version);
/*  63 */     this.msg = msg;
/*  64 */     this.checkForDuplicates = checkForDuplicates;
/*  65 */     this.sequence = sequence;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/*  70 */     super.read(is);
/*     */ 
/*  72 */     byte messageType = is.readByte();
/*     */ 
/*  74 */     this.msg = ((JBossMessage)MessageFactory.createMessage(messageType));
/*     */ 
/*  76 */     this.msg.read(is);
/*     */ 
/*  78 */     this.checkForDuplicates = is.readBoolean();
/*     */ 
/*  80 */     this.sequence = is.readLong();
/*     */   }
/*     */ 
/*     */   public ResponseSupport serverInvoke() throws Exception
/*     */   {
/*  85 */     SessionAdvised advised = (SessionAdvised)Dispatcher.instance.getTarget(this.objectId);
/*     */ 
/*  88 */     if (advised != null)
/*     */     {
/*  90 */       advised.send(this.msg, this.checkForDuplicates, this.sequence);
/*     */     }
/*  94 */     else if (this.sequence == -1L)
/*     */     {
/*  98 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*     */     }
/*     */ 
/* 107 */     return null;
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/* 112 */     super.write(os);
/*     */ 
/* 114 */     os.writeByte(this.msg.getType());
/*     */ 
/* 116 */     this.msg.write(os);
/*     */ 
/* 118 */     os.writeBoolean(this.checkForDuplicates);
/*     */ 
/* 120 */     os.writeLong(this.sequence);
/*     */ 
/* 122 */     os.flush();
/*     */   }
/*     */ 
/*     */   public Object getPayload()
/*     */   {
/* 127 */     if (this.sequence != -1L)
/*     */     {
/* 129 */       OnewayInvocation oi = new OnewayInvocation(this);
/*     */ 
/* 131 */       InvocationRequest request = new InvocationRequest(null, "JMS", oi, ONE_WAY_METADATA, null, null);
/*     */ 
/* 135 */       return request;
/*     */     }
/*     */ 
/* 139 */     return super.getPayload();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionSendRequest
 * JD-Core Version:    0.6.0
 */