/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.jms.delegate.DeliveryRecovery;
/*     */ import org.jboss.jms.delegate.SessionEndpoint;
/*     */ 
/*     */ public class SessionRecoverDeliveriesRequest extends RequestSupport
/*     */ {
/*     */   private List dels;
/*     */   private String sessionID;
/*     */ 
/*     */   public SessionRecoverDeliveriesRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SessionRecoverDeliveriesRequest(String objectId, byte version, List dels, String sessionID)
/*     */   {
/*  59 */     super(objectId, 313, version);
/*     */ 
/*  61 */     this.dels = dels;
/*     */ 
/*  63 */     this.sessionID = sessionID;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/*  68 */     super.read(is);
/*     */ 
/*  70 */     int size = is.readInt();
/*     */ 
/*  72 */     this.dels = new ArrayList(size);
/*     */ 
/*  74 */     for (int i = 0; i < size; i++)
/*     */     {
/*  76 */       DeliveryRecovery del = new DeliveryRecovery();
/*     */ 
/*  78 */       del.read(is);
/*     */ 
/*  80 */       this.dels.add(del);
/*     */     }
/*     */ 
/*  83 */     this.sessionID = is.readUTF();
/*     */   }
/*     */ 
/*     */   public ResponseSupport serverInvoke() throws Exception
/*     */   {
/*  88 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*     */ 
/*  91 */     if (endpoint == null)
/*     */     {
/*  93 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*     */     }
/*     */ 
/*  96 */     endpoint.recoverDeliveries(this.dels, this.sessionID);
/*     */ 
/*  98 */     return null;
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/* 103 */     super.write(os);
/*     */ 
/* 105 */     os.writeInt(this.dels.size());
/*     */ 
/* 107 */     Iterator iter = this.dels.iterator();
/*     */ 
/* 109 */     while (iter.hasNext())
/*     */     {
/* 111 */       DeliveryRecovery del = (DeliveryRecovery)iter.next();
/*     */ 
/* 113 */       del.write(os);
/*     */     }
/*     */ 
/* 116 */     os.writeUTF(this.sessionID);
/*     */ 
/* 118 */     os.flush();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionRecoverDeliveriesRequest
 * JD-Core Version:    0.6.0
 */