/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.delegate.SessionEndpoint;
/*    */ 
/*    */ public class SessionCreateTopicRequest extends RequestSupport
/*    */ {
/*    */   private String topicName;
/*    */ 
/*    */   public SessionCreateTopicRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public SessionCreateTopicRequest(String objectId, byte version, String topicName)
/*    */   {
/* 52 */     super(objectId, 304, version);
/*    */ 
/* 54 */     this.topicName = topicName;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 59 */     super.read(is);
/*    */ 
/* 61 */     this.topicName = is.readUTF();
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 66 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 69 */     if (endpoint == null)
/*    */     {
/* 71 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 74 */     return new SessionCreateTopicResponse(endpoint.createTopic(this.topicName));
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 79 */     super.write(os);
/*    */ 
/* 81 */     os.writeUTF(this.topicName);
/*    */ 
/* 83 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionCreateTopicRequest
 * JD-Core Version:    0.6.0
 */