/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.client.delegate.ClientBrowserDelegate;
/*    */ import org.jboss.jms.delegate.SessionEndpoint;
/*    */ import org.jboss.jms.destination.JBossDestination;
/*    */ 
/*    */ public class SessionCreateBrowserDelegateRequest extends RequestSupport
/*    */ {
/*    */   private JBossDestination dest;
/*    */   private String selector;
/*    */ 
/*    */   public SessionCreateBrowserDelegateRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public SessionCreateBrowserDelegateRequest(String objectId, byte version, JBossDestination destination, String selector)
/*    */   {
/* 57 */     super(objectId, 302, version);
/*    */ 
/* 59 */     this.dest = destination;
/* 60 */     this.selector = selector;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 65 */     super.read(is);
/*    */ 
/* 67 */     this.dest = JBossDestination.readDestination(is);
/*    */ 
/* 69 */     this.selector = readNullableString(is);
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 74 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 77 */     if (endpoint == null)
/*    */     {
/* 79 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 82 */     return new SessionCreateBrowserDelegateResponse((ClientBrowserDelegate)endpoint.createBrowserDelegate(this.dest, this.selector));
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 87 */     super.write(os);
/*    */ 
/* 89 */     JBossDestination.writeDestination(os, this.dest);
/*    */ 
/* 91 */     writeNullableString(this.selector, os);
/*    */ 
/* 93 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionCreateBrowserDelegateRequest
 * JD-Core Version:    0.6.0
 */