/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.jms.delegate.Cancel;
/*     */ import org.jboss.jms.delegate.DefaultCancel;
/*     */ import org.jboss.jms.delegate.SessionEndpoint;
/*     */ 
/*     */ public class SessionCancelDeliveryRequest extends RequestSupport
/*     */ {
/*     */   private Cancel cancel;
/*     */ 
/*     */   public SessionCancelDeliveryRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SessionCancelDeliveryRequest(String objectId, byte version, Cancel cancel)
/*     */   {
/*  54 */     super(objectId, 308, version);
/*     */ 
/*  56 */     this.cancel = cancel;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/*  61 */     super.read(is);
/*     */ 
/*  63 */     long deliveryId = is.readLong();
/*     */ 
/*  65 */     int deliveryCount = is.readInt();
/*     */ 
/*  67 */     boolean expired = is.readBoolean();
/*     */ 
/*  69 */     boolean reachedMax = is.readBoolean();
/*     */ 
/*  71 */     this.cancel = new DefaultCancel(deliveryId, deliveryCount, expired, reachedMax);
/*     */   }
/*     */ 
/*     */   public ResponseSupport serverInvoke() throws Exception
/*     */   {
/*  76 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*     */ 
/*  79 */     if (endpoint == null)
/*     */     {
/*  81 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*     */     }
/*     */ 
/*  84 */     endpoint.cancelDelivery(this.cancel);
/*     */ 
/*  86 */     return null;
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/*  91 */     super.write(os);
/*     */ 
/*  93 */     os.writeLong(this.cancel.getDeliveryId());
/*     */ 
/*  95 */     os.writeInt(this.cancel.getDeliveryCount());
/*     */ 
/*  97 */     os.writeBoolean(this.cancel.isExpired());
/*     */ 
/*  99 */     os.writeBoolean(this.cancel.isReachedMaxDeliveryAttempts());
/*     */ 
/* 101 */     os.flush();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionCancelDeliveryRequest
 * JD-Core Version:    0.6.0
 */