/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.delegate.SessionEndpoint;
/*    */ import org.jboss.jms.destination.JBossDestination;
/*    */ 
/*    */ public class SessionAddTemporaryDestinationRequest extends RequestSupport
/*    */ {
/*    */   private JBossDestination dest;
/*    */ 
/*    */   public SessionAddTemporaryDestinationRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public SessionAddTemporaryDestinationRequest(String objectId, byte version, JBossDestination dest)
/*    */   {
/* 53 */     super(objectId, 309, version);
/*    */ 
/* 55 */     this.dest = dest;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 60 */     super.read(is);
/*    */ 
/* 62 */     this.dest = JBossDestination.readDestination(is);
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 67 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 70 */     if (endpoint == null)
/*    */     {
/* 72 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 75 */     endpoint.addTemporaryDestination(this.dest);
/*    */ 
/* 77 */     return null;
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 82 */     super.write(os);
/*    */ 
/* 84 */     JBossDestination.writeDestination(os, this.dest);
/*    */ 
/* 86 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionAddTemporaryDestinationRequest
 * JD-Core Version:    0.6.0
 */