/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.delegate.Ack;
/*    */ import org.jboss.jms.delegate.DefaultAck;
/*    */ import org.jboss.jms.delegate.SessionEndpoint;
/*    */ 
/*    */ public class SessionAcknowledgeDeliveryRequest extends RequestSupport
/*    */ {
/*    */   private Ack ack;
/*    */ 
/*    */   public SessionAcknowledgeDeliveryRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public SessionAcknowledgeDeliveryRequest(String objectId, byte version, Ack ack)
/*    */   {
/* 54 */     super(objectId, 306, version);
/*    */ 
/* 56 */     this.ack = ack;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 61 */     super.read(is);
/*    */ 
/* 63 */     long deliveryId = is.readLong();
/*    */ 
/* 65 */     this.ack = new DefaultAck(deliveryId);
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 70 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 73 */     if (endpoint == null)
/*    */     {
/* 75 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 78 */     boolean res = endpoint.acknowledgeDelivery(this.ack);
/*    */ 
/* 80 */     return new SessionAcknowledgeDeliveryResponse(res);
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 85 */     super.write(os);
/*    */ 
/* 87 */     os.writeLong(this.ack.getDeliveryID());
/*    */ 
/* 89 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionAcknowledgeDeliveryRequest
 * JD-Core Version:    0.6.0
 */