/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.jms.delegate.Ack;
/*     */ import org.jboss.jms.delegate.DefaultAck;
/*     */ import org.jboss.jms.delegate.SessionEndpoint;
/*     */ 
/*     */ public class SessionAcknowledgeDeliveriesRequest extends RequestSupport
/*     */ {
/*     */   private List acks;
/*     */ 
/*     */   public SessionAcknowledgeDeliveriesRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SessionAcknowledgeDeliveriesRequest(String objectId, byte version, List acks)
/*     */   {
/*  57 */     super(objectId, 305, version);
/*     */ 
/*  59 */     this.acks = acks;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/*  64 */     super.read(is);
/*     */ 
/*  66 */     int size = is.readInt();
/*     */ 
/*  68 */     this.acks = new ArrayList(size);
/*     */ 
/*  70 */     for (int i = 0; i < size; i++)
/*     */     {
/*  72 */       long deliveryId = is.readLong();
/*     */ 
/*  74 */       DefaultAck ack = new DefaultAck(deliveryId);
/*     */ 
/*  76 */       this.acks.add(ack);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ResponseSupport serverInvoke() throws Exception
/*     */   {
/*  82 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*     */ 
/*  85 */     if (endpoint == null)
/*     */     {
/*  87 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*     */     }
/*     */ 
/*  90 */     endpoint.acknowledgeDeliveries(this.acks);
/*     */ 
/*  92 */     return null;
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/*  97 */     super.write(os);
/*     */ 
/*  99 */     os.writeInt(this.acks.size());
/*     */ 
/* 101 */     Iterator iter = this.acks.iterator();
/*     */ 
/* 103 */     while (iter.hasNext())
/*     */     {
/* 105 */       Ack ack = (Ack)iter.next();
/*     */ 
/* 107 */       os.writeLong(ack.getDeliveryID());
/*     */     }
/*     */ 
/* 110 */     os.flush();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionAcknowledgeDeliveriesRequest
 * JD-Core Version:    0.6.0
 */