/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.remoting.InvocationResponse;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ 
/*     */ public class PolledCallbacksDelivery extends PacketSupport
/*     */ {
/*     */   private List callbacks;
/*     */   private String sessionID;
/*     */ 
/*     */   public PolledCallbacksDelivery()
/*     */   {
/*     */   }
/*     */ 
/*     */   public PolledCallbacksDelivery(List callbacks, String sessionID)
/*     */   {
/*  55 */     super(4);
/*     */ 
/*  57 */     this.callbacks = callbacks;
/*     */ 
/*  59 */     this.sessionID = sessionID;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/*  64 */     this.sessionID = is.readUTF();
/*     */ 
/*  66 */     int len = is.readInt();
/*     */ 
/*  68 */     this.callbacks = new ArrayList(len);
/*     */ 
/*  70 */     for (int i = 0; i < len; i++)
/*     */     {
/*  75 */       int id = is.readInt();
/*     */       CallbackSupport cs;
/*  77 */       switch (id)
/*     */       {
/*     */       case 2:
/*  80 */         cs = new ClientDelivery();
/*  81 */         break;
/*     */       case 3:
/*  83 */         cs = new ConnectionFactoryUpdate();
/*  84 */         break;
/*     */       default:
/*  87 */         throw new IllegalStateException("Can't deal with methodId=" + id);
/*     */       }
/*     */ 
/*  90 */       cs.read(is);
/*     */ 
/*  92 */       Callback cb = new Callback(cs);
/*     */ 
/*  94 */       this.callbacks.add(cb);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/* 100 */     super.write(os);
/*     */ 
/* 102 */     os.writeUTF(this.sessionID);
/*     */ 
/* 104 */     os.writeInt(this.callbacks.size());
/*     */ 
/* 106 */     Iterator iter = this.callbacks.iterator();
/*     */ 
/* 108 */     while (iter.hasNext())
/*     */     {
/* 110 */       Callback cb = (Callback)iter.next();
/*     */ 
/* 112 */       CallbackSupport cs = (CallbackSupport)cb.getParameter();
/*     */ 
/* 114 */       cs.write(os);
/*     */     }
/*     */ 
/* 117 */     os.flush();
/*     */   }
/*     */ 
/*     */   public Object getPayload()
/*     */   {
/* 122 */     return new InvocationResponse(this.sessionID, this.callbacks, false, null);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.PolledCallbacksDelivery
 * JD-Core Version:    0.6.0
 */