/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ 
/*     */ public abstract class PacketSupport
/*     */   implements Streamable
/*     */ {
/*     */   private static final int NULL = 0;
/*     */   private static final int NOT_NULL = 1;
/*  51 */   protected static Map ONE_WAY_METADATA = new HashMap();
/*     */   public static final int SERIALIZED = 1;
/*     */   public static final int CLIENT_DELIVERY = 2;
/*     */   public static final int CONNECTIONFACTORY_UPDATE = 3;
/*     */   public static final int POLLEDCALLBACKS_DELIVERY = 4;
/*     */   public static final int REQ_CONNECTIONFACTORY_CREATECONNECTIONDELEGATE = 100;
/*     */   public static final int REQ_CONNECTIONFACTORY_GETIDBLOCK = 101;
/*     */   public static final int REQ_CONNECTIONFACTORY_GETCLIENTAOPSTACK = 102;
/*     */   public static final int REQ_CONNECTIONFACTORY_ADDCALLBACK = 103;
/*     */   public static final int REQ_CONNECTIONFACTORY_REMOVECALLBACK = 104;
/*     */   public static final int REQ_CONNECTIONFACTORY_GETTOPOLOGY = 105;
/*     */   public static final int REQ_CONNECTION_CREATESESSIONDELEGATE = 201;
/*     */   public static final int REQ_CONNECTION_GETCLIENTID = 202;
/*     */   public static final int REQ_CONNECTION_SETCLIENTID = 203;
/*     */   public static final int REQ_CONNECTION_START = 204;
/*     */   public static final int REQ_CONNECTION_STOP = 205;
/*     */   public static final int REQ_CONNECTION_SENDTRANSACTION = 206;
/*     */   public static final int REQ_CONNECTION_GETPREPAREDTRANSACTIONS = 207;
/*     */   public static final int REQ_SESSION_CREATECONSUMERDELEGATE = 301;
/*     */   public static final int REQ_SESSION_CREATEBROWSERDELEGATE = 302;
/*     */   public static final int REQ_SESSION_CREATEQUEUE = 303;
/*     */   public static final int REQ_SESSION_CREATETOPIC = 304;
/*     */   public static final int REQ_SESSION_ACKNOWLEDGEDELIVERIES = 305;
/*     */   public static final int REQ_SESSION_ACKNOWLEDGEDELIVERY = 306;
/*     */   public static final int REQ_SESSION_CANCELDELIVERIES = 307;
/*     */   public static final int REQ_SESSION_CANCELDELIVERY = 308;
/*     */   public static final int REQ_SESSION_ADDTEMPORARYDESTINATION = 309;
/*     */   public static final int REQ_SESSION_DELETETEMPORARYDESTINATION = 310;
/*     */   public static final int REQ_SESSION_UNSUBSCRIBE = 311;
/*     */   public static final int REQ_SESSION_SEND = 312;
/*     */   public static final int REQ_SESSION_RECOVERDELIVERIES = 313;
/*     */   public static final int REQ_CONSUMER_CHANGERATE = 401;
/*     */   public static final int REQ_BROWSER_NEXTMESSAGE = 501;
/*     */   public static final int REQ_BROWSER_HASNEXTMESSAGE = 502;
/*     */   public static final int REQ_BROWSER_NEXTMESSAGEBLOCK = 503;
/*     */   public static final int REQ_BROWSER_RESET = 504;
/*     */   public static final int REQ_CLOSING = 601;
/*     */   public static final int REQ_CLOSE = 602;
/*     */   public static final int NULL_RESPONSE = 100001;
/*     */   public static final int RESP_CONNECTIONFACTORY_CREATECONNECTIONDELEGATE = 100100;
/*     */   public static final int RESP_CONNECTIONFACTORY_GETIDBLOCK = 100101;
/*     */   public static final int RESP_CONNECTIONFACTORY_GETCLIENTAOPSTACK = 100102;
/*     */   public static final int RESP_CONNECTIONFACTORY_GETTOPOLOGY = 100105;
/*     */   public static final int RESP_CONNECTION_CREATESESSIONDELEGATE = 100200;
/*     */   public static final int RESP_CONNECTION_GETCLIENTID = 100201;
/*     */   public static final int RESP_CONNECTION_GETPREPAREDTRANSACTIONS = 100202;
/*     */   public static final int RESP_SESSION_CREATECONSUMERDELEGATE = 100300;
/*     */   public static final int RESP_SESSION_CREATEBROWSERDELEGATE = 100301;
/*     */   public static final int RESP_SESSION_CREATEQUEUE = 100302;
/*     */   public static final int RESP_SESSION_CREATETOPIC = 100303;
/*     */   public static final int RESP_SESSION_ACKNOWLEDGEDELIVERY = 100304;
/*     */   public static final int RESP_BROWSER_NEXTMESSAGE = 100500;
/*     */   public static final int RESP_BROWSER_HASNEXTMESSAGE = 100501;
/*     */   public static final int RESP_BROWSER_NEXTMESSAGEBLOCK = 100502;
/*     */   public static final int RESP_CLOSING = 100601;
/*     */   protected int methodId;
/*     */ 
/*     */   public static PacketSupport createPacket(int id)
/*     */   {
/*     */     PacketSupport packet;
/* 175 */     switch (id)
/*     */     {
/*     */     case 2:
/* 179 */       packet = new ClientDelivery();
/* 180 */       break;
/*     */     case 312:
/* 182 */       packet = new SessionSendRequest();
/* 183 */       break;
/*     */     case 306:
/* 185 */       packet = new SessionAcknowledgeDeliveryRequest();
/* 186 */       break;
/*     */     case 305:
/* 188 */       packet = new SessionAcknowledgeDeliveriesRequest();
/* 189 */       break;
/*     */     case 206:
/* 191 */       packet = new ConnectionSendTransactionRequest();
/* 192 */       break;
/*     */     case 401:
/* 194 */       packet = new ConsumerChangeRateRequest();
/* 195 */       break;
/*     */     case 100001:
/* 197 */       packet = new NullResponse();
/* 198 */       break;
/*     */     case 100:
/* 207 */       packet = new ConnectionFactoryCreateConnectionDelegateRequest();
/* 208 */       break;
/*     */     case 101:
/* 210 */       packet = new ConnectionGetIDBlockRequest();
/* 211 */       break;
/*     */     case 102:
/* 213 */       packet = new ConnectionFactoryGetClientAOPStackRequest();
/* 214 */       break;
/*     */     case 103:
/* 216 */       packet = new ConnectionFactoryAddCallbackRequest();
/* 217 */       break;
/*     */     case 104:
/* 219 */       packet = new ConnectionFactoryRemoveCallbackRequest();
/* 220 */       break;
/*     */     case 105:
/* 222 */       packet = new ConnectionFactoryGetTopologyRequest();
/* 223 */       break;
/*     */     case 201:
/* 227 */       packet = new ConnectionCreateSessionDelegateRequest();
/* 228 */       break;
/*     */     case 202:
/* 230 */       packet = new ConnectionGetClientIDRequest();
/* 231 */       break;
/*     */     case 203:
/* 233 */       packet = new ConnectionSetClientIDRequest();
/* 234 */       break;
/*     */     case 204:
/* 236 */       packet = new ConnectionStartRequest();
/* 237 */       break;
/*     */     case 205:
/* 239 */       packet = new ConnectionStopRequest();
/* 240 */       break;
/*     */     case 207:
/* 242 */       packet = new ConnectionGetPreparedTransactionsRequest();
/* 243 */       break;
/*     */     case 301:
/* 247 */       packet = new SessionCreateConsumerDelegateRequest();
/* 248 */       break;
/*     */     case 302:
/* 250 */       packet = new SessionCreateBrowserDelegateRequest();
/* 251 */       break;
/*     */     case 303:
/* 253 */       packet = new SessionCreateQueueRequest();
/* 254 */       break;
/*     */     case 304:
/* 256 */       packet = new SessionCreateTopicRequest();
/* 257 */       break;
/*     */     case 307:
/* 260 */       packet = new SessionCancelDeliveriesRequest();
/* 261 */       break;
/*     */     case 308:
/* 263 */       packet = new SessionCancelDeliveryRequest();
/* 264 */       break;
/*     */     case 309:
/* 266 */       packet = new SessionAddTemporaryDestinationRequest();
/* 267 */       break;
/*     */     case 310:
/* 269 */       packet = new SessionDeleteTemporaryDestinationRequest();
/* 270 */       break;
/*     */     case 311:
/* 272 */       packet = new SessionUnsubscribeRequest();
/* 273 */       break;
/*     */     case 313:
/* 276 */       packet = new SessionRecoverDeliveriesRequest();
/* 277 */       break;
/*     */     case 501:
/* 284 */       packet = new BrowserNextMessageRequest();
/* 285 */       break;
/*     */     case 502:
/* 287 */       packet = new BrowserHasNextMessageRequest();
/* 288 */       break;
/*     */     case 503:
/* 290 */       packet = new BrowserNextMessageBlockRequest();
/* 291 */       break;
/*     */     case 504:
/* 293 */       packet = new BrowserResetRequest();
/* 294 */       break;
/*     */     case 602:
/* 300 */       packet = new CloseRequest();
/* 301 */       break;
/*     */     case 601:
/* 303 */       packet = new ClosingRequest();
/* 304 */       break;
/*     */     case 100100:
/* 312 */       packet = new ConnectionFactoryCreateConnectionDelegateResponse();
/* 313 */       break;
/*     */     case 100101:
/* 315 */       packet = new ConnectionGetIDBlockResponse();
/* 316 */       break;
/*     */     case 100102:
/* 318 */       packet = new ConnectionFactoryGetClientAOPStackResponse();
/* 319 */       break;
/*     */     case 100105:
/* 321 */       packet = new ConnectionFactoryGetTopologyResponse();
/* 322 */       break;
/*     */     case 100200:
/* 326 */       packet = new ConnectionCreateSessionDelegateResponse();
/* 327 */       break;
/*     */     case 100201:
/* 329 */       packet = new ConnectionGetClientIDResponse();
/* 330 */       break;
/*     */     case 100202:
/* 332 */       packet = new ConnectionGetPreparedTransactionsResponse();
/* 333 */       break;
/*     */     case 100300:
/* 337 */       packet = new SessionCreateConsumerDelegateResponse();
/* 338 */       break;
/*     */     case 100301:
/* 340 */       packet = new SessionCreateBrowserDelegateResponse();
/* 341 */       break;
/*     */     case 100302:
/* 343 */       packet = new SessionCreateQueueResponse();
/* 344 */       break;
/*     */     case 100303:
/* 346 */       packet = new SessionCreateTopicResponse();
/* 347 */       break;
/*     */     case 100304:
/* 349 */       packet = new SessionAcknowledgeDeliveryResponse();
/* 350 */       break;
/*     */     case 100500:
/* 355 */       packet = new BrowserNextMessageResponse();
/* 356 */       break;
/*     */     case 100501:
/* 358 */       packet = new BrowserHasNextMessageResponse();
/* 359 */       break;
/*     */     case 100502:
/* 361 */       packet = new BrowserNextMessageBlockResponse();
/* 362 */       break;
/*     */     case 100601:
/* 365 */       packet = new ClosingResponse();
/* 366 */       break;
/*     */     case 1:
/* 369 */       packet = new SerializedPacket();
/* 370 */       break;
/*     */     case 3:
/* 372 */       packet = new ConnectionFactoryUpdate();
/* 373 */       break;
/*     */     case 4:
/* 375 */       packet = new PolledCallbacksDelivery();
/* 376 */       break;
/*     */     default:
/* 379 */       throw new IllegalArgumentException("Invalid packet type: " + id);
/*     */     }
/*     */ 
/* 382 */     return packet;
/*     */   }
/*     */ 
/*     */   public PacketSupport()
/*     */   {
/*     */   }
/*     */ 
/*     */   public PacketSupport(int methodID)
/*     */   {
/* 393 */     this.methodId = methodID;
/*     */   }
/*     */ 
/*     */   public Object getPayload()
/*     */   {
/* 398 */     return this;
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/* 403 */     os.writeInt(this.methodId);
/*     */   }
/*     */ 
/*     */   public abstract void read(DataInputStream paramDataInputStream) throws Exception;
/*     */ 
/*     */   protected void writeNullableString(String s, DataOutputStream os) throws Exception {
/* 410 */     if (s == null)
/*     */     {
/* 412 */       os.writeByte(0);
/*     */     }
/*     */     else
/*     */     {
/* 416 */       os.writeByte(1);
/*     */ 
/* 418 */       os.writeUTF(s);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String readNullableString(DataInputStream is) throws Exception
/*     */   {
/* 424 */     byte b = is.readByte();
/*     */ 
/* 426 */     if (b == 0)
/*     */     {
/* 428 */       return null;
/*     */     }
/*     */ 
/* 432 */     return is.readUTF();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  52 */     ONE_WAY_METADATA.put("oneway", "true");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.PacketSupport
 * JD-Core Version:    0.6.0
 */