/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvocationResponse;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.invocation.InternalInvocation;
/*     */ import org.jboss.remoting.invocation.OnewayInvocation;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ 
/*     */ public class JMSWireFormat
/*     */   implements Marshaller, UnMarshaller
/*     */ {
/*     */   private static final long serialVersionUID = -7646123424863782043L;
/*  65 */   private static final Logger log = Logger.getLogger(JMSWireFormat.class);
/*     */   protected boolean trace;
/*     */ 
/*     */   public JMSWireFormat()
/*     */   {
/*  77 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public void write(Object obj, OutputStream out)
/*     */     throws IOException
/*     */   {
/*  84 */     if (this.trace) log.trace("Writing " + obj);
/*     */     DataOutputStream dos;
/*  88 */     if ((out instanceof DataOutputStream))
/*     */     {
/*  92 */       DataOutputStream dos = (DataOutputStream)out;
/*     */ 
/*  94 */       if (this.trace) log.trace("Stream is a DataOutputStream");
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/*  99 */       if ((out instanceof ObjectOutputStream))
/*     */       {
/* 101 */         throw new IllegalArgumentException("Invalid stream - are you sure you have configured socket wrappers?");
/*     */       }
/*     */ 
/* 111 */       dos = new DataOutputStream(out);
/*     */ 
/* 113 */       if (this.trace) log.trace("Stream is NOT a DataOutputStream - must be using HTTP transport");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 118 */       PacketSupport packet = null;
/*     */ 
/* 120 */       if ((obj instanceof InvocationRequest))
/*     */       {
/* 122 */         InvocationRequest req = (InvocationRequest)obj;
/*     */ 
/* 124 */         Object param = req.getParameter();
/*     */ 
/* 126 */         if ((param instanceof PacketSupport))
/*     */         {
/* 129 */           packet = (PacketSupport)param;
/*     */ 
/* 131 */           if (this.trace) log.trace("JBM Request");
/*     */         }
/* 133 */         else if ((param instanceof OnewayInvocation))
/*     */         {
/* 135 */           if (this.trace) log.trace("It's a OnewayInvocation");
/*     */ 
/* 143 */           OnewayInvocation oneWay = (OnewayInvocation)param;
/*     */ 
/* 145 */           param = oneWay.getParameters()[0];
/*     */ 
/* 147 */           if ((param instanceof RequestSupport))
/*     */           {
/* 151 */             if (this.trace) log.trace("JBM oneway request");
/*     */ 
/* 153 */             packet = (PacketSupport)param;
/*     */           }
/* 155 */           else if ((param instanceof InternalInvocation))
/*     */           {
/* 157 */             InternalInvocation ii = (InternalInvocation)param;
/*     */ 
/* 159 */             Object[] params = ii.getParameters();
/*     */ 
/* 161 */             if (this.trace) log.trace("Params is " + params);
/*     */ 
/* 163 */             if ((params != null) && (params.length > 0) && ((params[0] instanceof Callback)))
/*     */             {
/* 165 */               Callback callback = (Callback)params[0];
/*     */ 
/* 167 */               if (this.trace) log.trace("It's a callback: " + callback);
/*     */ 
/* 169 */               if ((callback.getParameter() instanceof ClientDelivery))
/*     */               {
/* 171 */                 packet = (ClientDelivery)callback.getParameter();
/*     */ 
/* 173 */                 if (this.trace) log.trace("Message delivery callback");
/*     */               }
/* 175 */               else if ((callback.getParameter() instanceof ConnectionFactoryUpdate))
/*     */               {
/* 177 */                 packet = (ConnectionFactoryUpdate)callback.getParameter();
/*     */ 
/* 179 */                 if (this.trace) log.trace("Connection factory update callback");
/*     */               }
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 185 */             throw new IllegalArgumentException("Invalid request param " + param);
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 192 */           packet = new SerializedPacket(req);
/*     */         }
/*     */       }
/* 195 */       else if ((obj instanceof InvocationResponse))
/*     */       {
/* 197 */         InvocationResponse resp = (InvocationResponse)obj;
/*     */ 
/* 199 */         Object param = resp.getResult();
/*     */ 
/* 201 */         if ((param instanceof ResponseSupport))
/*     */         {
/* 205 */           packet = (ResponseSupport)param;
/*     */ 
/* 207 */           if (this.trace) log.trace("JBM Response");
/*     */         }
/* 209 */         else if ((param instanceof List))
/*     */         {
/* 214 */           packet = new PolledCallbacksDelivery((List)param, resp.getSessionId());
/*     */         }
/* 216 */         else if (param == null)
/*     */         {
/* 219 */           packet = new NullResponse();
/*     */ 
/* 221 */           if (this.trace) log.trace("Null Response");
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 226 */           packet = new SerializedPacket(obj);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 232 */         packet = new SerializedPacket(obj);
/*     */       }
/*     */ 
/* 235 */       if (this.trace) log.trace("Writing packet: " + packet);
/*     */ 
/* 237 */       packet.write(dos);
/*     */ 
/* 239 */       if (this.trace) log.trace("Wrote packet");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 243 */       IOException e2 = new IOException(e.getMessage());
/* 244 */       e2.setStackTrace(e.getStackTrace());
/* 245 */       throw e2;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Marshaller cloneMarshaller() throws CloneNotSupportedException
/*     */   {
/* 251 */     return this;
/*     */   }
/*     */ 
/*     */   public Object read(InputStream in, Map map)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 258 */     if (this.trace) log.trace("Reading");
/*     */     DataInputStream dis;
/* 262 */     if ((in instanceof DataInputStream))
/*     */     {
/* 266 */       DataInputStream dis = (DataInputStream)in;
/*     */ 
/* 268 */       if (this.trace) log.trace("Stream is already DataInputStream :)");
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 273 */       if ((in instanceof ObjectInputStream))
/*     */       {
/* 275 */         throw new IllegalArgumentException("Invalid stream - are you sure you have configured socket wrappers?");
/*     */       }
/*     */ 
/* 283 */       dis = new DataInputStream(in);
/*     */ 
/* 285 */       if (this.trace) log.trace("Stream is NOT DataInputStream - must be using HTTP transport");
/*     */     }
/*     */ 
/* 288 */     int id = dis.readInt();
/*     */ 
/* 290 */     PacketSupport packet = PacketSupport.createPacket(id);
/*     */ 
/* 292 */     if (this.trace) log.trace("Created packet " + packet);
/*     */ 
/*     */     try
/*     */     {
/* 296 */       if (this.trace) log.trace("Reading packet");
/*     */ 
/* 298 */       packet.read(dis);
/*     */ 
/* 300 */       if (this.trace) log.trace("Read packet");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 304 */       IOException e2 = new IOException(e.getMessage());
/* 305 */       e2.setStackTrace(e.getStackTrace());
/* 306 */       throw e2;
/*     */     }
/*     */ 
/* 309 */     Object payload = packet.getPayload();
/*     */ 
/* 311 */     if (this.trace) log.trace("Returning payload: " + payload);
/*     */ 
/* 313 */     return payload;
/*     */   }
/*     */ 
/*     */   public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException
/*     */   {
/* 318 */     return this;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader classloader)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.JMSWireFormat
 * JD-Core Version:    0.6.0
 */