/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.delegate.ConnectionEndpoint;
/*    */ import org.jboss.jms.tx.TransactionRequest;
/*    */ 
/*    */ public class ConnectionSendTransactionRequest extends RequestSupport
/*    */ {
/*    */   private TransactionRequest req;
/*    */   private boolean checkForDuplicates;
/*    */ 
/*    */   public ConnectionSendTransactionRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public ConnectionSendTransactionRequest(String objectId, byte version, TransactionRequest req, boolean checkForDuplicates)
/*    */   {
/* 55 */     super(objectId, 206, version);
/*    */ 
/* 57 */     this.req = req;
/* 58 */     this.checkForDuplicates = checkForDuplicates;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 63 */     super.read(is);
/*    */ 
/* 65 */     this.req = new TransactionRequest();
/*    */ 
/* 67 */     this.req.read(is);
/*    */ 
/* 69 */     this.checkForDuplicates = is.readBoolean();
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 74 */     ConnectionEndpoint endpoint = (ConnectionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 77 */     if (endpoint == null)
/*    */     {
/* 79 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 82 */     endpoint.sendTransaction(this.req, this.checkForDuplicates);
/*    */ 
/* 84 */     return null;
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 89 */     super.write(os);
/*    */ 
/* 91 */     this.req.write(os);
/*    */ 
/* 93 */     os.writeBoolean(this.checkForDuplicates);
/*    */ 
/* 95 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.ConnectionSendTransactionRequest
 * JD-Core Version:    0.6.0
 */