/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.server.endpoint.advised.ConnectionFactoryAdvised;
/*    */ import org.jboss.messaging.util.Version;
/*    */ 
/*    */ public class ConnectionFactoryRemoveCallbackRequest extends CallbackRequestSupport
/*    */ {
/*    */   public ConnectionFactoryRemoveCallbackRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public ConnectionFactoryRemoveCallbackRequest(String jvmSessionId, String remotingSessionId, String objectId, byte version)
/*    */   {
/* 52 */     super(jvmSessionId, remotingSessionId, objectId, 104, Version.instance().getProviderIncrementingVersion());
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os)
/*    */     throws Exception
/*    */   {
/* 58 */     super.write(os);
/* 59 */     os.flush();
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 64 */     super.read(is);
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 69 */     ConnectionFactoryAdvised advised = (ConnectionFactoryAdvised)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 72 */     if (advised == null)
/*    */     {
/* 74 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 77 */     advised.removeCallback(getClientVMID(), getRemotingSessionID(), getCallbackHandler());
/*    */ 
/* 80 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.ConnectionFactoryRemoveCallbackRequest
 * JD-Core Version:    0.6.0
 */