/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.jms.delegate.CreateConnectionResult;
/*     */ import org.jboss.jms.server.endpoint.advised.ConnectionFactoryAdvised;
/*     */ import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
/*     */ 
/*     */ public class ConnectionFactoryCreateConnectionDelegateRequest extends CallbackRequestSupport
/*     */ {
/*     */   private String username;
/*     */   private String password;
/*     */   private int failedNodeId;
/*     */   private transient ServerInvokerCallbackHandler callbackHandler;
/*     */ 
/*     */   public ConnectionFactoryCreateConnectionDelegateRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ConnectionFactoryCreateConnectionDelegateRequest(String objectId, byte version, String remotingSessionId, String clientVMId, String username, String password, int failedNodeId)
/*     */   {
/*  61 */     super(clientVMId, remotingSessionId, objectId, 100, version);
/*     */ 
/*  63 */     this.username = username;
/*     */ 
/*  65 */     this.password = password;
/*     */ 
/*  67 */     this.failedNodeId = failedNodeId;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/*  72 */     super.read(is);
/*     */ 
/*  74 */     this.username = readNullableString(is);
/*     */ 
/*  76 */     this.password = readNullableString(is);
/*     */ 
/*  78 */     this.failedNodeId = is.readInt();
/*     */   }
/*     */ 
/*     */   public ResponseSupport serverInvoke() throws Exception
/*     */   {
/*  83 */     ConnectionFactoryAdvised advised = (ConnectionFactoryAdvised)Dispatcher.instance.getTarget(this.objectId);
/*     */ 
/*  86 */     if (advised == null)
/*     */     {
/*  88 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*     */     }
/*     */ 
/*  91 */     CreateConnectionResult del = advised.createConnectionDelegate(this.username, this.password, this.failedNodeId, getRemotingSessionID(), getClientVMID(), this.version, this.callbackHandler);
/*     */ 
/*  96 */     return new ConnectionFactoryCreateConnectionDelegateResponse(del);
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/* 101 */     super.write(os);
/*     */ 
/* 105 */     writeNullableString(this.username, os);
/*     */ 
/* 107 */     writeNullableString(this.password, os);
/*     */ 
/* 109 */     os.writeInt(this.failedNodeId);
/*     */ 
/* 111 */     os.flush();
/*     */   }
/*     */ 
/*     */   public ServerInvokerCallbackHandler getCallbackHandler()
/*     */   {
/* 116 */     return this.callbackHandler;
/*     */   }
/*     */ 
/*     */   public void setCallbackHandler(ServerInvokerCallbackHandler handler)
/*     */   {
/* 121 */     this.callbackHandler = handler;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateRequest
 * JD-Core Version:    0.6.0
 */