/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.server.endpoint.advised.ConnectionFactoryAdvised;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class ConnectionFactoryAddCallbackRequest extends CallbackRequestSupport
/*    */ {
/* 39 */   private static final Logger log = Logger.getLogger(ConnectionFactoryAddCallbackRequest.class);
/*    */ 
/*    */   public ConnectionFactoryAddCallbackRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public ConnectionFactoryAddCallbackRequest(String jvmSessionId, String remotingSessionId, String objectId, byte version)
/*    */   {
/* 56 */     super(jvmSessionId, remotingSessionId, objectId, 103, version);
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke()
/*    */     throws Exception
/*    */   {
/* 71 */     log.debug("serverInvoke callbackHandler=" + getCallbackHandler());
/* 72 */     ConnectionFactoryAdvised advised = (ConnectionFactoryAdvised)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 75 */     if (advised == null)
/*    */     {
/* 77 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 80 */     advised.addCallback(getClientVMID(), getRemotingSessionID(), getCallbackHandler());
/*    */ 
/* 84 */     return null;
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os)
/*    */     throws Exception
/*    */   {
/* 90 */     super.write(os);
/* 91 */     os.flush();
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 96 */     super.read(is);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.ConnectionFactoryAddCallbackRequest
 * JD-Core Version:    0.6.0
 */