/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.jms.client.delegate.ClientSessionDelegate;
/*     */ import org.jboss.jms.delegate.ConnectionEndpoint;
/*     */ 
/*     */ public class ConnectionCreateSessionDelegateRequest extends RequestSupport
/*     */ {
/*     */   private boolean transacted;
/*     */   private int acknowledgmentMode;
/*     */   private boolean xa;
/*     */ 
/*     */   public ConnectionCreateSessionDelegateRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ConnectionCreateSessionDelegateRequest(String objectId, byte version, boolean transacted, int ackMode, boolean xa)
/*     */   {
/*  57 */     super(objectId, 201, version);
/*     */ 
/*  59 */     this.transacted = transacted;
/*     */ 
/*  61 */     this.acknowledgmentMode = ackMode;
/*     */ 
/*  63 */     this.xa = xa;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/*  68 */     super.read(is);
/*     */ 
/*  70 */     this.transacted = is.readBoolean();
/*     */ 
/*  72 */     this.acknowledgmentMode = is.readInt();
/*     */ 
/*  74 */     this.xa = is.readBoolean();
/*     */   }
/*     */ 
/*     */   public ResponseSupport serverInvoke() throws Exception
/*     */   {
/*  79 */     ConnectionEndpoint endpoint = (ConnectionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*     */ 
/*  82 */     if (endpoint == null)
/*     */     {
/*  84 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*     */     }
/*     */ 
/*  87 */     return new ConnectionCreateSessionDelegateResponse((ClientSessionDelegate)endpoint.createSessionDelegate(this.transacted, this.acknowledgmentMode, this.xa));
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/*  92 */     super.write(os);
/*     */ 
/*  96 */     os.writeBoolean(this.transacted);
/*     */ 
/*  98 */     os.writeInt(this.acknowledgmentMode);
/*     */ 
/* 100 */     os.writeBoolean(this.xa);
/*     */ 
/* 102 */     os.flush();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.ConnectionCreateSessionDelegateRequest
 * JD-Core Version:    0.6.0
 */