/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.client.Closeable;
/*    */ 
/*    */ public class ClosingRequest extends RequestSupport
/*    */ {
/*    */   private long sequence;
/*    */ 
/*    */   public ClosingRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public ClosingRequest(long sequence, String objectId, byte version)
/*    */   {
/* 47 */     super(objectId, 601, version);
/*    */ 
/* 49 */     this.sequence = sequence;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 54 */     super.read(is);
/*    */ 
/* 56 */     this.sequence = is.readLong();
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 61 */     Closeable endpoint = (Closeable)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 63 */     if (endpoint == null)
/*    */     {
/* 65 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 68 */     long id = endpoint.closing(this.sequence);
/*    */ 
/* 70 */     return new ClosingResponse(id);
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 75 */     super.write(os);
/*    */ 
/* 77 */     os.writeLong(this.sequence);
/*    */ 
/* 79 */     os.flush();
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 84 */     return "ClosingRequest[ID=" + this.objectId + ", ver=" + this.version + "]";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.ClosingRequest
 * JD-Core Version:    0.6.0
 */