/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ import org.jboss.messaging.core.impl.message.MessageFactory;
/*     */ 
/*     */ public class ClientDelivery extends CallbackSupport
/*     */ {
/*     */   private Message msg;
/*     */   private String consumerId;
/*     */   private long deliveryId;
/*     */   private int deliveryCount;
/*     */ 
/*     */   public ClientDelivery()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ClientDelivery(Message msg, String consumerId, long deliveryId, int deliveryCount)
/*     */   {
/*  65 */     super(2);
/*     */ 
/*  67 */     this.msg = msg;
/*     */ 
/*  69 */     this.consumerId = consumerId;
/*     */ 
/*  71 */     this.deliveryId = deliveryId;
/*     */ 
/*  73 */     this.deliveryCount = deliveryCount;
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out)
/*     */     throws Exception
/*     */   {
/*  81 */     super.write(out);
/*     */ 
/*  83 */     out.writeUTF(this.consumerId);
/*     */ 
/*  85 */     out.writeInt(this.deliveryCount);
/*     */ 
/*  87 */     out.writeLong(this.deliveryId);
/*     */ 
/*  89 */     out.writeByte(this.msg.getType());
/*     */ 
/*  91 */     this.msg.write(out);
/*     */ 
/*  93 */     out.flush();
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in) throws Exception
/*     */   {
/*  98 */     this.consumerId = in.readUTF();
/*     */ 
/* 100 */     this.deliveryCount = in.readInt();
/*     */ 
/* 102 */     this.deliveryId = in.readLong();
/*     */ 
/* 104 */     byte type = in.readByte();
/*     */ 
/* 106 */     this.msg = MessageFactory.createMessage(type);
/*     */ 
/* 108 */     this.msg.read(in);
/*     */   }
/*     */ 
/*     */   public Message getMessage()
/*     */   {
/* 115 */     return this.msg;
/*     */   }
/*     */ 
/*     */   public String getConsumerId()
/*     */   {
/* 120 */     return this.consumerId;
/*     */   }
/*     */ 
/*     */   public long getDeliveryId()
/*     */   {
/* 125 */     return this.deliveryId;
/*     */   }
/*     */ 
/*     */   public int getDeliveryCount()
/*     */   {
/* 130 */     return this.deliveryCount;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 135 */     return "ClientDelivery[" + this.msg + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.ClientDelivery
 * JD-Core Version:    0.6.0
 */