/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.message.JBossMessage;
/*    */ import org.jboss.messaging.core.impl.message.MessageFactory;
/*    */ 
/*    */ public class BrowserNextMessageBlockResponse extends ResponseSupport
/*    */ {
/*    */   private JBossMessage[] msgs;
/*    */ 
/*    */   public BrowserNextMessageBlockResponse()
/*    */   {
/*    */   }
/*    */ 
/*    */   public BrowserNextMessageBlockResponse(JBossMessage[] msgs)
/*    */   {
/* 50 */     super(100502);
/*    */ 
/* 52 */     this.msgs = msgs;
/*    */   }
/*    */ 
/*    */   public Object getResponse()
/*    */   {
/* 57 */     return this.msgs;
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 62 */     super.write(os);
/*    */ 
/* 64 */     int len = this.msgs.length;
/*    */ 
/* 66 */     os.writeInt(len);
/*    */ 
/* 68 */     for (int i = 0; i < len; i++)
/*    */     {
/* 70 */       JBossMessage msg = this.msgs[i];
/*    */ 
/* 72 */       os.writeByte(msg.getType());
/*    */ 
/* 74 */       msg.write(os);
/*    */     }
/*    */ 
/* 77 */     os.flush();
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 82 */     int len = is.readInt();
/*    */ 
/* 84 */     for (int i = 0; i < len; i++)
/*    */     {
/* 86 */       byte type = is.readByte();
/*    */ 
/* 88 */       JBossMessage msg = (JBossMessage)MessageFactory.createMessage(type);
/*    */ 
/* 90 */       msg.read(is);
/*    */ 
/* 92 */       this.msgs[i] = msg;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.BrowserNextMessageBlockResponse
 * JD-Core Version:    0.6.0
 */