/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.delegate.BrowserEndpoint;
/*    */ 
/*    */ public class BrowserNextMessageBlockRequest extends RequestSupport
/*    */ {
/*    */   private int maxMessages;
/*    */ 
/*    */   public BrowserNextMessageBlockRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public BrowserNextMessageBlockRequest(String objectId, byte version, int maxMessages)
/*    */   {
/* 52 */     super(objectId, 503, version);
/*    */ 
/* 54 */     this.maxMessages = maxMessages;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 59 */     super.read(is);
/*    */ 
/* 61 */     this.maxMessages = is.readInt();
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 66 */     BrowserEndpoint endpoint = (BrowserEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 69 */     if (endpoint == null)
/*    */     {
/* 71 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 74 */     return new BrowserNextMessageBlockResponse(endpoint.nextMessageBlock(this.maxMessages));
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 79 */     super.write(os);
/*    */ 
/* 81 */     os.writeInt(this.maxMessages);
/*    */ 
/* 83 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.BrowserNextMessageBlockRequest
 * JD-Core Version:    0.6.0
 */