/*     */ package org.jboss.jms.tx;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ResourceManagerFactory
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(ResourceManagerFactory.class);
/*     */ 
/*  54 */   public static ResourceManagerFactory instance = new ResourceManagerFactory();
/*     */   private Map holders;
/*     */ 
/*     */   private ResourceManagerFactory()
/*     */   {
/*  64 */     this.holders = new HashMap();
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/*  71 */     this.holders.clear();
/*     */   }
/*     */ 
/*     */   public synchronized int size()
/*     */   {
/*  76 */     return this.holders.size();
/*     */   }
/*     */ 
/*     */   public synchronized boolean containsResourceManager(int serverID)
/*     */   {
/*  81 */     return this.holders.containsKey(new Integer(serverID));
/*     */   }
/*     */ 
/*     */   public synchronized ResourceManager checkOutResourceManager(int serverID)
/*     */   {
/*  89 */     Integer i = new Integer(serverID);
/*     */ 
/*  91 */     Holder h = (Holder)this.holders.get(i);
/*     */ 
/*  93 */     if (h == null)
/*     */     {
/*  95 */       h = new Holder(serverID);
/*  96 */       this.holders.put(i, h);
/*     */     }
/*     */     else
/*     */     {
/* 100 */       h.refCount += 1;
/*     */     }
/*     */ 
/* 103 */     return h.rm;
/*     */   }
/*     */ 
/*     */   public synchronized void checkInResourceManager(int serverID)
/*     */   {
/* 108 */     Integer i = new Integer(serverID);
/* 109 */     Holder h = (Holder)this.holders.get(i);
/*     */ 
/* 111 */     if (h == null)
/*     */     {
/* 113 */       throw new IllegalArgumentException("Cannot find resource manager for server: " + serverID);
/*     */     }
/*     */ 
/* 116 */     h.refCount -= 1;
/*     */ 
/* 118 */     if (h.refCount == 0)
/*     */     {
/* 120 */       this.holders.remove(i);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void handleFailover(int oldServerID, int newServerID)
/*     */   {
/* 130 */     Holder hOld = (Holder)this.holders.remove(new Integer(oldServerID));
/*     */ 
/* 132 */     if (hOld == null)
/*     */     {
/* 137 */       return;
/*     */     }
/*     */ 
/* 140 */     ResourceManager oldRM = hOld.rm;
/* 141 */     ResourceManager newRM = null;
/* 142 */     Holder hNew = (Holder)this.holders.get(new Integer(newServerID));
/*     */ 
/* 144 */     if (hNew != null)
/*     */     {
/* 148 */       newRM = hNew.rm;
/* 149 */       newRM.merge(oldRM);
/*     */     }
/*     */     else
/*     */     {
/* 155 */       Holder h = new Holder(oldRM);
/* 156 */       this.holders.put(new Integer(newServerID), h);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void dump()
/*     */   {
/* 162 */     log.debug("Dumping " + this);
/* 163 */     Iterator iter = this.holders.entrySet().iterator();
/* 164 */     while (iter.hasNext())
/*     */     {
/* 166 */       Map.Entry entry = (Map.Entry)iter.next();
/*     */ 
/* 168 */       log.debug(entry.getKey() + "--->" + entry.getValue());
/*     */     }
/* 170 */     log.debug("End dump");
/*     */   }
/*     */ 
/*     */   private static class Holder
/*     */   {
/*     */     ResourceManager rm;
/* 195 */     int refCount = 1;
/*     */ 
/*     */     Holder(int serverID)
/*     */     {
/* 187 */       this.rm = new ResourceManager(serverID);
/*     */     }
/*     */ 
/*     */     Holder(ResourceManager rm)
/*     */     {
/* 192 */       this.rm = rm;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.tx.ResourceManagerFactory
 * JD-Core Version:    0.6.0
 */