/*     */ package org.jboss.jms.tx;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.Serializable;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ 
/*     */ public class MessagingXid
/*     */   implements Xid, Serializable, Streamable
/*     */ {
/*     */   private static final long serialVersionUID = -1893120702576869245L;
/*     */   private byte[] branchQualifier;
/*     */   private int formatId;
/*     */   private byte[] globalTransactionId;
/*     */   private int hash;
/*     */   private boolean hashCalculated;
/*     */ 
/*     */   public byte[] getBranchQualifier()
/*     */   {
/*  58 */     return this.branchQualifier;
/*     */   }
/*     */ 
/*     */   public int getFormatId()
/*     */   {
/*  63 */     return this.formatId;
/*     */   }
/*     */ 
/*     */   public byte[] getGlobalTransactionId()
/*     */   {
/*  68 */     return this.globalTransactionId;
/*     */   }
/*     */ 
/*     */   public MessagingXid()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MessagingXid(byte[] branchQualifier, int formatId, byte[] globalTransactionId)
/*     */   {
/*  78 */     this.branchQualifier = branchQualifier;
/*  79 */     this.formatId = formatId;
/*  80 */     this.globalTransactionId = globalTransactionId;
/*     */   }
/*     */ 
/*     */   public MessagingXid(Xid other)
/*     */   {
/*  86 */     this.branchQualifier = copyBytes(other.getBranchQualifier());
/*  87 */     this.formatId = other.getFormatId();
/*  88 */     this.globalTransactionId = copyBytes(other.getGlobalTransactionId());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  93 */     if (!this.hashCalculated)
/*     */     {
/*  95 */       calcHash();
/*     */     }
/*  97 */     return this.hash;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 102 */     if (!(other instanceof Streamable))
/*     */     {
/* 104 */       return false;
/*     */     }
/* 106 */     Xid xother = (Streamable)other;
/* 107 */     if (xother.getFormatId() != this.formatId)
/*     */     {
/* 109 */       return false;
/*     */     }
/* 111 */     if (xother.getBranchQualifier().length != this.branchQualifier.length)
/*     */     {
/* 113 */       return false;
/*     */     }
/* 115 */     if (xother.getGlobalTransactionId().length != this.globalTransactionId.length)
/*     */     {
/* 117 */       return false;
/*     */     }
/* 119 */     for (int i = 0; i < this.branchQualifier.length; i++)
/*     */     {
/* 121 */       byte[] otherBQ = xother.getBranchQualifier();
/* 122 */       if (this.branchQualifier[i] != otherBQ[i])
/*     */       {
/* 124 */         return false;
/*     */       }
/*     */     }
/* 127 */     for (int i = 0; i < this.globalTransactionId.length; i++)
/*     */     {
/* 129 */       byte[] otherGtx = xother.getGlobalTransactionId();
/* 130 */       if (this.globalTransactionId[i] != otherGtx[i])
/*     */       {
/* 132 */         return false;
/*     */       }
/*     */     }
/* 135 */     return true;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 140 */     return "MessagingXid (" + System.identityHashCode(this) + " bq:" + stringRep(this.branchQualifier) + " formatID:" + this.formatId + " gtxid:" + stringRep(this.globalTransactionId);
/*     */   }
/*     */ 
/*     */   private String stringRep(byte[] bytes)
/*     */   {
/* 146 */     StringBuffer buff = new StringBuffer();
/* 147 */     for (int i = 0; i < bytes.length; i++)
/*     */     {
/* 149 */       byte b = bytes[i];
/*     */ 
/* 151 */       buff.append(b);
/*     */ 
/* 153 */       if (i == bytes.length - 1)
/*     */         continue;
/* 155 */       buff.append('.');
/*     */     }
/*     */ 
/* 159 */     return buff.toString();
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in) throws Exception
/*     */   {
/* 164 */     int len = in.readInt();
/* 165 */     this.branchQualifier = new byte[len];
/* 166 */     in.readFully(this.branchQualifier);
/*     */ 
/* 168 */     this.formatId = in.readInt();
/*     */ 
/* 170 */     len = in.readInt();
/* 171 */     this.globalTransactionId = new byte[len];
/* 172 */     in.readFully(this.globalTransactionId);
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 177 */     out.writeInt(this.branchQualifier.length);
/* 178 */     out.write(this.branchQualifier);
/*     */ 
/* 180 */     out.writeInt(this.formatId);
/*     */ 
/* 182 */     out.writeInt(this.globalTransactionId.length);
/* 183 */     out.write(this.globalTransactionId);
/*     */   }
/*     */ 
/*     */   private void calcHash()
/*     */   {
/* 188 */     byte[] hashBytes = new byte[this.branchQualifier.length + this.globalTransactionId.length + 4];
/* 189 */     System.arraycopy(this.branchQualifier, 0, hashBytes, 0, this.branchQualifier.length);
/* 190 */     System.arraycopy(this.globalTransactionId, 0, hashBytes, this.branchQualifier.length, this.globalTransactionId.length);
/* 191 */     byte[] intBytes = new byte[4];
/* 192 */     for (int i = 0; i < 4; i++)
/*     */     {
/* 194 */       intBytes[i] = (byte)((this.formatId >> i * 8) % 255);
/*     */     }
/* 196 */     System.arraycopy(intBytes, 0, hashBytes, this.branchQualifier.length + this.globalTransactionId.length, 4);
/* 197 */     String s = new String(hashBytes);
/* 198 */     this.hash = s.hashCode();
/* 199 */     this.hashCalculated = true;
/*     */   }
/*     */ 
/*     */   private byte[] copyBytes(byte[] other)
/*     */   {
/* 204 */     byte[] bytes = new byte[other.length];
/*     */ 
/* 206 */     System.arraycopy(other, 0, bytes, 0, other.length);
/*     */ 
/* 208 */     return bytes;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.tx.MessagingXid
 * JD-Core Version:    0.6.0
 */