/*     */ package org.jboss.jms.tx;
/*     */ 
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.state.HierarchicalState;
/*     */ import org.jboss.jms.client.state.SessionState;
/*     */ import org.jboss.jms.delegate.ConnectionDelegate;
/*     */ import org.jboss.jms.exception.MessagingXAException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MessagingXAResource
/*     */   implements XAResource
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(MessagingXAResource.class);
/*     */ 
/*  61 */   private boolean trace = log.isTraceEnabled();
/*     */   private ResourceManager rm;
/*     */   private SessionState sessionState;
/*     */   private ConnectionDelegate connection;
/*     */   private boolean preventJoining;
/*     */ 
/*     */   public MessagingXAResource(ResourceManager rm, SessionState sessionState)
/*     */   {
/*  78 */     this.rm = rm;
/*     */ 
/*  80 */     this.sessionState = sessionState;
/*     */ 
/*  82 */     this.connection = ((ConnectionDelegate)sessionState.getParent().getDelegate());
/*     */   }
/*     */ 
/*     */   public boolean setTransactionTimeout(int timeout)
/*     */     throws XAException
/*     */   {
/*  89 */     return false;
/*     */   }
/*     */ 
/*     */   public int getTransactionTimeout()
/*     */     throws XAException
/*     */   {
/*  96 */     return 600;
/*     */   }
/*     */ 
/*     */   public boolean isSameRM(XAResource xaResource) throws XAException
/*     */   {
/* 101 */     if (this.preventJoining)
/*     */     {
/* 103 */       return false;
/*     */     }
/*     */ 
/* 106 */     if (!(xaResource instanceof MessagingXAResource))
/*     */     {
/* 108 */       return false;
/*     */     }
/*     */ 
/* 111 */     boolean same = ((MessagingXAResource)xaResource).rm.getServerID() == this.rm.getServerID();
/*     */ 
/* 113 */     if (this.trace) log.trace("Calling isSameRM, result is " + same + " " + ((MessagingXAResource)xaResource).rm.getServerID() + " " + this.rm.getServerID());
/*     */ 
/* 115 */     return same;
/*     */   }
/*     */ 
/*     */   public void start(Xid xid, int flags) throws XAException
/*     */   {
/* 120 */     if (this.trace) log.trace(this + " starting " + xid + ", flags: " + flags);
/*     */ 
/* 124 */     if (!(xid instanceof MessagingXid))
/*     */     {
/* 126 */       xid = new MessagingXid(xid);
/*     */     }
/*     */ 
/* 129 */     boolean convertTx = false;
/*     */ 
/* 131 */     Object currentXid = this.sessionState.getCurrentTxId();
/*     */ 
/* 134 */     if (currentXid == null)
/*     */     {
/* 136 */       throw new MessagingXAException(-7, "Current xid is not set");
/*     */     }
/*     */ 
/* 139 */     if ((flags == 0) && ((this.sessionState.getCurrentTxId() instanceof LocalTx)))
/*     */     {
/* 141 */       convertTx = true;
/*     */ 
/* 143 */       if (this.trace) log.trace("Converting local tx into global tx branch");
/*     */ 
/*     */     }
/*     */ 
/* 147 */     synchronized (this)
/*     */     {
/* 149 */       switch (flags)
/*     */       {
/*     */       case 0:
/* 152 */         if (convertTx)
/*     */         {
/* 161 */           setCurrentTransactionId(this.rm.convertTx((LocalTx)this.sessionState.getCurrentTxId(), xid));
/*     */         }
/*     */         else
/*     */         {
/* 165 */           setCurrentTransactionId(this.rm.startTx(xid));
/*     */         }
/* 167 */         break;
/*     */       case 2097152:
/* 169 */         setCurrentTransactionId(this.rm.joinTx(xid));
/* 170 */         break;
/*     */       case 134217728:
/* 172 */         setCurrentTransactionId(this.rm.resumeTx(xid));
/* 173 */         break;
/*     */       default:
/* 175 */         throw new MessagingXAException(-6, "Invalid flags: " + flags);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void end(Xid xid, int flags) throws XAException
/*     */   {
/* 182 */     if (this.trace) log.trace(this + " ending " + xid + ", flags: " + flags);
/*     */ 
/* 186 */     if (!(xid instanceof MessagingXid))
/*     */     {
/* 188 */       xid = new MessagingXid(xid);
/*     */     }
/*     */ 
/* 192 */     synchronized (this)
/*     */     {
/* 194 */       unsetCurrentTransactionId(xid);
/*     */ 
/* 196 */       switch (flags)
/*     */       {
/*     */       case 33554432:
/* 199 */         this.rm.suspendTx(xid);
/* 200 */         break;
/*     */       case 536870912:
/* 202 */         this.rm.endTx(xid, false);
/* 203 */         break;
/*     */       case 67108864:
/* 205 */         this.rm.endTx(xid, true);
/* 206 */         break;
/*     */       default:
/* 208 */         throw new MessagingXAException(-6, "Invalid flags: " + flags);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int prepare(Xid xid) throws XAException
/*     */   {
/* 215 */     if (this.trace) log.trace(this + " preparing " + xid);
/*     */ 
/* 219 */     if (!(xid instanceof MessagingXid))
/*     */     {
/* 221 */       xid = new MessagingXid(xid);
/*     */     }
/*     */ 
/* 224 */     return this.rm.prepare(xid, this.connection);
/*     */   }
/*     */ 
/*     */   public void commit(Xid xid, boolean onePhase) throws XAException
/*     */   {
/* 229 */     if (this.trace) log.trace(this + " committing " + xid + (onePhase ? " (one phase)" : " (two phase)"));
/*     */ 
/* 233 */     if (!(xid instanceof MessagingXid))
/*     */     {
/* 235 */       xid = new MessagingXid(xid);
/*     */     }
/*     */ 
/* 238 */     this.rm.commit(xid, onePhase, this.connection);
/*     */   }
/*     */ 
/*     */   public void rollback(Xid xid) throws XAException
/*     */   {
/* 243 */     if (this.trace) log.trace(this + " rolling back " + xid);
/*     */ 
/* 247 */     if (!(xid instanceof MessagingXid))
/*     */     {
/* 249 */       xid = new MessagingXid(xid);
/*     */     }
/*     */ 
/* 252 */     this.rm.rollback(xid, this.connection);
/*     */   }
/*     */ 
/*     */   public void forget(Xid xid) throws XAException
/*     */   {
/* 257 */     if (this.trace) log.trace(this + " forgetting " + xid + " (currently an NOOP)"); 
/*     */   }
/*     */ 
/*     */   public Xid[] recover(int flags)
/*     */     throws XAException
/*     */   {
/* 262 */     if (this.trace) log.trace(this + " recovering, flags: " + flags);
/*     */ 
/* 264 */     Xid[] xids = this.rm.recover(flags, this.connection);
/*     */ 
/* 266 */     if (this.trace) log.trace("Recovered txs: " + xids);
/*     */ 
/* 268 */     return xids;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 275 */     return "MessagingXAResource[" + this.sessionState.getDelegate().getID() + "]";
/*     */   }
/*     */ 
/*     */   public void setPreventJoining(boolean preventJoining)
/*     */   {
/* 286 */     this.preventJoining = preventJoining;
/*     */   }
/*     */ 
/*     */   private void setCurrentTransactionId(Object xid)
/*     */   {
/* 297 */     if (this.trace) log.trace(this + " setting current xid to " + xid + ",  previous " + this.sessionState.getCurrentTxId());
/*     */ 
/* 299 */     this.sessionState.setCurrentTxId(xid);
/*     */   }
/*     */ 
/*     */   private void unsetCurrentTransactionId(Object xid)
/*     */   {
/* 304 */     if (xid == null)
/*     */     {
/* 306 */       throw new IllegalArgumentException("xid must be not null");
/*     */     }
/*     */ 
/* 309 */     if (this.trace) log.trace(this + " unsetting current xid " + xid + ",  previous " + this.sessionState.getCurrentTxId());
/*     */ 
/* 313 */     if (xid.equals(this.sessionState.getCurrentTxId()))
/*     */     {
/* 324 */       this.sessionState.setCurrentTxId(this.rm.createLocalTx());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.tx.MessagingXAResource
 * JD-Core Version:    0.6.0
 */