/*     */ package org.jboss.jms.tx;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.jms.delegate.Ack;
/*     */ import org.jboss.jms.delegate.DefaultAck;
/*     */ import org.jboss.jms.delegate.DeliveryInfo;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.message.MessageProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.impl.message.MessageFactory;
/*     */ 
/*     */ public class ClientTransaction
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(ClientTransaction.class);
/*     */   public static final byte TX_OPEN = 0;
/*     */   public static final byte TX_ENDED = 1;
/*     */   public static final byte TX_PREPARED = 2;
/*     */   public static final byte TX_COMMITED = 3;
/*     */   public static final byte TX_ROLLEDBACK = 4;
/*  57 */   private static boolean trace = log.isTraceEnabled();
/*     */ 
/*  61 */   private byte state = 0;
/*     */   private Map sessionStatesMap;
/*     */   private List sessionStatesList;
/*     */   private boolean clientSide;
/*     */   private boolean hasPersistentAcks;
/*     */   private boolean failedOver;
/*     */   private boolean removeAcks;
/*     */ 
/*     */   public ClientTransaction()
/*     */   {
/*  84 */     this.clientSide = true;
/*     */   }
/*     */ 
/*     */   public byte getState()
/*     */   {
/*  91 */     return this.state;
/*     */   }
/*     */ 
/*     */   public void addMessage(String sessionId, JBossMessage msg)
/*     */   {
/*  96 */     if (!this.clientSide)
/*     */     {
/*  98 */       throw new IllegalStateException("Cannot call this method on the server side");
/*     */     }
/* 100 */     SessionTxState sessionTxState = getSessionTxState(sessionId);
/*     */ 
/* 102 */     sessionTxState.addMessage(msg);
/*     */   }
/*     */ 
/*     */   public void addAck(String sessionId, DeliveryInfo info)
/*     */   {
/* 107 */     if (!this.clientSide)
/*     */     {
/* 109 */       throw new IllegalStateException("Cannot call this method on the server side");
/*     */     }
/* 111 */     SessionTxState sessionTxState = getSessionTxState(sessionId);
/*     */ 
/* 113 */     sessionTxState.addAck(info);
/*     */ 
/* 115 */     if (info.getMessageProxy().getMessage().isReliable())
/*     */     {
/* 117 */       this.hasPersistentAcks = true;
/*     */     }
/*     */ 
/* 120 */     if (!info.isShouldAck())
/*     */     {
/* 122 */       this.removeAcks = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean hasPersistentAcks()
/*     */   {
/* 128 */     return this.hasPersistentAcks;
/*     */   }
/*     */ 
/*     */   public boolean isFailedOver()
/*     */   {
/* 133 */     return this.failedOver;
/*     */   }
/*     */ 
/*     */   public void clearMessages()
/*     */   {
/* 138 */     if (!this.clientSide)
/*     */     {
/* 140 */       throw new IllegalStateException("Cannot call this method on the server side");
/*     */     }
/*     */     Iterator i;
/* 143 */     if (this.sessionStatesMap != null)
/*     */     {
/* 147 */       for (i = this.sessionStatesMap.values().iterator(); i.hasNext(); )
/*     */       {
/* 149 */         SessionTxState sessionTxState = (SessionTxState)i.next();
/* 150 */         sessionTxState.clearMessages();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setState(byte state)
/*     */   {
/* 157 */     if (!this.clientSide)
/*     */     {
/* 159 */       throw new IllegalStateException("Cannot call this method on the server side");
/*     */     }
/* 161 */     this.state = state;
/*     */   }
/*     */ 
/*     */   public List getSessionStates()
/*     */   {
/* 166 */     if (this.sessionStatesList != null)
/*     */     {
/* 168 */       return this.sessionStatesList;
/*     */     }
/*     */ 
/* 172 */     return this.sessionStatesMap == null ? Collections.EMPTY_LIST : new ArrayList(this.sessionStatesMap.values());
/*     */   }
/*     */ 
/*     */   public void handleFailover(int newServerID, String oldSessionID, String newSessionID)
/*     */   {
/* 182 */     if (!this.clientSide)
/*     */     {
/* 184 */       throw new IllegalStateException("Cannot call this method on the server side");
/*     */     }
/*     */ 
/* 190 */     Map tmpMap = null;
/*     */     Iterator i;
/* 192 */     if (this.sessionStatesMap != null)
/*     */     {
/* 194 */       for (i = this.sessionStatesMap.values().iterator(); i.hasNext(); )
/*     */       {
/* 196 */         SessionTxState state = (SessionTxState)i.next();
/*     */ 
/* 198 */         boolean handled = state.handleFailover(newServerID, oldSessionID, newSessionID);
/*     */ 
/* 200 */         if (handled)
/*     */         {
/* 202 */           if (tmpMap == null)
/*     */           {
/* 204 */             tmpMap = new LinkedHashMap();
/*     */           }
/* 206 */           tmpMap.put(newSessionID, state);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 211 */     if (tmpMap != null)
/*     */     {
/* 214 */       this.sessionStatesMap = tmpMap;
/*     */     }
/*     */ 
/* 217 */     this.failedOver = true;
/*     */   }
/*     */ 
/*     */   public List getDeliveriesForSession(String sessionID)
/*     */   {
/* 225 */     if (!this.clientSide)
/*     */     {
/* 227 */       throw new IllegalStateException("Cannot call this method on the server side");
/*     */     }
/*     */ 
/* 230 */     if (this.sessionStatesMap == null)
/*     */     {
/* 232 */       return Collections.EMPTY_LIST;
/*     */     }
/*     */ 
/* 236 */     SessionTxState state = (SessionTxState)this.sessionStatesMap.get(sessionID);
/*     */ 
/* 238 */     if (state != null)
/*     */     {
/* 240 */       List list = state.getAcks();
/*     */ 
/* 242 */       return list;
/*     */     }
/*     */ 
/* 246 */     return Collections.EMPTY_LIST;
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out)
/*     */     throws Exception
/*     */   {
/* 255 */     out.writeByte(this.state);
/*     */ 
/* 257 */     if (this.sessionStatesMap == null)
/*     */     {
/* 259 */       out.writeInt(0);
/*     */     }
/*     */     else
/*     */     {
/* 263 */       out.writeInt(this.sessionStatesMap.size());
/*     */ 
/* 265 */       Iterator iter = this.sessionStatesMap.values().iterator();
/*     */ 
/* 267 */       while (iter.hasNext())
/*     */       {
/* 269 */         SessionTxState state = (SessionTxState)iter.next();
/*     */ 
/* 271 */         out.writeUTF(state.getSessionId());
/*     */ 
/* 273 */         List msgs = state.getMsgs();
/*     */ 
/* 275 */         out.writeInt(msgs.size());
/*     */ 
/* 277 */         Iterator iter2 = msgs.iterator();
/*     */ 
/* 279 */         while (iter2.hasNext())
/*     */         {
/* 281 */           JBossMessage m = (JBossMessage)iter2.next();
/*     */ 
/* 283 */           out.writeByte(m.getType());
/*     */ 
/* 285 */           m.write(out);
/*     */         }
/*     */ 
/* 288 */         List acks = state.getAcks();
/*     */ 
/* 290 */         iter2 = acks.iterator();
/*     */ 
/* 292 */         while (iter2.hasNext())
/*     */         {
/* 294 */           DeliveryInfo ack = (DeliveryInfo)iter2.next();
/*     */ 
/* 297 */           if (ack.isShouldAck())
/*     */           {
/* 300 */             out.writeLong(ack.getMessageProxy().getDeliveryId());
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 305 */         out.writeLong(-9223372036854775808L);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in)
/*     */     throws Exception
/*     */   {
/* 313 */     this.clientSide = false;
/*     */ 
/* 315 */     this.state = in.readByte();
/*     */ 
/* 317 */     int numSessions = in.readInt();
/*     */ 
/* 321 */     this.sessionStatesList = new ArrayList(numSessions);
/*     */ 
/* 323 */     for (int i = 0; i < numSessions; i++)
/*     */     {
/* 325 */       String sessionId = in.readUTF();
/*     */ 
/* 327 */       SessionTxState sessionState = new SessionTxState(sessionId);
/*     */ 
/* 329 */       this.sessionStatesList.add(sessionState);
/*     */ 
/* 331 */       int numMsgs = in.readInt();
/*     */ 
/* 333 */       for (int j = 0; j < numMsgs; j++)
/*     */       {
/* 335 */         byte type = in.readByte();
/*     */ 
/* 337 */         JBossMessage msg = (JBossMessage)MessageFactory.createMessage(type);
/*     */ 
/* 339 */         msg.read(in);
/*     */ 
/* 341 */         sessionState.addMessage(msg);
/*     */       }
/*     */       long l;
/* 346 */       while ((l = in.readLong()) != -9223372036854775808L)
/*     */       {
/* 348 */         sessionState.addAck(new DefaultAck(l));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private SessionTxState getSessionTxState(String sessionID)
/*     */   {
/* 361 */     if (this.sessionStatesMap == null)
/*     */     {
/* 363 */       this.sessionStatesMap = new LinkedHashMap();
/*     */     }
/*     */ 
/* 366 */     SessionTxState sessionTxState = (SessionTxState)this.sessionStatesMap.get(sessionID);
/*     */ 
/* 368 */     if (sessionTxState == null)
/*     */     {
/* 370 */       sessionTxState = new SessionTxState(sessionID);
/*     */ 
/* 372 */       this.sessionStatesMap.put(sessionID, sessionTxState);
/*     */     }
/*     */ 
/* 375 */     return sessionTxState;
/*     */   }
/*     */ 
/*     */   public class SessionTxState
/*     */   {
/*     */     private String sessionID;
/* 387 */     private int serverID = -1;
/*     */ 
/* 389 */     private List msgs = new ArrayList();
/* 390 */     private List acks = new ArrayList();
/*     */ 
/*     */     SessionTxState(String sessionID)
/*     */     {
/* 394 */       this.sessionID = sessionID;
/*     */     }
/*     */ 
/*     */     void addMessage(JBossMessage msg)
/*     */     {
/* 399 */       this.msgs.add(msg);
/*     */     }
/*     */ 
/*     */     void addAck(Ack ack)
/*     */     {
/* 404 */       this.acks.add(ack);
/*     */     }
/*     */ 
/*     */     public List getMsgs()
/*     */     {
/* 409 */       return this.msgs;
/*     */     }
/*     */ 
/*     */     public List getAcks()
/*     */     {
/* 414 */       return this.acks;
/*     */     }
/*     */ 
/*     */     public String getSessionId()
/*     */     {
/* 419 */       return this.sessionID;
/*     */     }
/*     */ 
/*     */     public void setAcks(List acks)
/*     */     {
/* 424 */       this.acks = acks;
/*     */     }
/*     */ 
/*     */     boolean handleFailover(int newServerID, String oldSessionID, String newSessionID)
/*     */     {
/* 429 */       if ((this.sessionID.equals(oldSessionID)) && (this.serverID != newServerID))
/*     */       {
/* 431 */         this.sessionID = newSessionID;
/* 432 */         this.serverID = newServerID;
/*     */ 
/* 435 */         for (Iterator i = this.acks.iterator(); i.hasNext(); )
/*     */         {
/* 437 */           DeliveryInfo di = (DeliveryInfo)i.next();
/*     */ 
/* 439 */           if (!di.getMessageProxy().getMessage().isReliable())
/*     */           {
/* 441 */             if (ClientTransaction.trace) ClientTransaction.log.trace(this + " discarded non-persistent " + di + " on failover");
/* 442 */             i.remove();
/*     */           }
/*     */         }
/* 445 */         return true;
/*     */       }
/*     */ 
/* 449 */       return false;
/*     */     }
/*     */ 
/*     */     void clearMessages()
/*     */     {
/* 455 */       this.msgs.clear();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.tx.ClientTransaction
 * JD-Core Version:    0.6.0
 */