/*      */ package org.jboss.jms.server.selector;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.io.StringReader;
/*      */ import java.util.Enumeration;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Vector;
/*      */ 
/*      */ public class SelectorParser
/*      */   implements ISelectorParser, SelectorParserConstants
/*      */ {
/*      */   private static final String LOFFER_L = "l";
/*      */   private static final String UPPER_L = "L";
/*      */   private static final String OX = "0X";
/*      */   private static final String Ox = "0x";
/*      */   private static final String ZERRO = "0";
/*      */   private HashMap identifierMap;
/*      */   public SelectorParserTokenManager token_source;
/*      */   SimpleCharStream jj_input_stream;
/*      */   public Token token;
/*      */   public Token jj_nt;
/*      */   private int jj_ntk;
/*      */   private Token jj_scanpos;
/*      */   private Token jj_lastpos;
/*      */   private int jj_la;
/* 1245 */   public boolean lookingAhead = false;
/*      */   private boolean jj_semLA;
/*      */   private int jj_gen;
/* 1248 */   private final int[] jj_la1 = new int[26];
/*      */   private static int[] jj_la1_0;
/*      */   private static int[] jj_la1_1;
/* 1261 */   private final JJCalls[] jj_2_rtns = new JJCalls[8];
/* 1262 */   private boolean jj_rescan = false;
/* 1263 */   private int jj_gc = 0;
/*      */ 
/* 1348 */   private final LookaheadSuccess jj_ls = new LookaheadSuccess(null);
/*      */ 
/* 1394 */   private Vector jj_expentries = new Vector();
/*      */   private int[] jj_expentry;
/* 1396 */   private int jj_kind = -1;
/* 1397 */   private int[] jj_lasttokens = new int[100];
/*      */   private int jj_endpos;
/*      */ 
/*      */   public SelectorParser()
/*      */   {
/*   32 */     this(new StringReader(""));
/*      */   }
/*      */ 
/*      */   public Object parse(String selector, HashMap identifierMap)
/*      */     throws ParseException
/*      */   {
/*   38 */     return parse(selector, identifierMap, false);
/*      */   }
/*      */ 
/*      */   public Object parse(String selector, HashMap identifierMap, boolean trace)
/*      */     throws ParseException
/*      */   {
/*   44 */     StringReader sr = new StringReader(selector);
/*   45 */     ReInit(sr);
/*      */ 
/*   48 */     if (trace)
/*      */     {
/*   50 */       enable_tracing();
/*      */     }
/*      */     else
/*      */     {
/*   54 */       disable_tracing();
/*      */     }
/*      */ 
/*   57 */     this.identifierMap = identifierMap;
/*   58 */     return expression();
/*      */   }
/*      */ 
/*      */   private String stripQuotes(String image)
/*      */   {
/*   67 */     StringBuffer result = new StringBuffer(image.length() - 2);
/*   68 */     int i = 1;
/*   69 */     boolean escaped = false;
/*   70 */     while (i < image.length() - 1)
/*      */     {
/*   72 */       if (escaped)
/*      */       {
/*   74 */         if (image.charAt(i) == '\'')
/*   75 */           result.append('\'');
/*      */         else
/*   77 */           throw new RuntimeException("Invalid uses of quotes: " + image);
/*   78 */         escaped = false;
/*      */       }
/*   80 */       else if (image.charAt(i) == '\'') {
/*   81 */         escaped = true;
/*      */       } else {
/*   83 */         result.append(image.charAt(i));
/*   84 */       }i++;
/*      */     }
/*   86 */     return result.toString();
/*      */   }
/*      */ 
/*      */   public static Object doParse(String selector, HashMap identifierMap)
/*      */     throws ParseException
/*      */   {
/*   92 */     return doParse(selector, identifierMap, false);
/*      */   }
/*      */ 
/*      */   public static Object doParse(String selector, HashMap identifierMap, boolean trace)
/*      */     throws ParseException
/*      */   {
/*   98 */     SelectorParser parser = new SelectorParser();
/*   99 */     return parser.parse(selector, identifierMap, trace);
/*      */   }
/*      */ 
/*      */   public final Object expression() throws ParseException
/*      */   {
/*  104 */     Object exp1 = null;
/*  105 */     exp1 = selectorExpression();
/*  106 */     jj_consume_token(0);
/*  107 */     return exp1;
/*      */   }
/*      */ 
/*      */   public final Object selectorExpression() throws ParseException
/*      */   {
/*  112 */     Object exp1 = null;
/*  113 */     Object exp2 = null;
/*  114 */     exp1 = selectorTerm();
/*      */     while (true)
/*      */     {
/*  117 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */       {
/*      */       case 11:
/*  120 */         break;
/*      */       default:
/*  122 */         this.jj_la1[0] = this.jj_gen;
/*  123 */         break;
/*      */       }
/*  125 */       jj_consume_token(11);
/*  126 */       exp2 = selectorTerm();
/*  127 */       exp1 = new Operator(3, exp1, exp2);
/*      */     }
/*  129 */     return exp1;
/*      */   }
/*      */ 
/*      */   public final Object selectorTerm() throws ParseException
/*      */   {
/*  134 */     Object exp1 = null;
/*  135 */     Object exp2 = null;
/*  136 */     exp1 = selectorFactor();
/*      */     while (true)
/*      */     {
/*  139 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */       {
/*      */       case 9:
/*  142 */         break;
/*      */       default:
/*  144 */         this.jj_la1[1] = this.jj_gen;
/*  145 */         break;
/*      */       }
/*  147 */       jj_consume_token(9);
/*  148 */       exp2 = selectorFactor();
/*  149 */       exp1 = new Operator(2, exp1, exp2);
/*      */     }
/*  151 */     return exp1;
/*      */   }
/*      */ 
/*      */   public final Object selectorFactor() throws ParseException
/*      */   {
/*  156 */     Object exp1 = null;
/*  157 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 6:
/*      */     case 7:
/*      */     case 17:
/*      */     case 23:
/*      */     case 24:
/*      */     case 31:
/*      */     case 35:
/*      */     case 37:
/*      */     case 38:
/*  167 */       exp1 = conditionalExpression();
/*  168 */       return exp1;
/*      */     case 10:
/*  171 */       jj_consume_token(10);
/*  172 */       exp1 = conditionalExpression();
/*  173 */       exp1 = new Operator(1, exp1);
/*  174 */       return exp1;
/*      */     case 8:
/*      */     case 9:
/*      */     case 11:
/*      */     case 12:
/*      */     case 13:
/*      */     case 14:
/*      */     case 15:
/*      */     case 16:
/*      */     case 18:
/*      */     case 19:
/*      */     case 20:
/*      */     case 21:
/*      */     case 22:
/*      */     case 25:
/*      */     case 26:
/*      */     case 27:
/*      */     case 28:
/*      */     case 29:
/*      */     case 30:
/*      */     case 32:
/*      */     case 33:
/*      */     case 34:
/*  177 */     case 36: } this.jj_la1[2] = this.jj_gen;
/*  178 */     jj_consume_token(-1);
/*  179 */     throw new ParseException();
/*      */   }
/*      */ 
/*      */   public final Object conditionalExpression()
/*      */     throws ParseException
/*      */   {
/*  185 */     Object exp1 = null;
/*  186 */     if (jj_2_1(3)) {
/*  187 */       jj_consume_token(17);
/*  188 */       exp1 = selectorExpression();
/*  189 */       jj_consume_token(18);
/*  190 */       return exp1;
/*      */     }
/*  192 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 6:
/*      */     case 7:
/*      */     case 17:
/*      */     case 23:
/*      */     case 24:
/*      */     case 31:
/*      */     case 35:
/*      */     case 37:
/*      */     case 38:
/*  202 */       exp1 = comparisonExpression();
/*  203 */       return exp1;
/*      */     case 8:
/*      */     case 9:
/*      */     case 10:
/*      */     case 11:
/*      */     case 12:
/*      */     case 13:
/*      */     case 14:
/*      */     case 15:
/*      */     case 16:
/*      */     case 18:
/*      */     case 19:
/*      */     case 20:
/*      */     case 21:
/*      */     case 22:
/*      */     case 25:
/*      */     case 26:
/*      */     case 27:
/*      */     case 28:
/*      */     case 29:
/*      */     case 30:
/*      */     case 32:
/*      */     case 33:
/*      */     case 34:
/*  206 */     case 36: } this.jj_la1[3] = this.jj_gen;
/*  207 */     jj_consume_token(-1);
/*  208 */     throw new ParseException();
/*      */   }
/*      */ 
/*      */   public final Object comparisonExpression()
/*      */     throws ParseException
/*      */   {
/*  215 */     int op = -1;
/*  216 */     HashSet set = null;
/*  217 */     Object exp1 = null;
/*  218 */     Object exp2 = null;
/*  219 */     Object exp3 = null;
/*  220 */     Object id = null;
/*  221 */     Token not = null;
/*  222 */     if (jj_2_2(2147483647)) {
/*  223 */       exp1 = identifier();
/*  224 */       jj_consume_token(15);
/*  225 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 10:
/*  227 */         not = jj_consume_token(10);
/*  228 */         break;
/*      */       default:
/*  230 */         this.jj_la1[4] = this.jj_gen;
/*      */       }
/*      */ 
/*  233 */       jj_consume_token(8);
/*  234 */       int opCode = not == null ? 20 : 21;
/*  235 */       return new Operator(opCode, exp1);
/*  236 */     }if (jj_2_3(2147483647)) {
/*  237 */       id = identifier();
/*  238 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 10:
/*  240 */         not = jj_consume_token(10);
/*  241 */         break;
/*      */       default:
/*  243 */         this.jj_la1[5] = this.jj_gen;
/*      */       }
/*      */ 
/*  246 */       jj_consume_token(14);
/*  247 */       jj_consume_token(17);
/*  248 */       set = new HashSet();
/*  249 */       stringList(set);
/*  250 */       jj_consume_token(18);
/*  251 */       if (not == null) {
/*  252 */         return new Operator(22, id, set);
/*      */       }
/*  254 */       return new Operator(23, id, set);
/*      */     }
/*  256 */     if (jj_2_4(2147483647)) {
/*  257 */       id = identifier();
/*  258 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 10:
/*  260 */         not = jj_consume_token(10);
/*  261 */         break;
/*      */       default:
/*  263 */         this.jj_la1[6] = this.jj_gen;
/*      */       }
/*      */ 
/*  266 */       jj_consume_token(13);
/*  267 */       exp1 = patternExpression(id);
/*  268 */       if (not != null)
/*  269 */         exp1 = new Operator(1, exp1);
/*  270 */       return exp1;
/*  271 */     }if (jj_2_5(2147483647)) {
/*  272 */       exp1 = stringExpression();
/*  273 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 30:
/*  275 */         jj_consume_token(30);
/*  276 */         op = 0;
/*  277 */         break;
/*      */       case 29:
/*  279 */         jj_consume_token(29);
/*  280 */         op = 8;
/*  281 */         break;
/*      */       default:
/*  283 */         this.jj_la1[7] = this.jj_gen;
/*  284 */         jj_consume_token(-1);
/*  285 */         throw new ParseException();
/*      */       }
/*  287 */       exp2 = stringExpression();
/*  288 */       return new Operator(op, exp1, exp2);
/*  289 */     }if (jj_2_6(2147483647)) {
/*  290 */       exp1 = booleanExpression();
/*  291 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 30:
/*  293 */         jj_consume_token(30);
/*  294 */         op = 0;
/*  295 */         break;
/*      */       case 29:
/*  297 */         jj_consume_token(29);
/*  298 */         op = 8;
/*  299 */         break;
/*      */       default:
/*  301 */         this.jj_la1[8] = this.jj_gen;
/*  302 */         jj_consume_token(-1);
/*  303 */         throw new ParseException();
/*      */       }
/*  305 */       exp2 = booleanExpression();
/*  306 */       return new Operator(op, exp1, exp2);
/*  307 */     }if (jj_2_7(2147483647)) {
/*  308 */       exp1 = arithExpression();
/*  309 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 30:
/*  311 */         jj_consume_token(30);
/*  312 */         op = 0;
/*  313 */         break;
/*      */       case 29:
/*  315 */         jj_consume_token(29);
/*  316 */         op = 8;
/*  317 */         break;
/*      */       case 25:
/*  319 */         jj_consume_token(25);
/*  320 */         op = 4;
/*  321 */         break;
/*      */       case 26:
/*  323 */         jj_consume_token(26);
/*  324 */         op = 5;
/*  325 */         break;
/*      */       case 27:
/*  327 */         jj_consume_token(27);
/*  328 */         op = 6;
/*  329 */         break;
/*      */       case 28:
/*  331 */         jj_consume_token(28);
/*  332 */         op = 7;
/*  333 */         break;
/*      */       default:
/*  335 */         this.jj_la1[9] = this.jj_gen;
/*  336 */         jj_consume_token(-1);
/*  337 */         throw new ParseException();
/*      */       }
/*  339 */       exp2 = arithExpression();
/*  340 */       return new Operator(op, exp1, exp2);
/*  341 */     }if (jj_2_8(2147483647)) {
/*  342 */       exp1 = arithExpression();
/*  343 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 10:
/*  345 */         not = jj_consume_token(10);
/*  346 */         break;
/*      */       default:
/*  348 */         this.jj_la1[10] = this.jj_gen;
/*      */       }
/*      */ 
/*  351 */       jj_consume_token(12);
/*  352 */       exp2 = arithExpression();
/*  353 */       jj_consume_token(9);
/*  354 */       exp3 = arithExpression();
/*  355 */       exp1 = new Operator(14, exp1, exp2, exp3);
/*  356 */       if (not != null)
/*  357 */         exp1 = new Operator(1, exp1);
/*  358 */       return exp1;
/*      */     }
/*  360 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 6:
/*      */     case 7:
/*      */     case 38:
/*  364 */       exp1 = booleanExpression();
/*  365 */       return exp1;
/*      */     }
/*      */ 
/*  368 */     this.jj_la1[11] = this.jj_gen;
/*  369 */     jj_consume_token(-1);
/*  370 */     throw new ParseException();
/*      */   }
/*      */ 
/*      */   public final void stringList(HashSet set)
/*      */     throws ParseException
/*      */   {
/*  377 */     stringToken(set);
/*      */     while (true)
/*      */     {
/*  380 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */       {
/*      */       case 20:
/*  383 */         break;
/*      */       default:
/*  385 */         this.jj_la1[12] = this.jj_gen;
/*  386 */         break;
/*      */       }
/*  388 */       jj_consume_token(20);
/*  389 */       stringToken(set);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void stringToken(HashSet set) throws ParseException {
/*  394 */     Token t = null;
/*  395 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 37:
/*  397 */       t = jj_consume_token(37);
/*  398 */       break;
/*      */     default:
/*  400 */       this.jj_la1[13] = this.jj_gen;
/*      */     }
/*      */ 
/*  403 */     if (t != null)
/*  404 */       set.add(stripQuotes(t.image));
/*      */   }
/*      */ 
/*      */   public final Object patternExpression(Object exp1) throws ParseException {
/*  408 */     Object exp2 = null;
/*  409 */     Token esc = null;
/*  410 */     Object escChar = null;
/*  411 */     exp2 = stringLiteral();
/*  412 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 16:
/*  414 */       esc = jj_consume_token(16);
/*  415 */       escChar = stringLiteral();
/*  416 */       break;
/*      */     default:
/*  418 */       this.jj_la1[14] = this.jj_gen;
/*      */     }
/*      */ 
/*  421 */     Operator op = null;
/*  422 */     if (esc == null)
/*  423 */       op = new Operator(16, exp1, exp2);
/*      */     else
/*  425 */       op = new Operator(18, exp1, exp2, escChar);
/*  426 */     return op;
/*      */   }
/*      */ 
/*      */   public final Object arithExpression() throws ParseException
/*      */   {
/*  431 */     Object exp1 = null;
/*  432 */     Object exp2 = null;
/*  433 */     exp1 = arithTerm();
/*      */     while (true)
/*      */     {
/*  436 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */       {
/*      */       case 23:
/*      */       case 24:
/*  440 */         break;
/*      */       default:
/*  442 */         this.jj_la1[15] = this.jj_gen;
/*  443 */         break;
/*      */       }
/*  445 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 24:
/*  447 */         jj_consume_token(24);
/*  448 */         exp2 = arithTerm();
/*  449 */         exp1 = new Operator(9, exp1, exp2);
/*  450 */         break;
/*      */       case 23:
/*  452 */         jj_consume_token(23);
/*  453 */         exp2 = arithTerm();
/*  454 */         exp1 = new Operator(10, exp1, exp2);
/*  455 */         break;
/*      */       default:
/*  457 */         this.jj_la1[16] = this.jj_gen;
/*  458 */         jj_consume_token(-1);
/*  459 */         throw new ParseException();
/*      */       }
/*      */     }
/*  462 */     return exp1;
/*      */   }
/*      */ 
/*      */   public final Object arithTerm() throws ParseException
/*      */   {
/*  467 */     Object exp1 = null;
/*  468 */     Object exp2 = null;
/*  469 */     exp1 = arithFactor();
/*      */     while (true)
/*      */     {
/*  472 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */       {
/*      */       case 21:
/*      */       case 22:
/*  476 */         break;
/*      */       default:
/*  478 */         this.jj_la1[17] = this.jj_gen;
/*  479 */         break;
/*      */       }
/*  481 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 21:
/*  483 */         jj_consume_token(21);
/*  484 */         exp2 = arithFactor();
/*  485 */         exp1 = new Operator(12, exp1, exp2);
/*  486 */         break;
/*      */       case 22:
/*  488 */         jj_consume_token(22);
/*  489 */         exp2 = arithFactor();
/*  490 */         exp1 = new Operator(13, exp1, exp2);
/*  491 */         break;
/*      */       default:
/*  493 */         this.jj_la1[18] = this.jj_gen;
/*  494 */         jj_consume_token(-1);
/*  495 */         throw new ParseException();
/*      */       }
/*      */     }
/*  498 */     return exp1;
/*      */   }
/*      */ 
/*      */   public final Object arithFactor() throws ParseException
/*      */   {
/*  503 */     Object exp1 = null;
/*  504 */     boolean negate = false;
/*  505 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 23:
/*      */     case 24:
/*  508 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 24:
/*  510 */         jj_consume_token(24);
/*  511 */         break;
/*      */       case 23:
/*  513 */         jj_consume_token(23);
/*  514 */         negate = true;
/*  515 */         break;
/*      */       default:
/*  517 */         this.jj_la1[19] = this.jj_gen;
/*  518 */         jj_consume_token(-1);
/*  519 */         throw new ParseException();
/*      */       }
/*      */ 
/*      */     default:
/*  523 */       this.jj_la1[20] = this.jj_gen;
/*      */     }
/*      */ 
/*  526 */     exp1 = numericExpression();
/*  527 */     if (negate)
/*  528 */       exp1 = new Operator(11, exp1);
/*  529 */     return exp1;
/*      */   }
/*      */ 
/*      */   public final Object booleanExpression() throws ParseException
/*      */   {
/*  534 */     Object exp1 = null;
/*  535 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 38:
/*  537 */       exp1 = identifier();
/*  538 */       break;
/*      */     case 6:
/*      */     case 7:
/*  541 */       exp1 = booleanLiteral();
/*  542 */       break;
/*      */     default:
/*  544 */       this.jj_la1[21] = this.jj_gen;
/*  545 */       jj_consume_token(-1);
/*  546 */       throw new ParseException();
/*      */     }
/*  548 */     return exp1;
/*      */   }
/*      */ 
/*      */   public final Object booleanLiteral() throws ParseException
/*      */   {
/*  553 */     boolean isTrue = true;
/*  554 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 6:
/*  556 */       jj_consume_token(6);
/*  557 */       break;
/*      */     case 7:
/*  559 */       jj_consume_token(7);
/*  560 */       isTrue = false;
/*  561 */       break;
/*      */     default:
/*  563 */       this.jj_la1[22] = this.jj_gen;
/*  564 */       jj_consume_token(-1);
/*  565 */       throw new ParseException();
/*      */     }
/*  567 */     if (isTrue) {
/*  568 */       return Boolean.TRUE;
/*      */     }
/*  570 */     return Boolean.FALSE;
/*      */   }
/*      */ 
/*      */   public final Object stringExpression() throws ParseException
/*      */   {
/*  575 */     Object exp1 = null;
/*  576 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 38:
/*  578 */       exp1 = identifier();
/*  579 */       break;
/*      */     case 37:
/*  581 */       exp1 = stringLiteral();
/*  582 */       break;
/*      */     default:
/*  584 */       this.jj_la1[23] = this.jj_gen;
/*  585 */       jj_consume_token(-1);
/*  586 */       throw new ParseException();
/*      */     }
/*  588 */     return exp1;
/*      */   }
/*      */ 
/*      */   public final Object stringLiteral() throws ParseException
/*      */   {
/*  593 */     Token string = null;
/*  594 */     string = jj_consume_token(37);
/*  595 */     return stripQuotes(string.image);
/*      */   }
/*      */ 
/*      */   public final Object numericExpression() throws ParseException
/*      */   {
/*  600 */     Object exp1 = null;
/*  601 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 31:
/*      */     case 35:
/*  604 */       exp1 = numericLiteral();
/*  605 */       break;
/*      */     case 17:
/*  607 */       jj_consume_token(17);
/*  608 */       exp1 = arithExpression();
/*  609 */       jj_consume_token(18);
/*  610 */       break;
/*      */     case 38:
/*  612 */       exp1 = identifier();
/*  613 */       break;
/*      */     default:
/*  615 */       this.jj_la1[24] = this.jj_gen;
/*  616 */       jj_consume_token(-1);
/*  617 */       throw new ParseException();
/*      */     }
/*  619 */     return exp1;
/*      */   }
/*      */ 
/*      */   public final Object numericLiteral() throws ParseException
/*      */   {
/*  624 */     Token literal = null;
/*  625 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 35:
/*  627 */       literal = jj_consume_token(35);
/*  628 */       return new Double(literal.image);
/*      */     case 31:
/*  631 */       literal = jj_consume_token(31);
/*  632 */       String number = literal.image;
/*      */ 
/*  635 */       if ((number.endsWith("l")) || (number.endsWith("L")))
/*      */       {
/*  638 */         return new Long(number.substring(0, number.length() - 1));
/*      */       }
/*      */ 
/*  642 */       if ((number.startsWith("0X")) || (number.startsWith("0x")))
/*      */       {
/*  647 */         if (number.length() == 18)
/*      */         {
/*  649 */           byte first = Byte.decode(number.substring(0, 3)).byteValue();
/*  650 */           if (first >= 8)
/*      */           {
/*  652 */             number = "0x" + (first - 8) + number.substring(3);
/*  653 */             return new Long(Long.decode(number).longValue() - 9223372036854775807L - 1L);
/*      */           }
/*      */         }
/*      */       }
/*  657 */       else if (number.startsWith("0"))
/*      */       {
/*  664 */         if (number.length() == 23)
/*      */         {
/*  666 */           if (number.charAt(1) == '1')
/*      */           {
/*  668 */             number = "0" + number.substring(2);
/*  669 */             return new Long(Long.decode(number).longValue() - 9223372036854775807L - 1L);
/*      */           }
/*      */         }
/*      */       }
/*  673 */       return Long.decode(number);
/*      */     }
/*      */ 
/*  676 */     this.jj_la1[25] = this.jj_gen;
/*  677 */     jj_consume_token(-1);
/*  678 */     throw new ParseException();
/*      */   }
/*      */ 
/*      */   public final Object identifier()
/*      */     throws ParseException
/*      */   {
/*  684 */     Token id = null;
/*  685 */     id = jj_consume_token(38);
/*  686 */     Identifier identifier = (Identifier)this.identifierMap.get(id.image);
/*  687 */     if (identifier == null)
/*      */     {
/*  689 */       identifier = new Identifier(id.image);
/*  690 */       this.identifierMap.put(id.image, identifier);
/*      */     }
/*  692 */     return identifier;
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_1(int xla)
/*      */   {
/*  697 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { int i = !jj_3_1() ? 1 : 0;
/*      */       return i;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*  699 */       int j = 1;
/*      */       return j; } finally { jj_save(0, xla); } throw localObject;
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_2(int xla) {
/*  704 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { int i = !jj_3_2() ? 1 : 0;
/*      */       return i;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*  706 */       int j = 1;
/*      */       return j; } finally { jj_save(1, xla); } throw localObject;
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_3(int xla) {
/*  711 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { int i = !jj_3_3() ? 1 : 0;
/*      */       return i;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*  713 */       int j = 1;
/*      */       return j; } finally { jj_save(2, xla); } throw localObject;
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_4(int xla) {
/*  718 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { int i = !jj_3_4() ? 1 : 0;
/*      */       return i;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*  720 */       int j = 1;
/*      */       return j; } finally { jj_save(3, xla); } throw localObject;
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_5(int xla) {
/*  725 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { int i = !jj_3_5() ? 1 : 0;
/*      */       return i;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*  727 */       int j = 1;
/*      */       return j; } finally { jj_save(4, xla); } throw localObject;
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_6(int xla) {
/*  732 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { int i = !jj_3_6() ? 1 : 0;
/*      */       return i;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*  734 */       int j = 1;
/*      */       return j; } finally { jj_save(5, xla); } throw localObject;
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_7(int xla) {
/*  739 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { int i = !jj_3_7() ? 1 : 0;
/*      */       return i;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*  741 */       int j = 1;
/*      */       return j; } finally { jj_save(6, xla); } throw localObject;
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_8(int xla) {
/*  746 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { int i = !jj_3_8() ? 1 : 0;
/*      */       return i;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*  748 */       int j = 1;
/*      */       return j; } finally { jj_save(7, xla); } throw localObject;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_42() {
/*  753 */     return jj_3R_49();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_35()
/*      */   {
/*  759 */     Token xsp = this.jj_scanpos;
/*  760 */     if (jj_3R_42()) {
/*  761 */       this.jj_scanpos = xsp;
/*  762 */       if (jj_3R_43()) return true;
/*      */     }
/*  764 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_20() {
/*  768 */     return jj_scan_token(26);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_48()
/*      */   {
/*  773 */     if (jj_scan_token(22)) return true;
/*  774 */     return jj_3R_38();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_19()
/*      */   {
/*  779 */     return jj_scan_token(25);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_18()
/*      */   {
/*  784 */     return jj_scan_token(29);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_17()
/*      */   {
/*  789 */     return jj_scan_token(30);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_57()
/*      */   {
/*  794 */     return jj_scan_token(35);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_55()
/*      */   {
/*  800 */     Token xsp = this.jj_scanpos;
/*  801 */     if (jj_3R_57()) {
/*  802 */       this.jj_scanpos = xsp;
/*  803 */       if (jj_3R_58()) return true;
/*      */     }
/*  805 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_47() {
/*  809 */     if (jj_scan_token(21)) return true;
/*  810 */     return jj_3R_38();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_39()
/*      */   {
/*  816 */     Token xsp = this.jj_scanpos;
/*  817 */     if (jj_3R_47()) {
/*  818 */       this.jj_scanpos = xsp;
/*  819 */       if (jj_3R_48()) return true;
/*      */     }
/*  821 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_7() {
/*  825 */     if (jj_3R_16()) return true;
/*      */ 
/*  827 */     Token xsp = this.jj_scanpos;
/*  828 */     if (jj_3R_17()) {
/*  829 */       this.jj_scanpos = xsp;
/*  830 */       if (jj_3R_18()) {
/*  831 */         this.jj_scanpos = xsp;
/*  832 */         if (jj_3R_19()) {
/*  833 */           this.jj_scanpos = xsp;
/*  834 */           if (jj_3R_20()) {
/*  835 */             this.jj_scanpos = xsp;
/*  836 */             if (jj_3R_21()) {
/*  837 */               this.jj_scanpos = xsp;
/*  838 */               if (jj_3R_22()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  844 */     return jj_3R_16();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_36()
/*      */   {
/*  849 */     return jj_scan_token(9);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_33()
/*      */   {
/*  854 */     if (jj_3R_38()) return true; Token xsp;
/*      */     do
/*  857 */       xsp = this.jj_scanpos;
/*  858 */     while (!jj_3R_39()); this.jj_scanpos = xsp;
/*      */ 
/*  860 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_53() {
/*  864 */     return jj_3R_7();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_15()
/*      */   {
/*  869 */     return jj_scan_token(29);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_52()
/*      */   {
/*  874 */     if (jj_scan_token(17)) return true;
/*  875 */     if (jj_3R_16()) return true;
/*  876 */     return jj_scan_token(18);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_14()
/*      */   {
/*  881 */     return jj_scan_token(30);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_51()
/*      */   {
/*  886 */     return jj_3R_55();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_23()
/*      */   {
/*  891 */     if (jj_3R_35()) return true; Token xsp;
/*      */     do
/*  894 */       xsp = this.jj_scanpos;
/*  895 */     while (!jj_3R_36()); this.jj_scanpos = xsp;
/*      */ 
/*  897 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_46()
/*      */   {
/*  902 */     Token xsp = this.jj_scanpos;
/*  903 */     if (jj_3R_51()) {
/*  904 */       this.jj_scanpos = xsp;
/*  905 */       if (jj_3R_52()) {
/*  906 */         this.jj_scanpos = xsp;
/*  907 */         if (jj_3R_53()) return true;
/*      */       }
/*      */     }
/*  910 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_6() {
/*  914 */     if (jj_3R_13()) return true;
/*      */ 
/*  916 */     Token xsp = this.jj_scanpos;
/*  917 */     if (jj_3R_14()) {
/*  918 */       this.jj_scanpos = xsp;
/*  919 */       if (jj_3R_15()) return true;
/*      */     }
/*  921 */     return jj_3R_13();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_12()
/*      */   {
/*  926 */     return jj_scan_token(29);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_41()
/*      */   {
/*  931 */     if (jj_scan_token(23)) return true;
/*  932 */     return jj_3R_33();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_11()
/*      */   {
/*  937 */     return jj_scan_token(30);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_40()
/*      */   {
/*  942 */     if (jj_scan_token(24)) return true;
/*  943 */     return jj_3R_33();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_34()
/*      */   {
/*  949 */     Token xsp = this.jj_scanpos;
/*  950 */     if (jj_3R_40()) {
/*  951 */       this.jj_scanpos = xsp;
/*  952 */       if (jj_3R_41()) return true;
/*      */     }
/*  954 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_28() {
/*  958 */     if (jj_scan_token(16)) return true;
/*  959 */     return jj_3R_27();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_24()
/*      */   {
/*  964 */     return jj_scan_token(11);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_5()
/*      */   {
/*  969 */     if (jj_3R_10()) return true;
/*      */ 
/*  971 */     Token xsp = this.jj_scanpos;
/*  972 */     if (jj_3R_11()) {
/*  973 */       this.jj_scanpos = xsp;
/*  974 */       if (jj_3R_12()) return true;
/*      */     }
/*  976 */     return jj_3R_10();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_27()
/*      */   {
/*  981 */     return jj_scan_token(37);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_16()
/*      */   {
/*  986 */     if (jj_3R_33()) return true; Token xsp;
/*      */     do
/*  989 */       xsp = this.jj_scanpos;
/*  990 */     while (!jj_3R_34()); this.jj_scanpos = xsp;
/*      */ 
/*  992 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_6() {
/*  996 */     if (jj_3R_23()) return true; Token xsp;
/*      */     do
/*  999 */       xsp = this.jj_scanpos;
/* 1000 */     while (!jj_3R_24()); this.jj_scanpos = xsp;
/*      */ 
/* 1002 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_4() {
/* 1006 */     if (jj_3R_7()) return true;
/*      */ 
/* 1008 */     Token xsp = this.jj_scanpos;
/* 1009 */     if (jj_scan_token(10)) this.jj_scanpos = xsp;
/* 1010 */     if (jj_scan_token(13)) return true;
/* 1011 */     return jj_3R_9();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_30()
/*      */   {
/* 1016 */     return jj_3R_27();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_29()
/*      */   {
/* 1021 */     return jj_3R_7();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_7()
/*      */   {
/* 1026 */     return jj_scan_token(38);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_10()
/*      */   {
/* 1032 */     Token xsp = this.jj_scanpos;
/* 1033 */     if (jj_3R_29()) {
/* 1034 */       this.jj_scanpos = xsp;
/* 1035 */       if (jj_3R_30()) return true;
/*      */     }
/* 1037 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_3() {
/* 1041 */     if (jj_3R_7()) return true;
/*      */ 
/* 1043 */     Token xsp = this.jj_scanpos;
/* 1044 */     if (jj_scan_token(10)) this.jj_scanpos = xsp;
/* 1045 */     if (jj_scan_token(14)) return true;
/* 1046 */     if (jj_scan_token(17)) return true;
/* 1047 */     if (jj_3R_8()) return true;
/* 1048 */     return jj_scan_token(18);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_44()
/*      */   {
/* 1053 */     return jj_scan_token(7);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_9()
/*      */   {
/* 1058 */     if (jj_3R_27()) return true;
/*      */ 
/* 1060 */     Token xsp = this.jj_scanpos;
/* 1061 */     if (jj_3R_28()) this.jj_scanpos = xsp;
/* 1062 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_26() {
/* 1066 */     if (jj_scan_token(20)) return true;
/* 1067 */     return jj_3R_25();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_56()
/*      */   {
/* 1073 */     Token xsp = this.jj_scanpos;
/* 1074 */     if (jj_3_2()) {
/* 1075 */       this.jj_scanpos = xsp;
/* 1076 */       if (jj_3_3()) {
/* 1077 */         this.jj_scanpos = xsp;
/* 1078 */         if (jj_3_4()) {
/* 1079 */           this.jj_scanpos = xsp;
/* 1080 */           if (jj_3_5()) {
/* 1081 */             this.jj_scanpos = xsp;
/* 1082 */             if (jj_3_6()) {
/* 1083 */               this.jj_scanpos = xsp;
/* 1084 */               if (jj_3_7()) {
/* 1085 */                 this.jj_scanpos = xsp;
/* 1086 */                 if (jj_3_8()) {
/* 1087 */                   this.jj_scanpos = xsp;
/* 1088 */                   if (jj_3R_59()) return true;
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 1096 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_2() {
/* 1100 */     if (jj_3R_7()) return true;
/* 1101 */     if (jj_scan_token(15)) return true;
/*      */ 
/* 1103 */     Token xsp = this.jj_scanpos;
/* 1104 */     if (jj_scan_token(10)) this.jj_scanpos = xsp;
/* 1105 */     return jj_scan_token(8);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_37()
/*      */   {
/* 1111 */     Token xsp = this.jj_scanpos;
/* 1112 */     if (jj_scan_token(6)) {
/* 1113 */       this.jj_scanpos = xsp;
/* 1114 */       if (jj_3R_44()) return true;
/*      */     }
/* 1116 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_25()
/*      */   {
/* 1121 */     Token xsp = this.jj_scanpos;
/* 1122 */     if (jj_scan_token(37)) this.jj_scanpos = xsp;
/* 1123 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_32() {
/* 1127 */     return jj_3R_37();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_31()
/*      */   {
/* 1132 */     return jj_3R_7();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_54()
/*      */   {
/* 1137 */     return jj_3R_56();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_13()
/*      */   {
/* 1143 */     Token xsp = this.jj_scanpos;
/* 1144 */     if (jj_3R_31()) {
/* 1145 */       this.jj_scanpos = xsp;
/* 1146 */       if (jj_3R_32()) return true;
/*      */     }
/* 1148 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_8() {
/* 1152 */     if (jj_3R_25()) return true; Token xsp;
/*      */     do
/* 1155 */       xsp = this.jj_scanpos;
/* 1156 */     while (!jj_3R_26()); this.jj_scanpos = xsp;
/*      */ 
/* 1158 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_50() {
/* 1162 */     return jj_scan_token(23);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_49()
/*      */   {
/* 1168 */     Token xsp = this.jj_scanpos;
/* 1169 */     if (jj_3_1()) {
/* 1170 */       this.jj_scanpos = xsp;
/* 1171 */       if (jj_3R_54()) return true;
/*      */     }
/* 1173 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_1() {
/* 1177 */     if (jj_scan_token(17)) return true;
/* 1178 */     if (jj_3R_6()) return true;
/* 1179 */     return jj_scan_token(18);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_59()
/*      */   {
/* 1184 */     return jj_3R_13();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_45()
/*      */   {
/* 1190 */     Token xsp = this.jj_scanpos;
/* 1191 */     if (jj_scan_token(24)) {
/* 1192 */       this.jj_scanpos = xsp;
/* 1193 */       if (jj_3R_50()) return true;
/*      */     }
/* 1195 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_38()
/*      */   {
/* 1200 */     Token xsp = this.jj_scanpos;
/* 1201 */     if (jj_3R_45()) this.jj_scanpos = xsp;
/* 1202 */     return jj_3R_46();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_8()
/*      */   {
/* 1207 */     if (jj_3R_16()) return true;
/*      */ 
/* 1209 */     Token xsp = this.jj_scanpos;
/* 1210 */     if (jj_scan_token(10)) this.jj_scanpos = xsp;
/* 1211 */     if (jj_scan_token(12)) return true;
/* 1212 */     if (jj_3R_16()) return true;
/* 1213 */     if (jj_scan_token(9)) return true;
/* 1214 */     return jj_3R_16();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_43()
/*      */   {
/* 1219 */     if (jj_scan_token(10)) return true;
/* 1220 */     return jj_3R_49();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_22()
/*      */   {
/* 1225 */     return jj_scan_token(28);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_58()
/*      */   {
/* 1230 */     return jj_scan_token(31);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_21()
/*      */   {
/* 1235 */     return jj_scan_token(27);
/*      */   }
/*      */ 
/*      */   private static void jj_la1_0()
/*      */   {
/* 1256 */     jj_la1_0 = new int[] { 2048, 512, -2122185536, -2122186560, 1024, 1024, 1024, 1610612736, 1610612736, 2113929216, 1024, 192, 1048576, 0, 65536, 25165824, 25165824, 6291456, 6291456, 25165824, 25165824, 192, 192, 0, -2147352576, -2147483648 };
/*      */   }
/*      */   private static void jj_la1_1() {
/* 1259 */     jj_la1_1 = new int[] { 0, 0, 104, 104, 0, 0, 0, 0, 0, 0, 0, 64, 0, 32, 0, 0, 0, 0, 0, 0, 0, 64, 0, 96, 72, 8 };
/*      */   }
/*      */ 
/*      */   public SelectorParser(InputStream stream)
/*      */   {
/* 1266 */     this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
/* 1267 */     this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
/* 1268 */     this.token = new Token();
/* 1269 */     this.jj_ntk = -1;
/* 1270 */     this.jj_gen = 0;
/* 1271 */     for (int i = 0; i < 26; i++) this.jj_la1[i] = -1;
/* 1272 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public void ReInit(InputStream stream)
/*      */   {
/* 1276 */     this.jj_input_stream.ReInit(stream, 1, 1);
/* 1277 */     this.token_source.ReInit(this.jj_input_stream);
/* 1278 */     this.token = new Token();
/* 1279 */     this.jj_ntk = -1;
/* 1280 */     this.jj_gen = 0;
/* 1281 */     for (int i = 0; i < 26; i++) this.jj_la1[i] = -1;
/* 1282 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public SelectorParser(Reader stream)
/*      */   {
/* 1286 */     this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
/* 1287 */     this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
/* 1288 */     this.token = new Token();
/* 1289 */     this.jj_ntk = -1;
/* 1290 */     this.jj_gen = 0;
/* 1291 */     for (int i = 0; i < 26; i++) this.jj_la1[i] = -1;
/* 1292 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public void ReInit(Reader stream)
/*      */   {
/* 1296 */     this.jj_input_stream.ReInit(stream, 1, 1);
/* 1297 */     this.token_source.ReInit(this.jj_input_stream);
/* 1298 */     this.token = new Token();
/* 1299 */     this.jj_ntk = -1;
/* 1300 */     this.jj_gen = 0;
/* 1301 */     for (int i = 0; i < 26; i++) this.jj_la1[i] = -1;
/* 1302 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public SelectorParser(SelectorParserTokenManager tm)
/*      */   {
/* 1306 */     this.token_source = tm;
/* 1307 */     this.token = new Token();
/* 1308 */     this.jj_ntk = -1;
/* 1309 */     this.jj_gen = 0;
/* 1310 */     for (int i = 0; i < 26; i++) this.jj_la1[i] = -1;
/* 1311 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public void ReInit(SelectorParserTokenManager tm)
/*      */   {
/* 1315 */     this.token_source = tm;
/* 1316 */     this.token = new Token();
/* 1317 */     this.jj_ntk = -1;
/* 1318 */     this.jj_gen = 0;
/* 1319 */     for (int i = 0; i < 26; i++) this.jj_la1[i] = -1;
/* 1320 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls();
/*      */   }
/*      */ 
/*      */   private final Token jj_consume_token(int kind)
/*      */     throws ParseException
/*      */   {
/* 1325 */     Token oldToken;
/* 1325 */     if ((oldToken = this.token).next != null) this.token = this.token.next; else
/* 1326 */       this.token = (this.token.next = this.token_source.getNextToken());
/* 1327 */     this.jj_ntk = -1;
/* 1328 */     if (this.token.kind == kind) {
/* 1329 */       this.jj_gen += 1;
/* 1330 */       if (++this.jj_gc > 100) {
/* 1331 */         this.jj_gc = 0;
/* 1332 */         for (int i = 0; i < this.jj_2_rtns.length; i++) {
/* 1333 */           JJCalls c = this.jj_2_rtns[i];
/* 1334 */           while (c != null) {
/* 1335 */             if (c.gen < this.jj_gen) c.first = null;
/* 1336 */             c = c.next;
/*      */           }
/*      */         }
/*      */       }
/* 1340 */       return this.token;
/*      */     }
/* 1342 */     this.token = oldToken;
/* 1343 */     this.jj_kind = kind;
/* 1344 */     throw generateParseException();
/*      */   }
/*      */ 
/*      */   private final boolean jj_scan_token(int kind)
/*      */   {
/* 1350 */     if (this.jj_scanpos == this.jj_lastpos) {
/* 1351 */       this.jj_la -= 1;
/* 1352 */       if (this.jj_scanpos.next == null)
/* 1353 */         this.jj_lastpos = (this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken());
/*      */       else
/* 1355 */         this.jj_lastpos = (this.jj_scanpos = this.jj_scanpos.next);
/*      */     }
/*      */     else {
/* 1358 */       this.jj_scanpos = this.jj_scanpos.next;
/*      */     }
/* 1360 */     if (this.jj_rescan) {
/* 1361 */       int i = 0; Token tok = this.token;
/* 1362 */       for (; (tok != null) && (tok != this.jj_scanpos); tok = tok.next) i++;
/* 1363 */       if (tok != null) jj_add_error_token(kind, i);
/*      */     }
/* 1365 */     if (this.jj_scanpos.kind != kind) return true;
/* 1366 */     if ((this.jj_la == 0) && (this.jj_scanpos == this.jj_lastpos)) throw this.jj_ls;
/* 1367 */     return false;
/*      */   }
/*      */ 
/*      */   public final Token getNextToken() {
/* 1371 */     if (this.token.next != null) this.token = this.token.next; else
/* 1372 */       this.token = (this.token.next = this.token_source.getNextToken());
/* 1373 */     this.jj_ntk = -1;
/* 1374 */     this.jj_gen += 1;
/* 1375 */     return this.token;
/*      */   }
/*      */ 
/*      */   public final Token getToken(int index) {
/* 1379 */     Token t = this.lookingAhead ? this.jj_scanpos : this.token;
/* 1380 */     for (int i = 0; i < index; i++) {
/* 1381 */       if (t.next != null) t = t.next; else
/* 1382 */         t = t.next = this.token_source.getNextToken();
/*      */     }
/* 1384 */     return t;
/*      */   }
/*      */ 
/*      */   private final int jj_ntk() {
/* 1388 */     if ((this.jj_nt = this.token.next) == null) {
/* 1389 */       return this.jj_ntk = (this.token.next = this.token_source.getNextToken()).kind;
/*      */     }
/* 1391 */     return this.jj_ntk = this.jj_nt.kind;
/*      */   }
/*      */ 
/*      */   private void jj_add_error_token(int kind, int pos)
/*      */   {
/* 1401 */     if (pos >= 100) return;
/* 1402 */     if (pos == this.jj_endpos + 1) {
/* 1403 */       this.jj_lasttokens[(this.jj_endpos++)] = kind;
/* 1404 */     } else if (this.jj_endpos != 0) {
/* 1405 */       this.jj_expentry = new int[this.jj_endpos];
/* 1406 */       for (int i = 0; i < this.jj_endpos; i++) {
/* 1407 */         this.jj_expentry[i] = this.jj_lasttokens[i];
/*      */       }
/* 1409 */       boolean exists = false;
/* 1410 */       for (Enumeration e = this.jj_expentries.elements(); e.hasMoreElements(); ) {
/* 1411 */         int[] oldentry = (int[])(int[])e.nextElement();
/* 1412 */         if (oldentry.length == this.jj_expentry.length) {
/* 1413 */           exists = true;
/* 1414 */           for (int i = 0; i < this.jj_expentry.length; i++) {
/* 1415 */             if (oldentry[i] != this.jj_expentry[i]) {
/* 1416 */               exists = false;
/* 1417 */               break;
/*      */             }
/*      */           }
/* 1420 */           if (exists) break;
/*      */         }
/*      */       }
/* 1423 */       if (!exists) this.jj_expentries.addElement(this.jj_expentry);
/* 1424 */       if (pos != 0)
/*      */       {
/*      */         int tmp205_204 = pos; this.jj_endpos = tmp205_204; this.jj_lasttokens[(tmp205_204 - 1)] = kind;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public ParseException generateParseException() {
/* 1429 */     this.jj_expentries.removeAllElements();
/* 1430 */     boolean[] la1tokens = new boolean[41];
/* 1431 */     for (int i = 0; i < 41; i++) {
/* 1432 */       la1tokens[i] = false;
/*      */     }
/* 1434 */     if (this.jj_kind >= 0) {
/* 1435 */       la1tokens[this.jj_kind] = true;
/* 1436 */       this.jj_kind = -1;
/*      */     }
/* 1438 */     for (int i = 0; i < 26; i++) {
/* 1439 */       if (this.jj_la1[i] == this.jj_gen) {
/* 1440 */         for (int j = 0; j < 32; j++) {
/* 1441 */           if ((jj_la1_0[i] & 1 << j) != 0) {
/* 1442 */             la1tokens[j] = true;
/*      */           }
/* 1444 */           if ((jj_la1_1[i] & 1 << j) != 0) {
/* 1445 */             la1tokens[(32 + j)] = true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 1450 */     for (int i = 0; i < 41; i++) {
/* 1451 */       if (la1tokens[i] != 0) {
/* 1452 */         this.jj_expentry = new int[1];
/* 1453 */         this.jj_expentry[0] = i;
/* 1454 */         this.jj_expentries.addElement(this.jj_expentry);
/*      */       }
/*      */     }
/* 1457 */     this.jj_endpos = 0;
/* 1458 */     jj_rescan_token();
/* 1459 */     jj_add_error_token(0, 0);
/* 1460 */     int[][] exptokseq = new int[this.jj_expentries.size()][];
/* 1461 */     for (int i = 0; i < this.jj_expentries.size(); i++) {
/* 1462 */       exptokseq[i] = ((int[])(int[])this.jj_expentries.elementAt(i));
/*      */     }
/* 1464 */     return new ParseException(this.token, exptokseq, tokenImage);
/*      */   }
/*      */ 
/*      */   public final void enable_tracing() {
/*      */   }
/*      */ 
/*      */   public final void disable_tracing() {
/*      */   }
/*      */ 
/*      */   private final void jj_rescan_token() {
/* 1474 */     this.jj_rescan = true;
/* 1475 */     for (int i = 0; i < 8; i++) {
/* 1476 */       JJCalls p = this.jj_2_rtns[i];
/*      */       do {
/* 1478 */         if (p.gen > this.jj_gen) {
/* 1479 */           this.jj_la = p.arg; this.jj_lastpos = (this.jj_scanpos = p.first);
/* 1480 */           switch (i) { case 0:
/* 1481 */             jj_3_1(); break;
/*      */           case 1:
/* 1482 */             jj_3_2(); break;
/*      */           case 2:
/* 1483 */             jj_3_3(); break;
/*      */           case 3:
/* 1484 */             jj_3_4(); break;
/*      */           case 4:
/* 1485 */             jj_3_5(); break;
/*      */           case 5:
/* 1486 */             jj_3_6(); break;
/*      */           case 6:
/* 1487 */             jj_3_7(); break;
/*      */           case 7:
/* 1488 */             jj_3_8();
/*      */           }
/*      */         }
/* 1491 */         p = p.next;
/* 1492 */       }while (p != null);
/*      */     }
/* 1494 */     this.jj_rescan = false;
/*      */   }
/*      */ 
/*      */   private final void jj_save(int index, int xla) {
/* 1498 */     JJCalls p = this.jj_2_rtns[index];
/* 1499 */     while (p.gen > this.jj_gen) {
/* 1500 */       if (p.next == null) { p = p.next = new JJCalls(); break; }
/* 1501 */       p = p.next;
/*      */     }
/* 1503 */     p.gen = (this.jj_gen + xla - this.jj_la); p.first = this.token; p.arg = xla;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/* 1252 */     jj_la1_0();
/* 1253 */     jj_la1_1();
/*      */   }
/*      */ 
/*      */   static final class JJCalls
/*      */   {
/*      */     int gen;
/*      */     Token first;
/*      */     int arg;
/*      */     JJCalls next;
/*      */   }
/*      */ 
/*      */   private static final class LookaheadSuccess extends Error
/*      */   {
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.selector.SelectorParser
 * JD-Core Version:    0.6.0
 */