/*      */ package org.jboss.jms.server.selector;
/*      */ 
/*      */ import java.util.HashSet;
/*      */ import org.jboss.util.Primitives;
/*      */ 
/*      */ public class Operator
/*      */ {
/*      */   int operation;
/*      */   Object oper1;
/*      */   Object oper2;
/*      */   Object oper3;
/*      */   Object arg1;
/*      */   Object arg2;
/*      */   Object arg3;
/*      */   int class1;
/*      */   int class2;
/*      */   int class3;
/*   55 */   RegExp re = null;
/*      */   public static final int EQUAL = 0;
/*      */   public static final int NOT = 1;
/*      */   public static final int AND = 2;
/*      */   public static final int OR = 3;
/*      */   public static final int GT = 4;
/*      */   public static final int GE = 5;
/*      */   public static final int LT = 6;
/*      */   public static final int LE = 7;
/*      */   public static final int DIFFERENT = 8;
/*      */   public static final int ADD = 9;
/*      */   public static final int SUB = 10;
/*      */   public static final int NEG = 11;
/*      */   public static final int MUL = 12;
/*      */   public static final int DIV = 13;
/*      */   public static final int BETWEEN = 14;
/*      */   public static final int NOT_BETWEEN = 15;
/*      */   public static final int LIKE = 16;
/*      */   public static final int NOT_LIKE = 17;
/*      */   public static final int LIKE_ESCAPE = 18;
/*      */   public static final int NOT_LIKE_ESCAPE = 19;
/*      */   public static final int IS_NULL = 20;
/*      */   public static final int IS_NOT_NULL = 21;
/*      */   public static final int IN = 22;
/*      */   public static final int NOT_IN = 23;
/*      */   public static final int STRING = 0;
/*      */   public static final int DOUBLE = 1;
/*      */   public static final int LONG = 2;
/*      */   public static final int BOOLEAN = 3;
/*      */ 
/*      */   public Operator(int operation, Object oper1, Object oper2, Object oper3)
/*      */   {
/*   91 */     this.operation = operation;
/*   92 */     this.oper1 = oper1;
/*   93 */     this.oper2 = oper2;
/*   94 */     this.oper3 = oper3;
/*      */   }
/*      */ 
/*      */   public Operator(int operation, Object oper1, Object oper2)
/*      */   {
/*   99 */     this.operation = operation;
/*  100 */     this.oper1 = oper1;
/*  101 */     this.oper2 = oper2;
/*  102 */     this.oper3 = null;
/*      */   }
/*      */ 
/*      */   public Operator(int operation, Object oper1)
/*      */   {
/*  107 */     this.operation = operation;
/*  108 */     this.oper1 = oper1;
/*  109 */     this.oper2 = null;
/*  110 */     this.oper3 = null;
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  117 */     return print("");
/*      */   }
/*      */ 
/*      */   public String print(String level)
/*      */   {
/*  122 */     String st = level + this.operation + ":" + operationString(this.operation) + "(\n";
/*      */ 
/*  124 */     String nextLevel = level + "  ";
/*      */ 
/*  126 */     if (this.oper1 == null)
/*  127 */       st = st + nextLevel + "null\n";
/*  128 */     else if ((this.oper1 instanceof Operator))
/*  129 */       st = st + ((Operator)this.oper1).print(nextLevel);
/*      */     else {
/*  131 */       st = st + nextLevel + this.oper1.toString() + "\n";
/*      */     }
/*  133 */     if (this.oper2 != null)
/*      */     {
/*  135 */       if ((this.oper2 instanceof Operator))
/*  136 */         st = st + ((Operator)this.oper2).print(nextLevel);
/*      */       else {
/*  138 */         st = st + nextLevel + this.oper2.toString() + "\n";
/*      */       }
/*      */     }
/*  141 */     if (this.oper3 != null)
/*      */     {
/*  143 */       if ((this.oper3 instanceof Operator))
/*  144 */         st = st + ((Operator)this.oper3).print(nextLevel);
/*      */       else {
/*  146 */         st = st + nextLevel + this.oper3.toString() + "\n";
/*      */       }
/*      */     }
/*  149 */     st = st + level + ")\n";
/*      */ 
/*  151 */     return st;
/*      */   }
/*      */ 
/*      */   Object is_null()
/*      */     throws Exception
/*      */   {
/*  158 */     computeArgument1();
/*  159 */     if (this.arg1 == null) {
/*  160 */       return Boolean.TRUE;
/*      */     }
/*  162 */     return Boolean.FALSE;
/*      */   }
/*      */ 
/*      */   Object is_not_null()
/*      */     throws Exception
/*      */   {
/*  168 */     computeArgument1();
/*  169 */     if (this.arg1 != null) {
/*  170 */       return Boolean.TRUE;
/*      */     }
/*  172 */     return Boolean.FALSE;
/*      */   }
/*      */ 
/*      */   Object equal()
/*      */     throws Exception
/*      */   {
/*  178 */     computeArgument1();
/*  179 */     if (this.arg1 == null) {
/*  180 */       return Boolean.FALSE;
/*      */     }
/*  182 */     switch (this.class1)
/*      */     {
/*      */     case 2:
/*  185 */       computeArgument1();
/*  186 */       if (this.arg1 == null)
/*  187 */         return null;
/*  188 */       computeArgument2();
/*  189 */       if (this.arg2 == null)
/*  190 */         return null;
/*  191 */       if (this.class2 == 2)
/*  192 */         return Primitives.valueOf(((Number)this.arg1).longValue() == ((Number)this.arg2).longValue());
/*  193 */       if (this.class2 == 1)
/*  194 */         return Primitives.valueOf(((Number)this.arg1).longValue() == ((Number)this.arg2).doubleValue());
/*  195 */       return Boolean.FALSE;
/*      */     case 1:
/*  197 */       computeArgument1();
/*  198 */       if (this.arg1 == null)
/*  199 */         return null;
/*  200 */       computeArgument2();
/*  201 */       if (this.arg2 == null)
/*  202 */         return null;
/*  203 */       if (this.class2 == 2)
/*  204 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() == ((Number)this.arg2).longValue());
/*  205 */       if (this.class2 == 1)
/*  206 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() == ((Number)this.arg2).doubleValue());
/*  207 */       return Boolean.FALSE;
/*      */     case 0:
/*      */     case 3:
/*  210 */       computeArgument2();
/*  211 */       if (this.arg2 == null)
/*  212 */         return Boolean.FALSE;
/*  213 */       if (this.class2 != this.class1)
/*  214 */         throwBadObjectException(this.class1, this.class2);
/*  215 */       return Primitives.valueOf(this.arg1.equals(this.arg2));
/*      */     }
/*  217 */     throwBadObjectException(this.class1);
/*  218 */     return null;
/*      */   }
/*      */ 
/*      */   Object not()
/*      */     throws Exception
/*      */   {
/*  226 */     computeArgument1();
/*  227 */     if (this.arg1 == null)
/*  228 */       return null;
/*  229 */     if (this.class1 != 3)
/*  230 */       throwBadObjectException(this.class1);
/*  231 */     if (((Boolean)this.arg1).booleanValue()) {
/*  232 */       return Boolean.FALSE;
/*      */     }
/*  234 */     return Boolean.TRUE;
/*      */   }
/*      */ 
/*      */   Object and()
/*      */     throws Exception
/*      */   {
/*  240 */     computeArgument1();
/*  241 */     if (this.arg1 == null)
/*      */     {
/*  243 */       computeArgument2();
/*  244 */       if (this.arg2 == null)
/*  245 */         return null;
/*  246 */       if (this.class2 != 3)
/*  247 */         throwBadObjectException(this.class2);
/*  248 */       if (!((Boolean)this.arg2).booleanValue())
/*  249 */         return Boolean.FALSE;
/*  250 */       return null;
/*      */     }
/*      */ 
/*  253 */     if (this.class1 == 3)
/*      */     {
/*  255 */       if (!((Boolean)this.arg1).booleanValue())
/*  256 */         return Boolean.FALSE;
/*  257 */       computeArgument2();
/*  258 */       if (this.arg2 == null)
/*  259 */         return null;
/*  260 */       if (this.class2 != 3)
/*  261 */         throwBadObjectException(this.class2);
/*  262 */       return this.arg2;
/*      */     }
/*      */ 
/*  265 */     throwBadObjectException(this.class1);
/*  266 */     return null;
/*      */   }
/*      */ 
/*      */   Object or()
/*      */     throws Exception
/*      */   {
/*  281 */     short falseCounter = 0;
/*      */ 
/*  283 */     computeArgument1();
/*  284 */     if (this.arg1 != null)
/*      */     {
/*  286 */       if (this.class1 != 3)
/*  287 */         throwBadObjectException(this.class1);
/*  288 */       if (((Boolean)this.arg1).booleanValue()) {
/*  289 */         return Boolean.TRUE;
/*      */       }
/*  291 */       falseCounter = (short)(falseCounter + 1);
/*      */     }
/*      */ 
/*  294 */     computeArgument2();
/*  295 */     if (this.arg2 != null)
/*      */     {
/*  297 */       if (this.class2 != 3)
/*  298 */         throwBadObjectException(this.class2);
/*  299 */       if (((Boolean)this.arg2).booleanValue()) {
/*  300 */         return Boolean.TRUE;
/*      */       }
/*  302 */       falseCounter = (short)(falseCounter + 1);
/*      */     }
/*      */ 
/*  305 */     if (falseCounter == 2) {
/*  306 */       return Boolean.FALSE;
/*      */     }
/*  308 */     return null;
/*      */   }
/*      */ 
/*      */   Object gt()
/*      */     throws Exception
/*      */   {
/*  314 */     computeArgument1();
/*  315 */     if (this.arg1 == null) {
/*  316 */       return null;
/*      */     }
/*  318 */     if (this.class1 == 2)
/*      */     {
/*  320 */       computeArgument2();
/*  321 */       if (this.arg2 == null)
/*  322 */         return null;
/*  323 */       if (this.class2 == 2)
/*  324 */         return Primitives.valueOf(((Number)this.arg1).longValue() > ((Number)this.arg2).longValue());
/*  325 */       if (this.class2 == 1)
/*  326 */         return Primitives.valueOf(((Number)this.arg1).longValue() > ((Number)this.arg2).doubleValue());
/*      */     }
/*  328 */     else if (this.class1 == 1)
/*      */     {
/*  330 */       computeArgument2();
/*  331 */       if (this.arg2 == null)
/*  332 */         return null;
/*  333 */       if (this.class2 == 2)
/*  334 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() > ((Number)this.arg2).longValue());
/*  335 */       if (this.class2 == 1)
/*  336 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() > ((Number)this.arg2).doubleValue());
/*  337 */       return Boolean.FALSE;
/*      */     }
/*  339 */     return Boolean.FALSE;
/*      */   }
/*      */ 
/*      */   Object ge()
/*      */     throws Exception
/*      */   {
/*  345 */     computeArgument1();
/*  346 */     if (this.arg1 == null) {
/*  347 */       return null;
/*      */     }
/*  349 */     if (this.class1 == 2)
/*      */     {
/*  351 */       computeArgument2();
/*  352 */       if (this.arg2 == null)
/*  353 */         return null;
/*  354 */       if (this.class2 == 2)
/*  355 */         return Primitives.valueOf(((Number)this.arg1).longValue() >= ((Number)this.arg2).longValue());
/*  356 */       if (this.class2 == 1)
/*  357 */         return Primitives.valueOf(((Number)this.arg1).longValue() >= ((Number)this.arg2).doubleValue());
/*      */     }
/*  359 */     else if (this.class1 == 1)
/*      */     {
/*  361 */       computeArgument2();
/*  362 */       if (this.arg2 == null)
/*  363 */         return null;
/*  364 */       if (this.class2 == 2)
/*  365 */         return Primitives.valueOf(((Number)this.arg1).longValue() >= ((Number)this.arg2).longValue());
/*  366 */       if (this.class2 == 1)
/*  367 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() >= ((Number)this.arg2).doubleValue());
/*  368 */       return Boolean.FALSE;
/*      */     }
/*  370 */     return Boolean.FALSE;
/*      */   }
/*      */ 
/*      */   Object lt()
/*      */     throws Exception
/*      */   {
/*  376 */     computeArgument1();
/*  377 */     if (this.arg1 == null) {
/*  378 */       return null;
/*      */     }
/*  380 */     if (this.class1 == 2)
/*      */     {
/*  382 */       computeArgument2();
/*  383 */       if (this.arg2 == null)
/*  384 */         return null;
/*  385 */       if (this.class2 == 2)
/*  386 */         return Primitives.valueOf(((Number)this.arg1).longValue() < ((Number)this.arg2).longValue());
/*  387 */       if (this.class2 == 1)
/*  388 */         return Primitives.valueOf(((Number)this.arg1).longValue() < ((Number)this.arg2).doubleValue());
/*      */     }
/*  390 */     else if (this.class1 == 1)
/*      */     {
/*  392 */       computeArgument2();
/*  393 */       if (this.arg2 == null)
/*  394 */         return null;
/*  395 */       if (this.class2 == 2)
/*  396 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() < ((Number)this.arg2).longValue());
/*  397 */       if (this.class2 == 1) {
/*  398 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() < ((Number)this.arg2).doubleValue());
/*      */       }
/*      */     }
/*  401 */     return Boolean.FALSE;
/*      */   }
/*      */ 
/*      */   Object le()
/*      */     throws Exception
/*      */   {
/*  407 */     computeArgument1();
/*  408 */     if (this.arg1 == null) {
/*  409 */       return null;
/*      */     }
/*  411 */     if (this.class1 == 2)
/*      */     {
/*  413 */       computeArgument2();
/*  414 */       if (this.arg2 == null)
/*  415 */         return null;
/*  416 */       if (this.class2 == 2)
/*  417 */         return Primitives.valueOf(((Number)this.arg1).longValue() <= ((Number)this.arg2).longValue());
/*  418 */       if (this.class2 == 1)
/*  419 */         return Primitives.valueOf(((Number)this.arg1).longValue() <= ((Number)this.arg2).doubleValue());
/*      */     }
/*  421 */     else if (this.class1 == 1)
/*      */     {
/*  423 */       computeArgument2();
/*  424 */       if (this.arg2 == null)
/*  425 */         return null;
/*  426 */       if (this.class2 == 2)
/*  427 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() <= ((Number)this.arg2).longValue());
/*  428 */       if (this.class2 == 1)
/*  429 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() <= ((Number)this.arg2).doubleValue());
/*      */     }
/*  431 */     return Boolean.FALSE;
/*      */   }
/*      */ 
/*      */   Object different()
/*      */     throws Exception
/*      */   {
/*  437 */     computeArgument1();
/*  438 */     if (this.arg1 == null) {
/*  439 */       return Boolean.FALSE;
/*      */     }
/*  441 */     switch (this.class1)
/*      */     {
/*      */     case 2:
/*  444 */       computeArgument1();
/*  445 */       if (this.arg1 == null)
/*  446 */         return null;
/*  447 */       computeArgument2();
/*  448 */       if (this.arg2 == null)
/*  449 */         return null;
/*  450 */       if (this.class2 == 2)
/*  451 */         return Primitives.valueOf(((Number)this.arg1).longValue() != ((Number)this.arg2).longValue());
/*  452 */       if (this.class2 == 1)
/*  453 */         return Primitives.valueOf(((Number)this.arg1).longValue() != ((Number)this.arg2).doubleValue());
/*  454 */       return Boolean.FALSE;
/*      */     case 1:
/*  456 */       computeArgument1();
/*  457 */       if (this.arg1 == null)
/*  458 */         return null;
/*  459 */       computeArgument2();
/*  460 */       if (this.arg2 == null)
/*  461 */         return null;
/*  462 */       if (this.class2 == 2)
/*  463 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() != ((Number)this.arg2).longValue());
/*  464 */       if (this.class2 == 1)
/*  465 */         return Primitives.valueOf(((Number)this.arg1).doubleValue() != ((Number)this.arg2).doubleValue());
/*  466 */       return Boolean.FALSE;
/*      */     case 0:
/*      */     case 3:
/*  469 */       computeArgument2();
/*  470 */       if (this.arg2 == null)
/*  471 */         return Boolean.FALSE;
/*  472 */       if (this.class2 != this.class1)
/*  473 */         throwBadObjectException(this.class1, this.class2);
/*  474 */       return Primitives.valueOf(!this.arg1.equals(this.arg2));
/*      */     }
/*  476 */     throwBadObjectException(this.class1);
/*      */ 
/*  478 */     return null;
/*      */   }
/*      */ 
/*      */   Object add()
/*      */     throws Exception
/*      */   {
/*  484 */     computeArgument1();
/*  485 */     computeArgument2();
/*      */ 
/*  487 */     if ((this.arg1 == null) || (this.arg2 == null))
/*  488 */       return null;
/*  489 */     switch (this.class1)
/*      */     {
/*      */     case 1:
/*  492 */       switch (this.class2)
/*      */       {
/*      */       case 1:
/*  495 */         return new Double(((Number)this.arg1).doubleValue() + ((Number)this.arg2).doubleValue());
/*      */       case 2:
/*  497 */         return new Double(((Number)this.arg1).doubleValue() + ((Number)this.arg2).doubleValue());
/*      */       }
/*  499 */       throwBadObjectException(this.class2);
/*      */     case 2:
/*  502 */       switch (this.class2)
/*      */       {
/*      */       case 1:
/*  505 */         return new Double(((Number)this.arg1).doubleValue() + ((Number)this.arg2).doubleValue());
/*      */       case 2:
/*  507 */         return new Long(((Number)this.arg1).longValue() + ((Number)this.arg2).longValue());
/*      */       }
/*  509 */       throwBadObjectException(this.class2);
/*      */     }
/*      */ 
/*  512 */     throwBadObjectException(this.class1);
/*      */ 
/*  514 */     return null;
/*      */   }
/*      */ 
/*      */   Object sub()
/*      */     throws Exception
/*      */   {
/*  520 */     computeArgument1();
/*  521 */     computeArgument2();
/*      */ 
/*  523 */     if ((this.arg1 == null) || (this.arg2 == null))
/*  524 */       return null;
/*  525 */     switch (this.class1)
/*      */     {
/*      */     case 1:
/*  528 */       switch (this.class2)
/*      */       {
/*      */       case 1:
/*  531 */         return new Double(((Number)this.arg1).doubleValue() - ((Number)this.arg2).doubleValue());
/*      */       case 2:
/*  533 */         return new Double(((Number)this.arg1).doubleValue() - ((Number)this.arg2).doubleValue());
/*      */       }
/*  535 */       throwBadObjectException(this.class2);
/*      */     case 2:
/*  538 */       switch (this.class2)
/*      */       {
/*      */       case 1:
/*  541 */         return new Double(((Number)this.arg1).doubleValue() - ((Number)this.arg2).doubleValue());
/*      */       case 2:
/*  543 */         return new Long(((Number)this.arg1).longValue() - ((Number)this.arg2).longValue());
/*      */       }
/*  545 */       throwBadObjectException(this.class2);
/*      */     }
/*      */ 
/*  548 */     throwBadObjectException(this.class1);
/*      */ 
/*  550 */     return null;
/*      */   }
/*      */ 
/*      */   Object neg()
/*      */     throws Exception
/*      */   {
/*  556 */     computeArgument1();
/*  557 */     if (this.arg1 == null)
/*  558 */       return null;
/*  559 */     switch (this.class1)
/*      */     {
/*      */     case 1:
/*  562 */       return new Double(-((Number)this.arg1).doubleValue());
/*      */     case 2:
/*  564 */       return new Long(-((Number)this.arg1).longValue());
/*      */     }
/*  566 */     throwBadObjectException(this.class1);
/*      */ 
/*  568 */     return null;
/*      */   }
/*      */ 
/*      */   Object mul()
/*      */     throws Exception
/*      */   {
/*  574 */     computeArgument1();
/*  575 */     computeArgument2();
/*  576 */     if ((this.arg1 == null) || (this.arg2 == null))
/*  577 */       return null;
/*  578 */     switch (this.class1)
/*      */     {
/*      */     case 1:
/*  581 */       switch (this.class2)
/*      */       {
/*      */       case 1:
/*  584 */         return new Double(((Number)this.arg1).doubleValue() * ((Number)this.arg2).doubleValue());
/*      */       case 2:
/*  586 */         return new Double(((Number)this.arg1).doubleValue() * ((Number)this.arg2).doubleValue());
/*      */       }
/*  588 */       throwBadObjectException(this.class2);
/*      */     case 2:
/*  591 */       switch (this.class2)
/*      */       {
/*      */       case 1:
/*  594 */         return new Double(((Number)this.arg1).doubleValue() * ((Number)this.arg2).doubleValue());
/*      */       case 2:
/*  596 */         return new Long(((Number)this.arg1).longValue() * ((Number)this.arg2).longValue());
/*      */       }
/*  598 */       throwBadObjectException(this.class2);
/*      */     }
/*      */ 
/*  601 */     throwBadObjectException(this.class1);
/*      */ 
/*  603 */     return null;
/*      */   }
/*      */ 
/*      */   Object div()
/*      */     throws Exception
/*      */   {
/*  610 */     computeArgument1();
/*  611 */     computeArgument2();
/*  612 */     if ((this.arg1 == null) || (this.arg2 == null))
/*  613 */       return null;
/*  614 */     switch (this.class1)
/*      */     {
/*      */     case 1:
/*  617 */       switch (this.class2)
/*      */       {
/*      */       case 1:
/*  620 */         return new Double(((Number)this.arg1).doubleValue() / ((Number)this.arg2).doubleValue());
/*      */       case 2:
/*  622 */         return new Double(((Number)this.arg1).doubleValue() / ((Number)this.arg2).doubleValue());
/*      */       }
/*  624 */       throwBadObjectException(this.class2);
/*      */     case 2:
/*  627 */       switch (this.class2)
/*      */       {
/*      */       case 1:
/*  630 */         return new Double(((Number)this.arg1).doubleValue() / ((Number)this.arg2).doubleValue());
/*      */       case 2:
/*  632 */         return new Long(((Number)this.arg1).longValue() / ((Number)this.arg2).longValue());
/*      */       }
/*  634 */       throwBadObjectException(this.class2);
/*      */     }
/*      */ 
/*  637 */     throwBadObjectException(this.class1);
/*      */ 
/*  639 */     return null;
/*      */   }
/*      */ 
/*      */   Object between()
/*      */     throws Exception
/*      */   {
/*  645 */     Object res = ge();
/*  646 */     if (res == null)
/*  647 */       return null;
/*  648 */     if (!((Boolean)res).booleanValue()) {
/*  649 */       return res;
/*      */     }
/*  651 */     Object oper4 = this.oper2;
/*  652 */     this.oper2 = this.oper3;
/*  653 */     res = le();
/*  654 */     this.oper2 = oper4;
/*  655 */     return res;
/*      */   }
/*      */ 
/*      */   Object not_between()
/*      */     throws Exception
/*      */   {
/*  661 */     Object res = lt();
/*  662 */     if (res == null)
/*  663 */       return null;
/*  664 */     if (((Boolean)res).booleanValue()) {
/*  665 */       return res;
/*      */     }
/*  667 */     Object oper4 = this.oper2;
/*  668 */     this.oper2 = this.oper3;
/*  669 */     res = gt();
/*  670 */     this.oper2 = oper4;
/*  671 */     return res;
/*      */   }
/*      */ 
/*      */   Object like(boolean not, boolean use_escape)
/*      */     throws Exception
/*      */   {
/*  687 */     Character escapeChar = null;
/*      */ 
/*  689 */     computeArgument1();
/*  690 */     if (this.arg1 == null)
/*  691 */       return null;
/*  692 */     if (this.class1 != 0) {
/*  693 */       throwBadObjectException(this.class1);
/*      */     }
/*  695 */     computeArgument2();
/*  696 */     if (this.arg2 == null)
/*  697 */       return null;
/*  698 */     if (this.class2 != 0) {
/*  699 */       throwBadObjectException(this.class2);
/*      */     }
/*  701 */     if (use_escape)
/*      */     {
/*  703 */       computeArgument3();
/*  704 */       if (this.arg3 == null) {
/*  705 */         return null;
/*      */       }
/*  707 */       if (this.class3 != 0) {
/*  708 */         throwBadObjectException(this.class3);
/*      */       }
/*  710 */       StringBuffer escapeBuf = new StringBuffer((String)this.arg3);
/*  711 */       if (escapeBuf.length() != 1) {
/*  712 */         throw new Exception("LIKE ESCAPE: Bad escape character " + escapeBuf.toString());
/*      */       }
/*  714 */       escapeChar = new Character(escapeBuf.charAt(0));
/*      */     }
/*      */ 
/*  717 */     if (this.re == null)
/*      */     {
/*  719 */       this.re = new RegExp((String)this.arg2, escapeChar);
/*      */     }
/*  721 */     boolean result = this.re.isMatch(this.arg1);
/*  722 */     if (not) {
/*  723 */       result = !result;
/*      */     }
/*  725 */     if (result == true) {
/*  726 */       return Boolean.TRUE;
/*      */     }
/*  728 */     return Boolean.FALSE;
/*      */   }
/*      */ 
/*      */   Object in()
/*      */     throws Exception
/*      */   {
/*  734 */     computeArgument1();
/*  735 */     if (this.arg1 == null)
/*  736 */       return null;
/*  737 */     if (((HashSet)this.oper2).contains(this.arg1)) {
/*  738 */       return Boolean.TRUE;
/*      */     }
/*  740 */     return Boolean.FALSE;
/*      */   }
/*      */ 
/*      */   Object not_in()
/*      */     throws Exception
/*      */   {
/*  746 */     computeArgument1();
/*  747 */     if (this.arg1 == null)
/*  748 */       return null;
/*  749 */     if (this.class1 != 0)
/*  750 */       throwBadObjectException(this.class1);
/*  751 */     if (((HashSet)this.oper2).contains(this.arg1)) {
/*  752 */       return Boolean.FALSE;
/*      */     }
/*  754 */     return Boolean.TRUE;
/*      */   }
/*      */ 
/*      */   void computeArgument1()
/*      */     throws Exception
/*      */   {
/*  760 */     Class className = this.oper1.getClass();
/*      */ 
/*  762 */     if (className == Identifier.class)
/*  763 */       this.arg1 = ((Identifier)this.oper1).value;
/*  764 */     else if (className == Operator.class)
/*  765 */       this.arg1 = ((Operator)this.oper1).apply();
/*      */     else {
/*  767 */       this.arg1 = this.oper1;
/*      */     }
/*  769 */     if (this.arg1 == null)
/*      */     {
/*  771 */       this.class1 = 0;
/*  772 */       return;
/*      */     }
/*      */ 
/*  775 */     className = this.arg1.getClass();
/*      */ 
/*  777 */     if (className == String.class) {
/*  778 */       this.class1 = 0;
/*  779 */     } else if (className == Double.class) {
/*  780 */       this.class1 = 1;
/*  781 */     } else if (className == Long.class) {
/*  782 */       this.class1 = 2;
/*  783 */     } else if (className == Integer.class)
/*      */     {
/*  785 */       this.class1 = 2;
/*  786 */       this.arg1 = new Long(((Integer)this.arg1).longValue());
/*      */     }
/*  788 */     else if (className == Short.class)
/*      */     {
/*  790 */       this.class1 = 2;
/*  791 */       this.arg1 = new Long(((Short)this.arg1).longValue());
/*      */     }
/*  793 */     else if (className == Byte.class)
/*      */     {
/*  795 */       this.class1 = 2;
/*  796 */       this.arg1 = new Long(((Byte)this.arg1).longValue());
/*      */     }
/*  798 */     else if (className == Float.class)
/*      */     {
/*  800 */       this.class1 = 1;
/*  801 */       this.arg1 = new Double(((Float)this.arg1).doubleValue());
/*      */     }
/*  803 */     else if (className == Boolean.class) {
/*  804 */       this.class1 = 3;
/*      */     } else {
/*  806 */       throwBadObjectException(className);
/*      */     }
/*      */   }
/*      */ 
/*      */   void computeArgument2() throws Exception {
/*  811 */     Class className = this.oper2.getClass();
/*      */ 
/*  813 */     if (className == Identifier.class)
/*  814 */       this.arg2 = ((Identifier)this.oper2).value;
/*  815 */     else if (className == Operator.class)
/*  816 */       this.arg2 = ((Operator)this.oper2).apply();
/*      */     else {
/*  818 */       this.arg2 = this.oper2;
/*      */     }
/*  820 */     if (this.arg2 == null)
/*      */     {
/*  822 */       this.class2 = 0;
/*  823 */       return;
/*      */     }
/*      */ 
/*  826 */     className = this.arg2.getClass();
/*      */ 
/*  828 */     if (className == String.class) {
/*  829 */       this.class2 = 0;
/*  830 */     } else if (className == Double.class) {
/*  831 */       this.class2 = 1;
/*  832 */     } else if (className == Long.class) {
/*  833 */       this.class2 = 2;
/*  834 */     } else if (className == Integer.class)
/*      */     {
/*  836 */       this.class2 = 2;
/*  837 */       this.arg2 = new Long(((Integer)this.arg2).longValue());
/*      */     }
/*  839 */     else if (className == Short.class)
/*      */     {
/*  841 */       this.class2 = 2;
/*  842 */       this.arg2 = new Long(((Short)this.arg2).longValue());
/*      */     }
/*  844 */     else if (className == Byte.class)
/*      */     {
/*  846 */       this.class2 = 2;
/*  847 */       this.arg2 = new Long(((Byte)this.arg2).longValue());
/*      */     }
/*  849 */     else if (className == Float.class)
/*      */     {
/*  851 */       this.class2 = 1;
/*  852 */       this.arg2 = new Double(((Float)this.arg2).doubleValue());
/*      */     }
/*  854 */     else if (className == Boolean.class) {
/*  855 */       this.class2 = 3;
/*      */     } else {
/*  857 */       throwBadObjectException(className);
/*      */     }
/*      */   }
/*      */ 
/*      */   void computeArgument3() throws Exception {
/*  862 */     Class className = this.oper3.getClass();
/*      */ 
/*  864 */     if (className == Identifier.class)
/*  865 */       this.arg3 = ((Identifier)this.oper3).value;
/*  866 */     else if (className == Operator.class)
/*  867 */       this.arg3 = ((Operator)this.oper3).apply();
/*      */     else {
/*  869 */       this.arg3 = this.oper3;
/*      */     }
/*  871 */     if (this.arg3 == null)
/*      */     {
/*  873 */       this.class3 = 0;
/*  874 */       return;
/*      */     }
/*      */ 
/*  877 */     className = this.arg3.getClass();
/*      */ 
/*  879 */     if (className == String.class) {
/*  880 */       this.class3 = 0;
/*  881 */     } else if (className == Double.class) {
/*  882 */       this.class3 = 1;
/*  883 */     } else if (className == Long.class) {
/*  884 */       this.class3 = 2;
/*  885 */     } else if (className == Integer.class)
/*      */     {
/*  887 */       this.class3 = 2;
/*  888 */       this.arg3 = new Long(((Integer)this.arg3).longValue());
/*      */     }
/*  890 */     else if (className == Short.class)
/*      */     {
/*  892 */       this.class3 = 2;
/*  893 */       this.arg3 = new Long(((Short)this.arg3).longValue());
/*      */     }
/*  895 */     else if (className == Byte.class)
/*      */     {
/*  897 */       this.class3 = 2;
/*  898 */       this.arg3 = new Long(((Byte)this.arg3).longValue());
/*      */     }
/*  900 */     else if (className == Float.class)
/*      */     {
/*  902 */       this.class3 = 1;
/*  903 */       this.arg3 = new Double(((Float)this.arg3).doubleValue());
/*      */     }
/*  905 */     else if (className == Boolean.class) {
/*  906 */       this.class3 = 3;
/*      */     } else {
/*  908 */       throwBadObjectException(className);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object apply() throws Exception {
/*  913 */     switch (this.operation)
/*      */     {
/*      */     case 0:
/*  916 */       return equal();
/*      */     case 1:
/*  918 */       return not();
/*      */     case 2:
/*  920 */       return and();
/*      */     case 3:
/*  922 */       return or();
/*      */     case 4:
/*  924 */       return gt();
/*      */     case 5:
/*  926 */       return ge();
/*      */     case 6:
/*  928 */       return lt();
/*      */     case 7:
/*  930 */       return le();
/*      */     case 8:
/*  932 */       return different();
/*      */     case 9:
/*  934 */       return add();
/*      */     case 10:
/*  936 */       return sub();
/*      */     case 11:
/*  938 */       return neg();
/*      */     case 12:
/*  940 */       return mul();
/*      */     case 13:
/*  942 */       return div();
/*      */     case 14:
/*  944 */       return between();
/*      */     case 15:
/*  946 */       return not_between();
/*      */     case 16:
/*  948 */       return like(false, false);
/*      */     case 17:
/*  950 */       return like(true, false);
/*      */     case 18:
/*  952 */       return like(false, true);
/*      */     case 19:
/*  954 */       return like(true, true);
/*      */     case 20:
/*  956 */       return is_null();
/*      */     case 21:
/*  958 */       return is_not_null();
/*      */     case 22:
/*  960 */       return in();
/*      */     case 23:
/*  962 */       return not_in();
/*      */     }
/*      */ 
/*  965 */     throw new Exception("Unknown operation: " + toString());
/*      */   }
/*      */ 
/*      */   public void throwBadObjectException(Class class1) throws Exception
/*      */   {
/*  970 */     throw new Exception("Bad Object: '" + class1.getName() + "' for operation: " + toString());
/*      */   }
/*      */ 
/*      */   public void throwBadObjectException(int class1) throws Exception
/*      */   {
/*  975 */     throw new Exception("Bad Object: '" + getClassName(class1) + "' for operation: " + toString());
/*      */   }
/*      */ 
/*      */   public void throwBadObjectException(int class1, int class2) throws Exception
/*      */   {
/*  980 */     throw new Exception("Bad Object: expected '" + getClassName(class1) + "' got '" + getClassName(class2) + "' for operation: " + toString());
/*      */   }
/*      */ 
/*      */   static String getClassName(int class1)
/*      */   {
/*  985 */     String str = "Unknown";
/*  986 */     switch (class1)
/*      */     {
/*      */     case 0:
/*  989 */       str = "String";
/*  990 */       break;
/*      */     case 2:
/*  992 */       str = "Long";
/*  993 */       break;
/*      */     case 1:
/*  995 */       str = "Double";
/*  996 */       break;
/*      */     case 3:
/*  998 */       str = "Boolean";
/*      */     }
/*      */ 
/* 1001 */     return str;
/*      */   }
/*      */ 
/*      */   static String operationString(int operation)
/*      */   {
/* 1006 */     String str = "Unknown";
/* 1007 */     switch (operation)
/*      */     {
/*      */     case 0:
/* 1010 */       str = "EQUAL";
/* 1011 */       break;
/*      */     case 1:
/* 1013 */       str = "NOT";
/* 1014 */       break;
/*      */     case 2:
/* 1016 */       str = "AND";
/* 1017 */       break;
/*      */     case 3:
/* 1019 */       str = "OR";
/* 1020 */       break;
/*      */     case 4:
/* 1022 */       str = "GT";
/* 1023 */       break;
/*      */     case 5:
/* 1025 */       str = "GE";
/* 1026 */       break;
/*      */     case 6:
/* 1028 */       str = "LT";
/* 1029 */       break;
/*      */     case 7:
/* 1031 */       str = "LE";
/* 1032 */       break;
/*      */     case 8:
/* 1034 */       str = "DIFFERENT";
/* 1035 */       break;
/*      */     case 9:
/* 1037 */       str = "ADD";
/* 1038 */       break;
/*      */     case 10:
/* 1040 */       str = "SUB";
/* 1041 */       break;
/*      */     case 11:
/* 1043 */       str = "NEG";
/* 1044 */       break;
/*      */     case 12:
/* 1046 */       str = "MUL";
/* 1047 */       break;
/*      */     case 13:
/* 1049 */       str = "DIV";
/* 1050 */       break;
/*      */     case 14:
/* 1052 */       str = "BETWEEN";
/* 1053 */       break;
/*      */     case 15:
/* 1055 */       str = "NOT_BETWEEN";
/* 1056 */       break;
/*      */     case 16:
/* 1058 */       str = "LIKE";
/* 1059 */       break;
/*      */     case 17:
/* 1061 */       str = "NOT_LIKE";
/* 1062 */       break;
/*      */     case 18:
/* 1064 */       str = "LIKE_ESCAPE";
/* 1065 */       break;
/*      */     case 19:
/* 1067 */       str = "NOT_LIKE_ESCAPE";
/* 1068 */       break;
/*      */     case 20:
/* 1070 */       str = "IS_NULL";
/* 1071 */       break;
/*      */     case 21:
/* 1073 */       str = "IS_NOT_NULL";
/* 1074 */       break;
/*      */     case 22:
/* 1076 */       str = "IN";
/* 1077 */       break;
/*      */     case 23:
/* 1079 */       str = "NOT_IN";
/*      */     }
/*      */ 
/* 1082 */     return str;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.selector.Operator
 * JD-Core Version:    0.6.0
 */