/*     */ package org.jboss.jms.server.security;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.jms.JMSSecurityException;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.jms.server.SecurityStore;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.jboss.security.SubjectSecurityManager;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class SecurityMetadataStore
/*     */   implements SecurityStore
/*     */ {
/*  58 */   private static final Logger log = Logger.getLogger(SecurityMetadataStore.class);
/*     */   public static final String SUCKER_USER = "JBM.SUCKER";
/*     */   public static final String DEFAULT_SUCKER_USER_PASSWORD = "CHANGE ME!!";
/*  66 */   private boolean trace = log.isTraceEnabled();
/*     */   private Map queueSecurityConf;
/*     */   private Map topicSecurityConf;
/*     */   private AuthenticationManager authenticationManager;
/*     */   private RealmMapping realmMapping;
/*     */   private Element defaultSecurityConfig;
/*     */   private String securityDomain;
/*     */   private String suckerPassword;
/*     */ 
/*     */   public SecurityMetadataStore()
/*     */   {
/*  85 */     this.queueSecurityConf = new HashMap();
/*  86 */     this.topicSecurityConf = new HashMap();
/*     */   }
/*     */ 
/*     */   public SecurityMetadata getSecurityMetadata(boolean isQueue, String destName)
/*     */   {
/*  93 */     SecurityMetadata m = (SecurityMetadata)(isQueue ? this.queueSecurityConf.get(destName) : this.topicSecurityConf.get(destName));
/*     */ 
/*  96 */     if (m == null)
/*     */     {
/*  99 */       if (this.defaultSecurityConfig != null)
/*     */       {
/* 101 */         log.debug("No SecurityMetadadata was available for " + destName + ", using default security config");
/*     */         try
/*     */         {
/* 104 */           m = new SecurityMetadata(this.defaultSecurityConfig);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 108 */           log.warn("Unable to apply default security for destName, using guest " + destName, e);
/* 109 */           m = new SecurityMetadata();
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 115 */         log.warn("No SecurityMetadadata was available for " + destName + ", adding guest");
/* 116 */         m = new SecurityMetadata();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 123 */     return m;
/*     */   }
/*     */ 
/*     */   public void setSecurityConfig(boolean isQueue, String destName, Element conf) throws Exception
/*     */   {
/* 128 */     if (this.trace) log.trace("adding security configuration for " + (isQueue ? "queue " : "topic ") + destName);
/*     */ 
/* 130 */     if (conf == null)
/*     */     {
/* 132 */       clearSecurityConfig(isQueue, destName);
/*     */     }
/*     */     else
/*     */     {
/* 136 */       SecurityMetadata m = new SecurityMetadata(conf);
/*     */ 
/* 138 */       if (isQueue)
/*     */       {
/* 140 */         this.queueSecurityConf.put(destName, m);
/*     */       }
/*     */       else
/*     */       {
/* 144 */         this.topicSecurityConf.put(destName, m);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clearSecurityConfig(boolean isQueue, String name) throws Exception
/*     */   {
/* 151 */     if (this.trace) log.trace("clearing security configuration for " + (isQueue ? "queue " : "topic ") + name);
/*     */ 
/* 153 */     if (isQueue)
/*     */     {
/* 155 */       this.queueSecurityConf.remove(name);
/*     */     }
/*     */     else
/*     */     {
/* 159 */       this.topicSecurityConf.remove(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Subject authenticate(String user, String password) throws JMSSecurityException
/*     */   {
/* 165 */     if (this.trace) log.trace("authenticating user " + user);
/*     */ 
/* 167 */     SimplePrincipal principal = new SimplePrincipal(user);
/* 168 */     char[] passwordChars = null;
/* 169 */     if (password != null)
/*     */     {
/* 171 */       passwordChars = password.toCharArray();
/*     */     }
/*     */ 
/* 174 */     Subject subject = new Subject();
/*     */ 
/* 176 */     boolean authenticated = false;
/*     */ 
/* 178 */     if ("JBM.SUCKER".equals(user))
/*     */     {
/* 180 */       if (this.trace) log.trace("Authenticating sucker user");
/*     */ 
/* 182 */       checkDefaultSuckerPassword(password);
/*     */ 
/* 186 */       authenticated = this.suckerPassword.equals(password);
/*     */     }
/*     */     else
/*     */     {
/* 190 */       authenticated = this.authenticationManager.isValid(principal, passwordChars, subject);
/*     */     }
/*     */ 
/* 193 */     if (authenticated)
/*     */     {
/* 197 */       SecurityActions.pushSubjectContext(principal, passwordChars, subject);
/* 198 */       return subject;
/*     */     }
/*     */ 
/* 202 */     throw new JMSSecurityException("User " + user + " is NOT authenticated");
/*     */   }
/*     */ 
/*     */   public boolean authorize(String user, Set rolePrincipals, CheckType checkType)
/*     */   {
/* 208 */     if (this.trace) log.trace("authorizing user " + user + " for role(s) " + rolePrincipals.toString());
/*     */ 
/* 210 */     if ("JBM.SUCKER".equals(user))
/*     */     {
/* 214 */       return (checkType.equals(CheckType.READ)) || (checkType.equals(CheckType.WRITE));
/*     */     }
/*     */ 
/* 217 */     Principal principal = user == null ? null : new SimplePrincipal(user);
/*     */ 
/* 219 */     boolean hasRole = this.realmMapping.doesUserHaveRole(principal, rolePrincipals);
/*     */ 
/* 221 */     if (this.trace) log.trace("user " + user + (hasRole ? " is " : " is NOT ") + "authorized");
/*     */ 
/* 223 */     return hasRole;
/*     */   }
/*     */ 
/*     */   public void setSuckerPassword(String password)
/*     */   {
/* 230 */     checkDefaultSuckerPassword(password);
/*     */ 
/* 232 */     this.suckerPassword = password;
/*     */   }
/*     */ 
/*     */   public void start() throws NamingException
/*     */   {
/* 237 */     if (this.trace) log.trace("initializing SecurityMetadataStore");
/*     */ 
/* 240 */     InitialContext ic = new InitialContext();
/*     */     try
/*     */     {
/* 244 */       Object mgr = ic.lookup(this.securityDomain);
/*     */ 
/* 246 */       log.debug("JaasSecurityManager is " + mgr);
/*     */ 
/* 248 */       this.authenticationManager = ((AuthenticationManager)mgr);
/* 249 */       this.realmMapping = ((RealmMapping)mgr);
/*     */ 
/* 251 */       log.trace("SecurityMetadataStore initialized");
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 256 */       log.warn("Failed to lookup securityDomain " + this.securityDomain, e);
/*     */ 
/* 258 */       if (!this.securityDomain.startsWith("java:/jaas/"))
/*     */       {
/* 260 */         this.authenticationManager = ((SubjectSecurityManager)ic.lookup("java:/jaas/" + this.securityDomain));
/*     */       }
/*     */       else
/*     */       {
/* 265 */         throw e;
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 270 */       ic.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 280 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String securityDomain)
/*     */   {
/* 285 */     this.securityDomain = securityDomain;
/*     */   }
/*     */ 
/*     */   public Element getDefaultSecurityConfig()
/*     */   {
/* 290 */     return this.defaultSecurityConfig;
/*     */   }
/*     */ 
/*     */   public void setDefaultSecurityConfig(Element conf)
/*     */     throws Exception
/*     */   {
/* 296 */     new SecurityMetadata(conf);
/* 297 */     this.defaultSecurityConfig = conf;
/*     */   }
/*     */ 
/*     */   private void checkDefaultSuckerPassword(String password)
/*     */   {
/* 309 */     if ("CHANGE ME!!".equals(password))
/*     */     {
/* 311 */       log.warn("WARNING! POTENTIAL SECURITY RISK. It has been detected that the MessageSucker component which sucks messages from one node to another has not had its password changed from the installation default. Please see the JBoss Messaging user guide for instructions on how to do this.");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.security.SecurityMetadataStore
 * JD-Core Version:    0.6.0
 */