/*     */ package org.jboss.jms.server.security;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class SecurityMetadata
/*     */ {
/*  51 */   static Role DEFAULT_ROLE = new Role("guest", true, true, true);
/*     */ 
/*  70 */   HashMap roles = new HashMap();
/*  71 */   HashSet read = new HashSet();
/*  72 */   HashSet write = new HashSet();
/*  73 */   HashSet create = new HashSet();
/*  74 */   static Logger log = Logger.getLogger(SecurityMetadata.class);
/*     */ 
/*     */   public SecurityMetadata() {
/*  77 */     addRole(DEFAULT_ROLE);
/*     */   }
/*     */ 
/*     */   public SecurityMetadata(String conf)
/*     */     throws Exception
/*     */   {
/*  86 */     configure(conf);
/*     */   }
/*     */   public SecurityMetadata(Element conf) throws Exception {
/*  89 */     configure(conf);
/*     */   }
/*     */ 
/*     */   public void configure(String conf)
/*     */     throws Exception
/*     */   {
/* 102 */     Element sec = null;
/* 103 */     if (conf != null) {
/* 104 */       DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/* 105 */       DocumentBuilder parser = factory.newDocumentBuilder();
/* 106 */       Document doc = parser.parse(new InputSource(new StringReader(conf)));
/* 107 */       sec = doc.getDocumentElement();
/*     */     }
/*     */ 
/* 110 */     configure(sec);
/*     */   }
/*     */ 
/*     */   public void configure(Element sec) throws Exception
/*     */   {
/* 115 */     if (sec == null) {
/* 116 */       addRole(DEFAULT_ROLE);
/*     */     }
/*     */     else {
/* 119 */       if (!sec.getTagName().equals("security")) {
/* 120 */         throw new SAXException("Configuration document not valid: root element must be security, not " + sec.getTagName());
/*     */       }
/*     */ 
/* 123 */       NodeList list = sec.getElementsByTagName("role");
/* 124 */       int l = list.getLength();
/* 125 */       for (int i = 0; i < l; i++) {
/* 126 */         Element role = (Element)list.item(i);
/* 127 */         Attr na = role.getAttributeNode("name");
/* 128 */         if (na == null)
/* 129 */           throw new SAXException("There must exist a name attribute of role");
/* 130 */         String n = na.getValue();
/* 131 */         boolean r = role.getAttributeNode("read") != null ? Boolean.valueOf(role.getAttributeNode("read").getValue()).booleanValue() : false;
/* 132 */         boolean w = role.getAttributeNode("write") != null ? Boolean.valueOf(role.getAttributeNode("write").getValue()).booleanValue() : false;
/* 133 */         boolean c = role.getAttributeNode("create") != null ? Boolean.valueOf(role.getAttributeNode("create").getValue()).booleanValue() : false;
/* 134 */         addRole(n, r, w, c);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addRole(String name, boolean read, boolean write, boolean create)
/*     */   {
/* 141 */     Role r = new Role(name, read, write, create);
/* 142 */     addRole(r);
/*     */   }
/*     */ 
/*     */   public void addRole(Role r) {
/* 146 */     if (log.isTraceEnabled()) {
/* 147 */       log.trace("Adding role: " + r.toString());
/*     */     }
/* 149 */     this.roles.put(r.name, r);
/* 150 */     SimplePrincipal p = new SimplePrincipal(r.name);
/* 151 */     if (r.read == true)
/* 152 */       this.read.add(p);
/* 153 */     if (r.write == true)
/* 154 */       this.write.add(p);
/* 155 */     if (r.create == true)
/* 156 */       this.create.add(p);
/*     */   }
/*     */ 
/*     */   public Set getReadPrincipals() {
/* 160 */     return this.read;
/*     */   }
/*     */ 
/*     */   public Set getWritePrincipals() {
/* 164 */     return this.write;
/*     */   }
/*     */ 
/*     */   public Set getCreatePrincipals() {
/* 168 */     return this.create;
/*     */   }
/*     */ 
/*     */   static class Role
/*     */   {
/*     */     String name;
/*  55 */     boolean read = false;
/*  56 */     boolean write = false;
/*  57 */     boolean create = false;
/*     */ 
/*  59 */     public Role(String name, boolean read, boolean write, boolean create) { this.name = name;
/*  60 */       this.read = read;
/*  61 */       this.write = write;
/*  62 */       this.create = create; }
/*     */ 
/*     */     public String toString() {
/*  65 */       return "Role {name=" + this.name + ";read=" + this.read + ";write=" + this.write + ";create=" + this.create + "}";
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.security.SecurityMetadata
 * JD-Core Version:    0.6.0
 */