/*     */ package org.jboss.jms.server.security;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   static void pushSubjectContext(Principal principal, Object credential, Subject subject)
/*     */   {
/* 111 */     if (System.getSecurityManager() == null)
/*     */     {
/* 113 */       PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
/*     */     }
/*     */     else
/*     */     {
/* 117 */       PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface PrincipalInfoAction
/*     */   {
/*  43 */     public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction()
/*     */     {
/*     */       public void push(Principal principal, Object credential, Subject subject)
/*     */       {
/*  48 */         AccessController.doPrivileged(new PrivilegedAction(subject, principal, credential)
/*     */         {
/*     */           public Object run()
/*     */           {
/*  53 */             SecurityAssociation.pushSubjectContext(this.val$subject, this.val$principal, this.val$credential);
/*  54 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void dup() {
/*  61 */         AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/*  66 */             SecurityAssociation.dupSubjectContext();
/*  67 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void pop() {
/*  74 */         AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/*  79 */             SecurityAssociation.popSubjectContext();
/*  80 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*  43 */     };
/*     */ 
/*  87 */     public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction()
/*     */     {
/*     */       public void push(Principal principal, Object credential, Subject subject)
/*     */       {
/*  91 */         SecurityAssociation.pushSubjectContext(subject, principal, credential);
/*     */       }
/*     */ 
/*     */       public void dup() {
/*  95 */         SecurityAssociation.dupSubjectContext();
/*     */       }
/*     */ 
/*     */       public void pop() {
/*  99 */         SecurityAssociation.popSubjectContext();
/*     */       }
/*  87 */     };
/*     */ 
/*     */     public abstract void push(Principal paramPrincipal, Object paramObject, Subject paramSubject);
/*     */ 
/*     */     public abstract void dup();
/*     */ 
/*     */     public abstract void pop();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.security.SecurityActions
 * JD-Core Version:    0.6.0
 */