/*     */ package org.jboss.jms.server.remoting;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.EOFException;
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.net.Socket;
/*     */ import java.util.Map;
/*     */ import org.jboss.jms.client.remoting.ClientSocketWrapper;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ServerSocketWrapper extends ClientSocketWrapper
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(ServerSocketWrapper.class);
/*     */ 
/*  51 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public ServerSocketWrapper(Socket socket)
/*     */     throws Exception
/*     */   {
/*  57 */     super(socket);
/*     */   }
/*     */ 
/*     */   public ServerSocketWrapper(Socket socket, Map metadata, Integer timeout) throws Exception
/*     */   {
/*  62 */     super(socket, metadata, timeout);
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/*  69 */     if (getSocket() != null)
/*     */     {
/*     */       try
/*     */       {
/*  73 */         getOutputStream().write(1);
/*  74 */         getOutputStream().flush();
/*  75 */         log.debug("wrote CLOSING byte");
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*  79 */         log.debug("cannot write CLOSING byte", e);
/*     */       }
/*  81 */       super.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void checkConnection()
/*     */     throws IOException
/*     */   {
/*  90 */     byte ACK = 0;
/*     */     try
/*     */     {
/*  94 */       ACK = ((DataInputStream)getInputStream()).readByte();
/*     */     }
/*     */     catch (EOFException eof)
/*     */     {
/*  98 */       if (this.trace)
/*     */       {
/* 100 */         log.trace("socket timeout is set to: " + getTimeout());
/* 101 */         log.trace("EOFException waiting on ACK in readByte().");
/*     */       }
/* 103 */       throw eof;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 107 */       log.trace("IOException when reading in ACK", e);
/* 108 */       throw e;
/*     */     }
/*     */ 
/* 111 */     if (this.trace) log.trace("acknowledge read byte " + Thread.currentThread());
/*     */ 
/* 113 */     DataOutputStream out = (DataOutputStream)getOutputStream();
/* 114 */     out.writeByte(ACK);
/* 115 */     out.flush();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 120 */     Socket socket = getSocket();
/* 121 */     return "ServerSocketWrapper[" + socket + "." + Integer.toHexString(System.identityHashCode(socket)) + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.remoting.ServerSocketWrapper
 * JD-Core Version:    0.6.0
 */