/*    */ package org.jboss.jms.server.remoting;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.OutputStream;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class CountingOutputStream extends OutputStream
/*    */ {
/* 44 */   private static final Logger log = Logger.getLogger(CountingOutputStream.class);
/*    */   private OutputStream os;
/*    */   private int count;
/*    */   private boolean trace;
/*    */ 
/*    */   public CountingOutputStream(OutputStream os)
/*    */   {
/* 56 */     this.trace = true;
/*    */ 
/* 58 */     this.os = os;
/*    */   }
/*    */ 
/*    */   public void write(int b) throws IOException
/*    */   {
/* 63 */     this.os.write(b);
/*    */ 
/* 65 */     if (this.trace)
/*    */     {
/* 67 */       log.trace(this + "Wrote byte " + this.count + ": " + b);
/*    */     }
/*    */ 
/* 70 */     this.count += 1;
/*    */   }
/*    */ 
/*    */   public void flush() throws IOException
/*    */   {
/* 75 */     this.os.flush();
/*    */ 
/* 77 */     if (this.trace)
/*    */     {
/* 79 */       log.trace(this + "Flushed stream");
/*    */ 
/* 81 */       this.count = 0;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.remoting.CountingOutputStream
 * JD-Core Version:    0.6.0
 */