/*     */ package org.jboss.jms.server.messagecounter;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.Timer;
/*     */ import java.util.TimerTask;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.MessagingComponent;
/*     */ 
/*     */ public class MessageCounterManager
/*     */   implements MessagingComponent
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(MessageCounterManager.class);
/*     */   private Map messageCounters;
/*     */   private boolean started;
/*     */   private Timer timer;
/*     */   private long period;
/*     */   private PingMessageCountersTask task;
/*     */ 
/*     */   public MessageCounterManager(long period)
/*     */   {
/*  61 */     this.messageCounters = new HashMap();
/*     */ 
/*  63 */     this.period = period;
/*     */   }
/*     */ 
/*     */   public synchronized void start()
/*     */   {
/*  68 */     if (this.started)
/*     */     {
/*  70 */       log.warn(this + " already started");
/*     */ 
/*  72 */       return;
/*     */     }
/*     */ 
/*  76 */     this.timer = new Timer(true);
/*     */ 
/*  78 */     this.task = new PingMessageCountersTask();
/*     */ 
/*  80 */     this.timer.schedule(this.task, 0L, this.period);
/*     */ 
/*  82 */     this.started = true;
/*     */   }
/*     */ 
/*     */   public synchronized void stop()
/*     */   {
/*  87 */     if (!this.started)
/*     */     {
/*  89 */       log.warn(this + " isn't started");
/*     */ 
/*  91 */       return;
/*     */     }
/*     */ 
/*  96 */     this.task.stop();
/*     */ 
/*  98 */     this.timer.cancel();
/*     */ 
/* 100 */     this.timer = null;
/*     */ 
/* 102 */     this.started = false;
/*     */   }
/*     */ 
/*     */   public synchronized void reschedule(long newPeriod)
/*     */   {
/* 107 */     boolean wasStarted = this.started;
/*     */ 
/* 109 */     if (wasStarted)
/*     */     {
/* 111 */       stop();
/*     */     }
/*     */ 
/* 114 */     this.period = newPeriod;
/*     */ 
/* 116 */     if (wasStarted)
/*     */     {
/* 118 */       start();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void registerMessageCounter(String name, MessageCounter counter)
/*     */   {
/* 124 */     synchronized (this.messageCounters)
/*     */     {
/* 126 */       this.messageCounters.put(name, counter);
/*     */     }
/*     */   }
/*     */ 
/*     */   public MessageCounter unregisterMessageCounter(String name)
/*     */   {
/* 132 */     synchronized (this.messageCounters)
/*     */     {
/* 134 */       return (MessageCounter)this.messageCounters.remove(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Set getMessageCounters()
/*     */   {
/* 140 */     synchronized (this.messageCounters)
/*     */     {
/* 142 */       return new HashSet(this.messageCounters.values());
/*     */     }
/*     */   }
/*     */ 
/*     */   public MessageCounter getMessageCounter(String name)
/*     */   {
/* 148 */     synchronized (this.messageCounters)
/*     */     {
/* 150 */       return (MessageCounter)this.messageCounters.get(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void resetAllCounters()
/*     */   {
/* 156 */     synchronized (this.messageCounters)
/*     */     {
/* 158 */       Iterator iter = this.messageCounters.values().iterator();
/*     */ 
/* 160 */       while (iter.hasNext())
/*     */       {
/* 162 */         MessageCounter counter = (MessageCounter)iter.next();
/*     */ 
/* 164 */         counter.resetCounter();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void resetAllCounterHistories()
/*     */   {
/* 171 */     synchronized (this.messageCounters)
/*     */     {
/* 173 */       Iterator iter = this.messageCounters.values().iterator();
/*     */ 
/* 175 */       while (iter.hasNext())
/*     */       {
/* 177 */         MessageCounter counter = (MessageCounter)iter.next();
/*     */ 
/* 179 */         counter.resetHistory();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   class PingMessageCountersTask extends TimerTask {
/*     */     PingMessageCountersTask() {
/*     */     }
/*     */ 
/*     */     public synchronized void run() {
/* 188 */       synchronized (MessageCounterManager.this.messageCounters)
/*     */       {
/* 190 */         Iterator iter = MessageCounterManager.this.messageCounters.values().iterator();
/*     */ 
/* 192 */         while (iter.hasNext())
/*     */         {
/* 194 */           MessageCounter counter = (MessageCounter)iter.next();
/*     */ 
/* 196 */           counter.onTimer();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     synchronized void stop()
/*     */     {
/* 203 */       cancel();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.messagecounter.MessageCounterManager
 * JD-Core Version:    0.6.0
 */