/*      */ package org.jboss.jms.server.endpoint;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
/*      */ import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
/*      */ import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
/*      */ import java.lang.ref.WeakReference;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.Comparator;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import javax.jms.IllegalStateException;
/*      */ import javax.jms.InvalidDestinationException;
/*      */ import javax.jms.JMSException;
/*      */ import org.jboss.aop.AspectManager;
/*      */ import org.jboss.jms.client.delegate.ClientBrowserDelegate;
/*      */ import org.jboss.jms.client.delegate.ClientConsumerDelegate;
/*      */ import org.jboss.jms.delegate.Ack;
/*      */ import org.jboss.jms.delegate.BrowserDelegate;
/*      */ import org.jboss.jms.delegate.Cancel;
/*      */ import org.jboss.jms.delegate.ConsumerDelegate;
/*      */ import org.jboss.jms.delegate.DeliveryInfo;
/*      */ import org.jboss.jms.delegate.DeliveryRecovery;
/*      */ import org.jboss.jms.delegate.SessionEndpoint;
/*      */ import org.jboss.jms.destination.JBossDestination;
/*      */ import org.jboss.jms.destination.JBossQueue;
/*      */ import org.jboss.jms.destination.JBossTopic;
/*      */ import org.jboss.jms.message.JBossMessage;
/*      */ import org.jboss.jms.server.DestinationManager;
/*      */ import org.jboss.jms.server.JMSCondition;
/*      */ import org.jboss.jms.server.ServerPeer;
/*      */ import org.jboss.jms.server.destination.ManagedDestination;
/*      */ import org.jboss.jms.server.destination.ManagedQueue;
/*      */ import org.jboss.jms.server.destination.ManagedTopic;
/*      */ import org.jboss.jms.server.endpoint.advised.BrowserAdvised;
/*      */ import org.jboss.jms.server.endpoint.advised.ConsumerAdvised;
/*      */ import org.jboss.jms.server.messagecounter.MessageCounter;
/*      */ import org.jboss.jms.server.messagecounter.MessageCounterManager;
/*      */ import org.jboss.jms.server.selector.Selector;
/*      */ import org.jboss.jms.wireformat.ClientDelivery;
/*      */ import org.jboss.jms.wireformat.Dispatcher;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.messaging.core.contract.Binding;
/*      */ import org.jboss.messaging.core.contract.Channel;
/*      */ import org.jboss.messaging.core.contract.Condition;
/*      */ import org.jboss.messaging.core.contract.Delivery;
/*      */ import org.jboss.messaging.core.contract.DeliveryObserver;
/*      */ import org.jboss.messaging.core.contract.Distributor;
/*      */ import org.jboss.messaging.core.contract.Filter;
/*      */ import org.jboss.messaging.core.contract.Message;
/*      */ import org.jboss.messaging.core.contract.MessageReference;
/*      */ import org.jboss.messaging.core.contract.MessageStore;
/*      */ import org.jboss.messaging.core.contract.PersistenceManager;
/*      */ import org.jboss.messaging.core.contract.PostOffice;
/*      */ import org.jboss.messaging.core.contract.Queue;
/*      */ import org.jboss.messaging.core.contract.Replicator;
/*      */ import org.jboss.messaging.core.impl.IDManager;
/*      */ import org.jboss.messaging.core.impl.MessagingQueue;
/*      */ import org.jboss.messaging.core.impl.tx.Transaction;
/*      */ import org.jboss.messaging.core.impl.tx.TransactionException;
/*      */ import org.jboss.messaging.core.impl.tx.TransactionRepository;
/*      */ import org.jboss.messaging.core.impl.tx.TxCallback;
/*      */ import org.jboss.messaging.util.ExceptionUtil;
/*      */ import org.jboss.messaging.util.GUIDGenerator;
/*      */ import org.jboss.messaging.util.MessageQueueNameHelper;
/*      */ import org.jboss.remoting.Client;
/*      */ import org.jboss.remoting.callback.Callback;
/*      */ import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
/*      */ 
/*      */ public class ServerSessionEndpoint
/*      */   implements SessionEndpoint
/*      */ {
/*  123 */   private static final Logger log = Logger.getLogger(ServerSessionEndpoint.class);
/*      */   static final String DUR_SUB_STATE_CONSUMERS = "C";
/*      */   static final String TEMP_QUEUE_MESSAGECOUNTER_PREFIX = "TempQueue.";
/*      */   private static final long DELIVERY_WAIT_TIMEOUT = 5000L;
/*      */   private static final long CLOSE_WAIT_TIMEOUT = 5000L;
/*  137 */   private boolean trace = log.isTraceEnabled();
/*      */   private String id;
/*      */   private volatile boolean closed;
/*      */   private ServerConnectionEndpoint connectionEndpoint;
/*      */   private ServerInvokerCallbackHandler callbackHandler;
/*      */   private ServerPeer sp;
/*      */   private Map consumers;
/*      */   private Map browsers;
/*      */   private PersistenceManager pm;
/*      */   private MessageStore ms;
/*      */   private DestinationManager dm;
/*      */   private IDManager idm;
/*      */   private TransactionRepository tr;
/*      */   private PostOffice postOffice;
/*      */   private int nodeId;
/*      */   private int defaultMaxDeliveryAttempts;
/*      */   private long defaultRedeliveryDelay;
/*      */   private Queue defaultDLQ;
/*      */   private Queue defaultExpiryQueue;
/*      */   private boolean supportsFailover;
/*      */   private boolean replicating;
/*  166 */   private Object deliveryLock = new Object();
/*      */   private Map deliveries;
/*      */   private SynchronizedLong deliveryIdSequence;
/*  174 */   QueuedExecutor executor = new QueuedExecutor(new LinkedQueue());
/*      */ 
/*  176 */   private LinkedQueue toDeliver = new LinkedQueue();
/*      */ 
/*  178 */   private boolean waitingToClose = false;
/*      */ 
/*  180 */   private Object waitLock = new Object();
/*      */ 
/*  374 */   private volatile long expectedSequence = 0L;
/*      */ 
/*  376 */   private Map<Long, JBossMessage> heldBack = new HashMap();
/*      */ 
/*      */   ServerSessionEndpoint(String sessionID, ServerConnectionEndpoint connectionEndpoint, boolean replicating)
/*      */     throws Exception
/*      */   {
/*  187 */     this.id = sessionID;
/*      */ 
/*  189 */     this.connectionEndpoint = connectionEndpoint;
/*      */ 
/*  191 */     this.replicating = replicating;
/*      */ 
/*  193 */     this.callbackHandler = connectionEndpoint.getCallbackHandler();
/*      */ 
/*  195 */     this.sp = connectionEndpoint.getServerPeer();
/*      */ 
/*  197 */     this.pm = this.sp.getPersistenceManagerInstance();
/*      */ 
/*  199 */     this.ms = this.sp.getMessageStore();
/*      */ 
/*  201 */     this.dm = this.sp.getDestinationManager();
/*      */ 
/*  203 */     this.postOffice = this.sp.getPostOfficeInstance();
/*      */ 
/*  205 */     this.supportsFailover = ((connectionEndpoint.getConnectionFactoryEndpoint().isSupportsFailover()) && (this.postOffice.isClustered()));
/*      */ 
/*  207 */     this.idm = this.sp.getChannelIDManager();
/*      */ 
/*  209 */     this.nodeId = this.sp.getServerPeerID();
/*      */ 
/*  211 */     this.tr = this.sp.getTxRepository();
/*      */ 
/*  213 */     this.consumers = new HashMap();
/*      */ 
/*  215 */     this.browsers = new HashMap();
/*      */ 
/*  217 */     this.defaultDLQ = this.sp.getDefaultDLQInstance();
/*      */ 
/*  219 */     this.defaultExpiryQueue = this.sp.getDefaultExpiryQueueInstance();
/*      */ 
/*  221 */     this.tr = this.sp.getTxRepository();
/*      */ 
/*  223 */     this.defaultMaxDeliveryAttempts = this.sp.getDefaultMaxDeliveryAttempts();
/*      */ 
/*  225 */     this.defaultRedeliveryDelay = this.sp.getDefaultRedeliveryDelay();
/*      */ 
/*  227 */     this.deliveries = new ConcurrentHashMap();
/*      */ 
/*  229 */     this.deliveryIdSequence = new SynchronizedLong(0L);
/*      */   }
/*      */ 
/*      */   public ConsumerDelegate createConsumerDelegate(JBossDestination jmsDestination, String selector, boolean noLocal, String subscriptionName, boolean isCC, boolean autoFlowControl)
/*      */     throws JMSException
/*      */   {
/*      */     try
/*      */     {
/*  247 */       if (jmsDestination.isDirect())
/*      */       {
/*  249 */         return createConsumerDelegateDirect(jmsDestination.getName(), selector);
/*      */       }
/*      */ 
/*  253 */       return createConsumerDelegateInternal(jmsDestination, selector, noLocal, subscriptionName);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*      */     }
/*      */ 
/*  259 */     throw ExceptionUtil.handleJMSInvocation(t, this + " createConsumerDelegate");
/*      */   }
/*      */ 
/*      */   public BrowserDelegate createBrowserDelegate(JBossDestination jmsDestination, String selector)
/*      */     throws JMSException
/*      */   {
/*      */     try
/*      */     {
/*  269 */       return createBrowserDelegateInternal(jmsDestination, selector);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  273 */     throw ExceptionUtil.handleJMSInvocation(t, this + " createBrowserDelegate");
/*      */   }
/*      */ 
/*      */   public JBossQueue createQueue(String name)
/*      */     throws JMSException
/*      */   {
/*      */     try
/*      */     {
/*  281 */       if (this.closed)
/*      */       {
/*  283 */         throw new IllegalStateException("Session is closed");
/*      */       }
/*      */ 
/*  286 */       ManagedDestination dest = this.dm.getDestination(name, true);
/*      */ 
/*  288 */       if (dest == null)
/*      */       {
/*  290 */         throw new JMSException("There is no administratively defined queue with name:" + name);
/*      */       }
/*      */ 
/*  293 */       return new JBossQueue(dest.getName());
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  297 */     throw ExceptionUtil.handleJMSInvocation(t, this + " createQueue");
/*      */   }
/*      */ 
/*      */   public JBossTopic createTopic(String name)
/*      */     throws JMSException
/*      */   {
/*      */     try
/*      */     {
/*  305 */       if (this.closed)
/*      */       {
/*  307 */         throw new IllegalStateException("Session is closed");
/*      */       }
/*      */ 
/*  310 */       ManagedDestination dest = this.dm.getDestination(name, false);
/*      */ 
/*  312 */       if (dest == null)
/*      */       {
/*  314 */         throw new JMSException("There is no administratively defined topic with name:" + name);
/*      */       }
/*      */ 
/*  317 */       return new JBossTopic(name);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  321 */     throw ExceptionUtil.handleJMSInvocation(t, this + " createTopic");
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws JMSException
/*      */   {
/*      */     try
/*      */     {
/*  329 */       localClose();
/*      */ 
/*  331 */       this.connectionEndpoint.removeSession(this.id);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  335 */       throw ExceptionUtil.handleJMSInvocation(t, this + " close");
/*      */     }
/*      */   }
/*      */ 
/*      */   public long closing(long sequence) throws JMSException
/*      */   {
/*  341 */     if (this.trace) log.trace(this + " closing");
/*      */ 
/*  345 */     if (sequence != 0L)
/*      */     {
/*  347 */       synchronized (this.waitLock)
/*      */       {
/*  349 */         long wait = 5000L;
/*      */ 
/*  351 */         while ((sequence != this.expectedSequence) && (wait > 0L))
/*      */         {
/*  353 */           long start = System.currentTimeMillis();
/*      */           try
/*      */           {
/*  356 */             this.waitLock.wait();
/*      */           }
/*      */           catch (InterruptedException e)
/*      */           {
/*      */           }
/*  361 */           wait -= System.currentTimeMillis() - start;
/*      */         }
/*      */ 
/*  364 */         if (wait <= 0L)
/*      */         {
/*  366 */           log.warn("Timed out waiting for last message");
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  371 */     return -1L;
/*      */   }
/*      */ 
/*      */   public void send(JBossMessage message, boolean checkForDuplicates)
/*      */     throws JMSException
/*      */   {
/*  380 */     throw new IllegalStateException("Should not be handled on the server");
/*      */   }
/*      */ 
/*      */   public void send(JBossMessage message, boolean checkForDuplicates, long thisSequence) throws JMSException
/*      */   {
/*      */     try
/*      */     {
/*  387 */       if (thisSequence != -1L)
/*      */       {
/*  395 */         synchronized (this.waitLock)
/*      */         {
/*  397 */           if (thisSequence == this.expectedSequence)
/*      */           {
/*      */             do
/*      */             {
/*  401 */               this.connectionEndpoint.sendMessage(message, null, checkForDuplicates);
/*      */ 
/*  403 */               this.expectedSequence += 1L;
/*      */ 
/*  405 */               message = (JBossMessage)this.heldBack.remove(Long.valueOf(this.expectedSequence));
/*      */             }
/*  407 */             while (message != null);
/*      */           }
/*      */           else
/*      */           {
/*  413 */             this.heldBack.put(Long.valueOf(thisSequence), message);
/*      */           }
/*      */ 
/*  416 */           this.waitLock.notify();
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  421 */         this.connectionEndpoint.sendMessage(message, null, checkForDuplicates);
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  426 */       throw ExceptionUtil.handleJMSInvocation(t, this + " send");
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean acknowledgeDelivery(Ack ack) throws JMSException
/*      */   {
/*      */     try
/*      */     {
/*  434 */       return acknowledgeDeliveryInternal(ack);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  438 */     throw ExceptionUtil.handleJMSInvocation(t, this + " acknowledgeDelivery");
/*      */   }
/*      */ 
/*      */   public void acknowledgeDeliveries(List acks)
/*      */     throws JMSException
/*      */   {
/*  444 */     if (this.trace) log.trace(this + " acknowledges deliveries " + acks);
/*      */ 
/*      */     try
/*      */     {
/*  448 */       Iterator iter = acks.iterator();
/*      */ 
/*  450 */       while (iter.hasNext())
/*      */       {
/*  452 */         Ack ack = (Ack)iter.next();
/*      */ 
/*  454 */         acknowledgeDeliveryInternal(ack);
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  459 */       throw ExceptionUtil.handleJMSInvocation(t, this + " acknowledgeDeliveries");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void cancelDelivery(Cancel cancel) throws JMSException
/*      */   {
/*  465 */     if (this.trace) log.trace(this + " cancelDelivery " + cancel);
/*      */ 
/*      */     try
/*      */     {
/*  469 */       Delivery del = cancelDeliveryInternal(cancel);
/*      */ 
/*  471 */       if (del != null)
/*      */       {
/*  474 */         promptDelivery((Channel)del.getObserver());
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  479 */       throw ExceptionUtil.handleJMSInvocation(t, this + " cancelDelivery");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void cancelDeliveries(List cancels) throws JMSException
/*      */   {
/*  485 */     if (this.trace) log.trace(this + " cancels deliveries " + cancels);
/*      */ 
/*      */     try
/*      */     {
/*  491 */       Set channels = new HashSet();
/*      */ 
/*  493 */       for (int i = cancels.size() - 1; i >= 0; i--)
/*      */       {
/*  495 */         Cancel cancel = (Cancel)cancels.get(i);
/*      */ 
/*  497 */         if (this.trace) log.trace(this + " cancelling delivery " + cancel.getDeliveryId());
/*      */ 
/*  499 */         Delivery del = cancelDeliveryInternal(cancel);
/*      */ 
/*  501 */         if (del == null)
/*      */           continue;
/*  503 */         channels.add(del.getObserver());
/*      */       }
/*      */ 
/*  507 */       if (this.trace) log.trace("Cancelled deliveries");
/*      */ 
/*  511 */       promptDelivery(channels);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  515 */       throw ExceptionUtil.handleJMSInvocation(t, this + " cancelDeliveries");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void recoverDeliveries(List deliveryRecoveryInfos, String oldSessionID) throws JMSException
/*      */   {
/*  521 */     if (this.trace) log.trace(this + " recovers deliveries " + deliveryRecoveryInfos);
/*      */ 
/*      */     try
/*      */     {
/*  525 */       if (!this.postOffice.isClustered())
/*      */       {
/*  527 */         throw new IllegalStateException("Recovering deliveries but post office is not clustered!");
/*      */       }
/*      */ 
/*  530 */       long maxDeliveryId = 0L;
/*      */ 
/*  533 */       Map ackMap = new HashMap();
/*      */ 
/*  535 */       for (Iterator iter = deliveryRecoveryInfos.iterator(); iter.hasNext(); )
/*      */       {
/*  537 */         DeliveryRecovery deliveryInfo = (DeliveryRecovery)iter.next();
/*      */ 
/*  539 */         String queueName = deliveryInfo.getQueueName();
/*      */ 
/*  541 */         List acks = (List)ackMap.get(queueName);
/*      */ 
/*  543 */         if (acks == null)
/*      */         {
/*  545 */           acks = new ArrayList();
/*      */ 
/*  547 */           ackMap.put(queueName, acks);
/*      */         }
/*      */ 
/*  550 */         acks.add(deliveryInfo);
/*      */       }
/*      */ 
/*  553 */       Iterator iter = ackMap.entrySet().iterator();
/*      */ 
/*  555 */       while (iter.hasNext())
/*      */       {
/*  557 */         Map.Entry entry = (Map.Entry)iter.next();
/*      */ 
/*  559 */         String queueName = (String)entry.getKey();
/*      */ 
/*  563 */         Binding binding = this.postOffice.getBindingForQueueName(queueName);
/*      */ 
/*  565 */         Queue queue = binding.queue;
/*      */ 
/*  567 */         if (queue == null)
/*      */         {
/*  569 */           throw new IllegalStateException("Cannot find queue with queue name: " + queueName);
/*      */         }
/*      */ 
/*  572 */         List acks = (List)entry.getValue();
/*      */ 
/*  574 */         List ids = new ArrayList(acks.size());
/*      */ 
/*  576 */         for (Iterator iter2 = acks.iterator(); iter2.hasNext(); )
/*      */         {
/*  578 */           DeliveryRecovery info = (DeliveryRecovery)iter2.next();
/*      */ 
/*  580 */           ids.add(new Long(info.getMessageID()));
/*      */         }
/*      */ 
/*  583 */         JMSCondition cond = (JMSCondition)binding.condition;
/*      */ 
/*  585 */         ManagedDestination dest = this.sp.getDestinationManager().getDestination(cond.getName(), cond.isQueue());
/*      */ 
/*  588 */         if (dest == null)
/*      */         {
/*  590 */           throw new IllegalStateException("Cannot find managed destination with name " + cond.getName() + " isQueue" + cond.isQueue());
/*      */         }
/*      */ 
/*  594 */         Queue dlqToUse = dest.getDLQ() == null ? this.defaultDLQ : dest.getDLQ();
/*      */ 
/*  597 */         Queue expiryQueueToUse = dest.getExpiryQueue() == null ? this.defaultExpiryQueue : dest.getExpiryQueue();
/*      */ 
/*  600 */         int maxDeliveryAttemptsToUse = dest.getMaxDeliveryAttempts() == -1 ? this.defaultMaxDeliveryAttempts : dest.getMaxDeliveryAttempts();
/*      */ 
/*  603 */         List dels = queue.recoverDeliveries(ids);
/*      */ 
/*  605 */         Iterator iter2 = dels.iterator();
/*      */ 
/*  607 */         Iterator iter3 = acks.iterator();
/*      */ 
/*  609 */         while (iter2.hasNext())
/*      */         {
/*  611 */           Delivery del = (Delivery)iter2.next();
/*      */ 
/*  613 */           DeliveryRecovery info = (DeliveryRecovery)iter3.next();
/*      */ 
/*  615 */           long deliveryId = info.getDeliveryID();
/*      */ 
/*  617 */           maxDeliveryId = Math.max(maxDeliveryId, deliveryId);
/*      */ 
/*  619 */           if (this.trace) log.trace(this + " Recovered delivery " + deliveryId + ", " + del);
/*      */ 
/*  621 */           this.deliveries.put(new Long(deliveryId), new DeliveryRecord(del, dlqToUse, expiryQueueToUse, dest.getRedeliveryDelay(), maxDeliveryAttemptsToUse, queueName, this.supportsFailover, deliveryId));
/*      */ 
/*  628 */           if (this.supportsFailover)
/*      */           {
/*  630 */             this.postOffice.sendReplicateDeliveryMessage(queueName, this.id, del.getReference().getMessage().getMessageID(), deliveryId, false, true);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*  635 */       iter = this.postOffice.getAllBindings().iterator();
/*      */ 
/*  637 */       while (iter.hasNext())
/*      */       {
/*  639 */         Binding binding = (Binding)iter.next();
/*      */ 
/*  641 */         if ((binding.queue.isClustered()) && (binding.queue.isRecoverable()))
/*      */         {
/*  644 */           binding.queue.removeStrandedReferences(oldSessionID);
/*      */         }
/*      */       }
/*      */ 
/*  648 */       this.deliveryIdSequence = new SynchronizedLong(maxDeliveryId + 1L);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  652 */       throw ExceptionUtil.handleJMSInvocation(t, this + " recoverDeliveries");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addTemporaryDestination(JBossDestination dest) throws JMSException
/*      */   {
/*      */     try
/*      */     {
/*  660 */       if (this.closed)
/*      */       {
/*  662 */         throw new IllegalStateException("Session is closed");
/*      */       }
/*  664 */       if (!dest.isTemporary())
/*      */       {
/*  666 */         throw new InvalidDestinationException("Destination:" + dest + " is not a temporary destination");
/*      */       }
/*      */ 
/*  670 */       this.connectionEndpoint.addTemporaryDestination(dest);
/*      */ 
/*  676 */       int fullSize = this.connectionEndpoint.getDefaultTempQueueFullSize();
/*  677 */       int pageSize = this.connectionEndpoint.getDefaultTempQueuePageSize();
/*  678 */       int downCacheSize = this.connectionEndpoint.getDefaultTempQueueDownCacheSize();
/*      */       ManagedDestination mDest;
/*      */       ManagedDestination mDest;
/*  682 */       if (dest.isTopic())
/*      */       {
/*  684 */         mDest = new ManagedTopic(dest.getName(), fullSize, pageSize, downCacheSize, this.postOffice.isClustered());
/*      */       }
/*      */       else
/*      */       {
/*  688 */         mDest = new ManagedQueue(dest.getName(), fullSize, pageSize, downCacheSize, this.postOffice.isClustered());
/*      */       }
/*      */ 
/*  691 */       mDest.setTemporary(true);
/*      */ 
/*  693 */       this.dm.registerDestination(mDest);
/*      */ 
/*  695 */       if (dest.isQueue())
/*      */       {
/*  697 */         Queue coreQueue = new MessagingQueue(this.nodeId, dest.getName(), this.idm.getID(), this.ms, this.pm, false, -1, null, fullSize, pageSize, downCacheSize, this.postOffice.isClustered(), this.sp.getRecoverDeliveriesTimeout());
/*      */ 
/*  703 */         Condition cond = new JMSCondition(true, dest.getName());
/*      */ 
/*  708 */         this.postOffice.addBinding(new Binding(cond, coreQueue, true), this.postOffice.isClustered());
/*      */ 
/*  710 */         coreQueue.activate();
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  715 */       throw ExceptionUtil.handleJMSInvocation(t, this + " addTemporaryDestination");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void deleteTemporaryDestination(JBossDestination dest) throws JMSException
/*      */   {
/*      */     try
/*      */     {
/*  723 */       if (this.closed)
/*      */       {
/*  725 */         throw new IllegalStateException("Session is closed");
/*      */       }
/*      */ 
/*  728 */       if (!dest.isTemporary())
/*      */       {
/*  730 */         throw new InvalidDestinationException("Destination:" + dest + " is not a temporary destination");
/*      */       }
/*      */ 
/*  734 */       ManagedDestination mDest = this.dm.getDestination(dest.getName(), dest.isQueue());
/*      */ 
/*  736 */       if (mDest == null)
/*      */       {
/*  738 */         throw new InvalidDestinationException("No such destination: " + dest);
/*      */       }
/*      */ 
/*  741 */       if (dest.isQueue())
/*      */       {
/*  743 */         Binding binding = this.postOffice.getBindingForQueueName(dest.getName());
/*      */ 
/*  745 */         if (binding == null)
/*      */         {
/*  747 */           throw new IllegalStateException("Cannot find binding for queue " + dest.getName());
/*      */         }
/*      */ 
/*  750 */         if (binding.queue.getLocalDistributor().getNumberOfReceivers() != 0)
/*      */         {
/*  752 */           throw new IllegalStateException("Cannot delete temporary queue if it has consumer(s)");
/*      */         }
/*      */ 
/*  757 */         this.postOffice.removeBinding(dest.getName(), this.postOffice.isClustered());
/*      */       }
/*      */       else
/*      */       {
/*  762 */         Collection queues = this.postOffice.getQueuesForCondition(new JMSCondition(false, dest.getName()), true);
/*      */ 
/*  764 */         if (!queues.isEmpty())
/*      */         {
/*  766 */           throw new IllegalStateException("Cannot delete temporary topic if it has consumer(s)");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  774 */       this.connectionEndpoint.removeTemporaryDestination(dest);
/*      */ 
/*  776 */       this.dm.unregisterDestination(mDest);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  780 */       throw ExceptionUtil.handleJMSInvocation(t, this + " deleteTemporaryDestination");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void unsubscribe(String subscriptionName) throws JMSException
/*      */   {
/*  786 */     log.trace(this + " unsubscribing " + subscriptionName);
/*      */     try
/*      */     {
/*  790 */       if (this.closed)
/*      */       {
/*  792 */         throw new IllegalStateException("Session is closed");
/*      */       }
/*  794 */       if (subscriptionName == null)
/*      */       {
/*  796 */         throw new InvalidDestinationException("Destination is null");
/*      */       }
/*      */ 
/*  799 */       String clientID = this.connectionEndpoint.getClientID();
/*      */ 
/*  801 */       if (clientID == null)
/*      */       {
/*  803 */         throw new JMSException("null clientID on connection");
/*      */       }
/*      */ 
/*  806 */       String queueName = MessageQueueNameHelper.createSubscriptionName(clientID, subscriptionName);
/*      */ 
/*  808 */       Binding binding = this.postOffice.getBindingForQueueName(queueName);
/*      */ 
/*  810 */       if (binding == null)
/*      */       {
/*  812 */         throw new InvalidDestinationException("Cannot find durable subscription with name " + subscriptionName + " to unsubscribe");
/*      */       }
/*      */ 
/*  816 */       Queue sub = binding.queue;
/*      */ 
/*  823 */       if (sub.getLocalDistributor().getNumberOfReceivers() != 0)
/*      */       {
/*  825 */         throw new IllegalStateException("Cannot unsubscribe durable subscription " + subscriptionName + " since it has active subscribers");
/*      */       }
/*      */ 
/*  831 */       if ((sub.isClustered()) && (this.postOffice.isClustered()))
/*      */       {
/*  833 */         Replicator rep = (Replicator)this.postOffice;
/*      */ 
/*  835 */         Map map = rep.get(sub.getName());
/*      */ 
/*  837 */         if (!map.isEmpty())
/*      */         {
/*  839 */           throw new IllegalStateException("Cannot unsubscribe durable subscription " + subscriptionName + " since it has active subscribers on other nodes");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  844 */       this.postOffice.removeBinding(sub.getName(), (sub.isClustered()) && (this.postOffice.isClustered()));
/*      */ 
/*  846 */       String counterName = "Subscription." + sub.getName();
/*      */ 
/*  848 */       MessageCounter counter = this.sp.getMessageCounterManager().unregisterMessageCounter(counterName);
/*      */ 
/*  850 */       if (counter == null)
/*      */       {
/*  852 */         throw new IllegalStateException("Cannot find counter to remove " + counterName);
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  857 */       throw ExceptionUtil.handleJMSInvocation(t, this + " unsubscribe");
/*      */     }
/*      */   }
/*      */ 
/*      */   public ServerConnectionEndpoint getConnectionEndpoint()
/*      */   {
/*  865 */     return this.connectionEndpoint;
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  870 */     return "SessionEndpoint[" + this.id + "]";
/*      */   }
/*      */ 
/*      */   public void deliverAnyWaitingDeliveries(String queueName)
/*      */     throws Exception
/*      */   {
/*  877 */     if (this.trace) log.trace("Delivering any waiting deliveries: " + queueName);
/*      */ 
/*  879 */     List toAddBack = null;
/*      */     while (true)
/*      */     {
/*  883 */       DeliveryRecord dr = (DeliveryRecord)this.toDeliver.poll(0L);
/*      */ 
/*  885 */       if (dr == null)
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/*  890 */       if (this.trace) log.trace("Considering " + dr);
/*      */ 
/*  892 */       if ((queueName == null) || (dr.queueName.equals(queueName)))
/*      */       {
/*  895 */         synchronized (dr)
/*      */         {
/*  897 */           performDelivery(dr.del.getReference(), dr.deliveryID, dr.getConsumer());
/*      */ 
/*  899 */           dr.waitingForResponse = false;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  904 */         if (toAddBack == null)
/*      */         {
/*  906 */           toAddBack = new ArrayList();
/*      */         }
/*      */ 
/*  909 */         toAddBack.add(dr);
/*      */       }
/*      */     }
/*      */ 
/*  913 */     if (toAddBack != null)
/*      */     {
/*  915 */       Iterator iter = toAddBack.iterator();
/*      */ 
/*  917 */       while (iter.hasNext())
/*      */       {
/*  919 */         this.toDeliver.put(iter.next());
/*      */       }
/*      */     }
/*      */ 
/*  923 */     if (this.trace) log.trace("Done delivering"); 
/*      */   }
/*      */ 
/*      */   public boolean collectDeliveries(Map map, boolean firstNode, String queueName)
/*      */     throws Exception
/*      */   {
/*  928 */     if (this.trace) log.trace("Collecting deliveries");
/*      */ 
/*  930 */     boolean gotSome = false;
/*      */ 
/*  932 */     if ((!firstNode) && (this.replicating))
/*      */     {
/*  934 */       if (this.trace) log.trace("Now collecting");
/*      */ 
/*  936 */       Iterator iter = this.deliveries.entrySet().iterator();
/*      */ 
/*  938 */       while (iter.hasNext())
/*      */       {
/*  940 */         Map.Entry entry = (Map.Entry)iter.next();
/*      */ 
/*  942 */         Long l = (Long)entry.getKey();
/*      */ 
/*  944 */         long deliveryID = l.longValue();
/*      */ 
/*  946 */         DeliveryRecord rec = (DeliveryRecord)entry.getValue();
/*      */ 
/*  948 */         if ((rec.replicating) && ((queueName == null) || (rec.queueName.equals(queueName))))
/*      */         {
/*  950 */           Map ids = (Map)map.get(rec.queueName);
/*      */ 
/*  952 */           if (ids == null)
/*      */           {
/*  954 */             ids = new HashMap();
/*      */ 
/*  956 */             map.put(rec.queueName, ids);
/*      */           }
/*      */ 
/*  959 */           ids.put(new Long(rec.del.getReference().getMessage().getMessageID()), this.id);
/*      */ 
/*  961 */           gotSome = true;
/*      */ 
/*  963 */           boolean notify = false;
/*      */ 
/*  967 */           synchronized (rec)
/*      */           {
/*  969 */             if (rec.waitingForResponse)
/*      */             {
/*  973 */               performDelivery(rec.del.getReference(), deliveryID, rec.getConsumer());
/*      */ 
/*  975 */               rec.waitingForResponse = false;
/*      */ 
/*  977 */               notify = true;
/*      */             }
/*      */           }
/*      */ 
/*  981 */           if (notify)
/*      */           {
/*  983 */             synchronized (this.deliveryLock)
/*      */             {
/*  985 */               if (this.waitingToClose)
/*      */               {
/*  987 */                 this.deliveryLock.notifyAll();
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  995 */     if (this.trace) log.trace("Collected " + map.size() + " deliveries");
/*      */ 
/*  997 */     return gotSome;
/*      */   }
/*      */ 
/*      */   public void replicateDeliveryResponseReceived(long deliveryID)
/*      */     throws Exception
/*      */   {
/* 1004 */     if (this.trace) log.trace(this + " replicate delivery response received for delivery " + deliveryID);
/*      */ 
/* 1006 */     DeliveryRecord rec = (DeliveryRecord)this.deliveries.get(new Long(deliveryID));
/*      */ 
/* 1008 */     if (rec == null)
/*      */     {
/* 1018 */       return;
/*      */     }
/*      */ 
/* 1021 */     boolean delivered = false;
/*      */     while (true)
/*      */     {
/* 1025 */       DeliveryRecord dr = (DeliveryRecord)this.toDeliver.peek();
/*      */ 
/* 1027 */       if (dr == null)
/*      */       {
/* 1029 */         if (!this.trace) break; log.trace("No more deliveries in list"); break;
/*      */       }
/*      */ 
/* 1034 */       if (this.trace) log.trace("Peeked delivery record: " + dr.deliveryID);
/*      */ 
/* 1037 */       synchronized (dr)
/*      */       {
/* 1039 */         boolean performDelivery = false;
/*      */ 
/* 1041 */         if (dr.waitingForResponse)
/*      */         {
/* 1043 */           if (dr == rec)
/*      */           {
/* 1045 */             if (this.trace) log.trace("Found our delivery");
/*      */ 
/* 1047 */             performDelivery = true;
/*      */           }
/*      */           else
/*      */           {
/* 1051 */             if (!delivered)
/*      */             {
/*      */               break;
/*      */             }
/*      */ 
/* 1064 */             break;
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/* 1072 */           if (this.trace) log.trace("Non replicated delivery");
/*      */ 
/* 1074 */           performDelivery = true;
/*      */         }
/*      */ 
/* 1077 */         if (performDelivery)
/*      */         {
/* 1079 */           this.toDeliver.take();
/*      */ 
/* 1081 */           performDelivery(dr.del.getReference(), dr.deliveryID, dr.getConsumer());
/*      */ 
/* 1083 */           delivered = true;
/*      */ 
/* 1085 */           dr.waitingForResponse = false;
/*      */ 
/* 1087 */           delivered = true;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1092 */     if (delivered)
/*      */     {
/* 1094 */       synchronized (this.deliveryLock)
/*      */       {
/* 1096 */         if (this.waitingToClose)
/*      */         {
/* 1098 */           this.deliveryLock.notifyAll();
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void expireDelivery(Delivery del, Queue expiryQueue)
/*      */     throws Throwable
/*      */   {
/* 1108 */     if (this.trace) log.trace(this + " detected expired message " + del.getReference());
/*      */ 
/* 1110 */     if (expiryQueue != null)
/*      */     {
/* 1112 */       if (this.trace) log.trace(this + " sending expired message to expiry queue " + expiryQueue);
/*      */ 
/* 1114 */       JBossMessage copy = makeCopyForDLQOrExpiry(true, del);
/*      */ 
/* 1116 */       moveInTransaction(copy, del, expiryQueue, true);
/*      */     }
/*      */     else
/*      */     {
/* 1120 */       log.warn("No expiry queue has been configured so removing expired " + del.getReference());
/*      */ 
/* 1122 */       del.acknowledge(null);
/*      */     }
/*      */   }
/*      */ 
/*      */   void removeBrowser(String browserId) throws Exception
/*      */   {
/* 1128 */     synchronized (this.browsers)
/*      */     {
/* 1130 */       if (this.browsers.remove(browserId) == null)
/*      */       {
/* 1132 */         throw new IllegalStateException("Cannot find browser with id " + browserId + " to remove");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void removeConsumer(String consumerId) throws Exception
/*      */   {
/* 1139 */     synchronized (this.consumers)
/*      */     {
/* 1141 */       if (this.consumers.remove(consumerId) == null)
/*      */       {
/* 1143 */         throw new IllegalStateException("Cannot find consumer with id " + consumerId + " to remove");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void localClose() throws Throwable
/*      */   {
/* 1150 */     if (this.closed)
/*      */     {
/* 1152 */       throw new IllegalStateException("Session is already closed");
/*      */     }
/*      */ 
/* 1155 */     if (this.trace) log.trace(this + " close()");
/*      */     Map consumersClone;
/* 1159 */     synchronized (this.consumers)
/*      */     {
/* 1161 */       consumersClone = new HashMap(this.consumers);
/*      */     }
/*      */ 
/* 1164 */     for (Iterator i = consumersClone.values().iterator(); i.hasNext(); )
/*      */     {
/* 1166 */       ((ServerConsumerEndpoint)i.next()).localClose();
/*      */     }
/*      */ 
/* 1169 */     this.consumers.clear();
/*      */     Map browsersClone;
/* 1174 */     synchronized (this.browsers)
/*      */     {
/* 1176 */       browsersClone = new HashMap(this.browsers);
/*      */     }
/*      */ 
/* 1179 */     for (Iterator i = browsersClone.values().iterator(); i.hasNext(); )
/*      */     {
/* 1181 */       ((ServerBrowserEndpoint)i.next()).localClose();
/*      */     }
/*      */ 
/* 1184 */     this.browsers.clear();
/*      */ 
/* 1191 */     Object entries = new ArrayList(this.deliveries.entrySet());
/*      */ 
/* 1194 */     Collections.sort((List)entries, new Comparator()
/*      */     {
/*      */       public int compare(Object obj1, Object obj2)
/*      */       {
/* 1199 */         Map.Entry entry1 = (Map.Entry)obj1;
/* 1200 */         Map.Entry entry2 = (Map.Entry)obj2;
/* 1201 */         Long id1 = (Long)entry1.getKey();
/* 1202 */         Long id2 = (Long)entry2.getKey();
/* 1203 */         return id2.compareTo(id1);
/*      */       }
/*      */     });
/* 1207 */     Iterator iter = ((List)entries).iterator();
/*      */ 
/* 1209 */     Set channels = new HashSet();
/*      */ 
/* 1211 */     if (this.trace) log.trace(this + " cancelling " + ((List)entries).size() + " deliveries");
/*      */ 
/* 1213 */     while (iter.hasNext())
/*      */     {
/* 1215 */       Map.Entry entry = (Map.Entry)iter.next();
/*      */ 
/* 1217 */       if (this.trace) log.trace(this + " cancelling delivery with delivery id: " + entry.getKey());
/*      */ 
/* 1219 */       DeliveryRecord rec = (DeliveryRecord)entry.getValue();
/*      */ 
/* 1221 */       rec.del.cancel();
/*      */ 
/* 1223 */       channels.add(rec.del.getObserver());
/*      */     }
/*      */ 
/* 1226 */     promptDelivery(channels);
/*      */ 
/* 1236 */     this.executor.shutdownAfterProcessingCurrentlyQueuedTasks();
/*      */ 
/* 1238 */     this.deliveries.clear();
/*      */ 
/* 1240 */     this.sp.removeSession(this.id);
/*      */ 
/* 1242 */     Dispatcher.instance.unregisterTarget(this.id, this);
/*      */ 
/* 1244 */     this.closed = true;
/*      */   }
/*      */ 
/*      */   void cancelDelivery(long deliveryId) throws Throwable
/*      */   {
/* 1249 */     DeliveryRecord rec = (DeliveryRecord)this.deliveries.remove(new Long(deliveryId));
/*      */ 
/* 1251 */     if (rec == null)
/*      */     {
/* 1253 */       throw new IllegalStateException("Cannot find delivery to cancel " + deliveryId);
/*      */     }
/*      */ 
/* 1256 */     rec.del.cancel();
/*      */   }
/*      */ 
/*      */   void waitForDeliveriesFromConsumer(String consumerID)
/*      */     throws Exception
/*      */   {
/* 1267 */     long toWait = 5000L;
/*      */ 
/* 1271 */     synchronized (this.deliveryLock) {
/*      */       boolean wait;
/*      */       do {
/* 1275 */         wait = false;
/*      */ 
/* 1277 */         long start = System.currentTimeMillis();
/*      */ 
/* 1279 */         Iterator iter = this.deliveries.values().iterator();
/*      */ 
/* 1281 */         while (iter.hasNext())
/*      */         {
/* 1283 */           DeliveryRecord rec = (DeliveryRecord)iter.next();
/*      */ 
/* 1285 */           ServerConsumerEndpoint consumer = rec.getConsumer();
/*      */ 
/* 1287 */           if ((consumer != null) && (consumer.getID().equals(consumerID)) && (rec.waitingForResponse))
/*      */           {
/* 1289 */             wait = true;
/*      */ 
/* 1291 */             break;
/*      */           }
/*      */         }
/*      */ 
/* 1295 */         if (!wait)
/*      */           continue;
/* 1297 */         this.waitingToClose = true;
/*      */         try
/*      */         {
/* 1300 */           this.deliveryLock.wait(toWait);
/*      */         }
/*      */         catch (InterruptedException e)
/*      */         {
/*      */         }
/*      */ 
/* 1306 */         toWait -= System.currentTimeMillis() - start;
/*      */       }
/*      */ 
/* 1309 */       while ((wait) && (toWait > 0L));
/*      */ 
/* 1311 */       if (toWait <= 0L)
/*      */       {
/* 1314 */         while (this.toDeliver.poll(0L) != null);
/* 1318 */         log.warn("Timed out waiting for response to arrive");
/*      */       }
/* 1320 */       this.waitingToClose = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized void handleDelivery(Delivery delivery, ServerConsumerEndpoint consumer)
/*      */     throws Exception
/*      */   {
/* 1328 */     long deliveryId = -1L;
/*      */ 
/* 1330 */     if (this.trace) log.trace(this + " handling delivery " + delivery);
/*      */ 
/* 1332 */     DeliveryRecord rec = null;
/*      */ 
/* 1334 */     deliveryId = this.deliveryIdSequence.increment();
/*      */ 
/* 1336 */     if (this.trace) log.trace("Delivery id is now " + deliveryId);
/*      */ 
/* 1339 */     if (consumer.isRetainDeliveries())
/*      */     {
/* 1343 */       rec = new DeliveryRecord(delivery, consumer, deliveryId);
/*      */ 
/* 1345 */       this.deliveries.put(new Long(deliveryId), rec);
/*      */ 
/* 1347 */       if (this.trace) log.trace(this + " added delivery " + deliveryId + ": " + delivery);
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*      */       try
/*      */       {
/* 1356 */         if (this.trace) log.trace("Acknowledging delivery now");
/*      */ 
/* 1358 */         delivery.acknowledge(null);
/*      */       }
/*      */       catch (Throwable t)
/*      */       {
/* 1362 */         log.error("Failed to acknowledge delivery", t);
/*      */       }
/*      */     }
/*      */ 
/* 1366 */     Message message = delivery.getReference().getMessage();
/*      */ 
/* 1370 */     if ((!consumer.isReplicating()) || (!this.replicating))
/*      */     {
/* 1372 */       if (this.trace) log.trace(this + " doing the delivery straight away");
/*      */ 
/* 1375 */       performDelivery(delivery.getReference(), deliveryId, consumer);
/*      */     }
/* 1377 */     else if (!message.isReliable())
/*      */     {
/* 1379 */       if (!this.toDeliver.isEmpty())
/*      */       {
/* 1381 */         if (this.trace) log.trace("Message is unreliable and there are refs in the toDeliver so adding to list");
/*      */ 
/* 1385 */         this.toDeliver.put(rec);
/*      */ 
/* 1389 */         if (this.toDeliver.peek() == rec)
/*      */         {
/* 1391 */           this.toDeliver.take();
/*      */ 
/* 1393 */           performDelivery(delivery.getReference(), deliveryId, consumer);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1398 */         if (this.trace) log.trace("Message is unreliable, but no deliveries in list so performing delivery now");
/*      */ 
/* 1401 */         performDelivery(delivery.getReference(), deliveryId, consumer);
/*      */       }
/*      */ 
/*      */     }
/* 1406 */     else if (!this.postOffice.isFirstNode())
/*      */     {
/* 1410 */       if (this.trace) log.trace(this + " deferring delivery until we know it's been replicated");
/*      */ 
/* 1412 */       rec.waitingForResponse = true;
/*      */ 
/* 1414 */       this.toDeliver.put(rec);
/*      */ 
/* 1416 */       this.postOffice.sendReplicateDeliveryMessage(consumer.getQueueName(), this.id, delivery.getReference().getMessage().getMessageID(), deliveryId, true, false);
/*      */     }
/*      */     else
/*      */     {
/* 1424 */       rec.waitingForResponse = false;
/*      */ 
/* 1426 */       if (this.trace) log.trace("First node so actually doing delivery now");
/*      */ 
/* 1429 */       performDelivery(delivery.getReference(), deliveryId, consumer);
/*      */     }
/*      */   }
/*      */ 
/*      */   void performDelivery(MessageReference ref, long deliveryID, ServerConsumerEndpoint consumer)
/*      */   {
/* 1436 */     if (consumer == null)
/*      */     {
/* 1438 */       if (this.trace) log.trace(this + " consumer is null, cannot perform delivery");
/*      */ 
/* 1440 */       return;
/*      */     }
/*      */ 
/* 1443 */     if (consumer.isDead())
/*      */     {
/* 1446 */       return;
/*      */     }
/*      */ 
/* 1449 */     if (this.trace) log.trace(this + " performing delivery for " + ref);
/*      */ 
/* 1454 */     Client callbackClient = this.callbackHandler.getCallbackClient();
/*      */ 
/* 1456 */     ClientDelivery del = new ClientDelivery(ref.getMessage(), consumer.getID(), deliveryID, ref.getDeliveryCount());
/*      */ 
/* 1458 */     Callback callback = new Callback(del);
/*      */     try
/*      */     {
/* 1471 */       Object invoker = null;
/*      */ 
/* 1473 */       if (callbackClient != null)
/*      */       {
/* 1475 */         invoker = callbackClient.getInvoker();
/*      */       }
/*      */       else
/*      */       {
/* 1482 */         invoker = new Object();
/*      */       }
/*      */ 
/* 1485 */       synchronized (invoker)
/*      */       {
/* 1488 */         if (this.trace) log.trace(this + " submitting message " + ref.getMessage() + " to the remoting layer to be sent asynchronously");
/*      */ 
/* 1490 */         this.callbackHandler.handleCallbackOneway(callback);
/*      */ 
/* 1493 */         consumer.setLastDeliveryID(deliveryID);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1503 */       log.trace(this + " failed to handle callback", t);
/*      */ 
/* 1508 */       consumer.setStarted(false);
/*      */ 
/* 1510 */       consumer.setDead();
/*      */     }
/*      */   }
/*      */ 
/*      */   void acknowledgeTransactionally(List acks, Transaction tx)
/*      */     throws Throwable
/*      */   {
/* 1521 */     if (this.trace) log.trace(this + " acknowledging transactionally " + acks.size() + " messages for " + tx);
/*      */ 
/* 1523 */     DeliveryCallback deliveryCallback = (DeliveryCallback)tx.getCallback(this);
/*      */ 
/* 1525 */     if (deliveryCallback == null)
/*      */     {
/* 1527 */       deliveryCallback = new DeliveryCallback(null);
/* 1528 */       tx.addCallback(deliveryCallback, this);
/*      */     }
/*      */ 
/* 1531 */     for (Iterator i = acks.iterator(); i.hasNext(); )
/*      */     {
/* 1533 */       Ack ack = (Ack)i.next();
/*      */ 
/* 1535 */       Long id = new Long(ack.getDeliveryID());
/*      */ 
/* 1538 */       if (((ack instanceof DeliveryInfo)) && 
/* 1540 */         (!((DeliveryInfo)ack).isShouldAck()))
/*      */       {
/*      */         continue;
/*      */       }
/*      */ 
/* 1548 */       DeliveryRecord rec = (DeliveryRecord)this.deliveries.get(id);
/*      */ 
/* 1550 */       if (rec == null)
/*      */       {
/* 1552 */         log.warn("Cannot find delivery to acknowledge " + ack);
/* 1553 */         continue;
/*      */       }
/*      */ 
/* 1556 */       deliveryCallback.addDeliveryId(id);
/* 1557 */       rec.del.acknowledge(tx);
/*      */     }
/*      */   }
/*      */ 
/*      */   void setStarted(boolean s)
/*      */     throws Throwable
/*      */   {
/*      */     Map consumersClone;
/* 1568 */     synchronized (this.consumers)
/*      */     {
/* 1570 */       consumersClone = new HashMap(this.consumers);
/*      */     }
/*      */ 
/* 1573 */     for (Iterator i = consumersClone.values().iterator(); i.hasNext(); )
/*      */     {
/* 1575 */       ServerConsumerEndpoint sce = (ServerConsumerEndpoint)i.next();
/* 1576 */       if (s)
/*      */       {
/* 1578 */         sce.start();
/*      */       }
/*      */       else
/*      */       {
/* 1582 */         sce.stop();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void promptDelivery(Channel channel)
/*      */   {
/* 1589 */     if (this.trace) log.trace("Prompting delivery on " + channel);
/*      */ 
/*      */     try
/*      */     {
/* 1598 */       this.executor.execute(new Runnable(channel) { public void run() { this.val$channel.deliver(); } } );
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1603 */       log.error("Failed to prompt delivery", t);
/*      */     }
/*      */   }
/*      */ 
/*      */   private Delivery cancelDeliveryInternal(Cancel cancel)
/*      */     throws Throwable
/*      */   {
/* 1614 */     DeliveryRecord rec = (DeliveryRecord)this.deliveries.remove(new Long(cancel.getDeliveryId()));
/*      */ 
/* 1616 */     if (rec == null)
/*      */     {
/* 1620 */       if (this.trace)
/*      */       {
/* 1622 */         log.trace("Cannot find delivery to cancel, session probably failed over and is not replicated");
/*      */       }
/* 1624 */       return null;
/*      */     }
/*      */ 
/* 1630 */     boolean expired = (cancel.isExpired()) || (rec.del.getReference().getMessage().isExpired());
/*      */ 
/* 1635 */     boolean reachedMaxDeliveryAttempts = (cancel.isReachedMaxDeliveryAttempts()) || (cancel.getDeliveryCount() >= rec.maxDeliveryAttempts);
/*      */ 
/* 1638 */     Delivery del = rec.del;
/*      */ 
/* 1640 */     if ((!expired) && (!reachedMaxDeliveryAttempts))
/*      */     {
/* 1644 */       del.getReference().setDeliveryCount(cancel.getDeliveryCount());
/*      */ 
/* 1648 */       if (rec.redeliveryDelay != 0L)
/*      */       {
/* 1650 */         del.getReference().setScheduledDeliveryTime(System.currentTimeMillis() + rec.redeliveryDelay);
/*      */       }
/*      */ 
/* 1653 */       if (this.trace) log.trace("Cancelling delivery " + cancel.getDeliveryId());
/* 1654 */       del.cancel();
/*      */     }
/* 1658 */     else if (expired)
/*      */     {
/* 1662 */       JBossMessage copy = makeCopyForDLQOrExpiry(true, del);
/*      */ 
/* 1664 */       moveInTransaction(copy, del, rec.expiryQueue, false);
/*      */     }
/*      */     else
/*      */     {
/* 1670 */       JBossMessage copy = makeCopyForDLQOrExpiry(false, del);
/*      */ 
/* 1672 */       moveInTransaction(copy, del, rec.dlq, true);
/*      */     }
/*      */ 
/* 1677 */     this.postOffice.sendReplicateAckMessage(rec.queueName, del.getReference().getMessage().getMessageID());
/*      */ 
/* 1679 */     return rec.del;
/*      */   }
/*      */ 
/*      */   private JBossMessage makeCopyForDLQOrExpiry(boolean expiry, Delivery del)
/*      */     throws Exception
/*      */   {
/* 1690 */     if (this.trace) log.trace("Making copy of message for DLQ or expiry " + del);
/*      */ 
/* 1692 */     JBossMessage msg = (JBossMessage)del.getReference().getMessage();
/*      */ 
/* 1694 */     JBossMessage copy = msg.doCopy();
/*      */ 
/* 1696 */     long newMessageId = this.sp.getMessageIDManager().getID();
/*      */ 
/* 1698 */     copy.setMessageId(newMessageId);
/*      */ 
/* 1701 */     copy.setExpiration(0L);
/*      */ 
/* 1703 */     String origMessageId = msg.getJMSMessageID();
/*      */ 
/* 1705 */     String origDest = msg.getJMSDestination().toString();
/*      */ 
/* 1707 */     copy.setStringProperty("JBM_ORIG_MESSAGE_ID", origMessageId);
/*      */ 
/* 1709 */     copy.setStringProperty("JBM_ORIG_DESTINATION", origDest);
/*      */ 
/* 1711 */     if (expiry)
/*      */     {
/* 1713 */       long actualExpiryTime = System.currentTimeMillis();
/*      */ 
/* 1715 */       copy.setLongProperty("JBM_ACTUAL_EXPIRY", actualExpiryTime);
/*      */     }
/*      */ 
/* 1718 */     return copy;
/*      */   }
/*      */ 
/*      */   private void moveInTransaction(JBossMessage msg, Delivery del, Queue queue, boolean dlq) throws Throwable
/*      */   {
/* 1723 */     Transaction tx = this.tr.createTransaction();
/*      */ 
/* 1725 */     MessageReference ref = msg.createReference();
/*      */     try
/*      */     {
/* 1729 */       if (queue != null)
/*      */       {
/* 1731 */         queue.handle(null, ref, tx);
/* 1732 */         del.acknowledge(tx);
/*      */       }
/*      */       else
/*      */       {
/* 1736 */         log.warn("No " + (dlq ? "DLQ" : "expiry queue") + " has been specified so the message will be removed");
/*      */ 
/* 1738 */         del.acknowledge(tx);
/*      */       }
/*      */ 
/* 1741 */       tx.commit();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1745 */       tx.rollback();
/* 1746 */       throw t;
/*      */     }
/*      */ 
/* 1752 */     if (queue != null)
/*      */     {
/* 1754 */       promptDelivery(queue);
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean acknowledgeDeliveryInternal(Ack ack) throws Throwable
/*      */   {
/* 1760 */     if (this.trace) log.trace(this + " acknowledging delivery " + ack);
/*      */ 
/* 1762 */     DeliveryRecord rec = (DeliveryRecord)this.deliveries.remove(new Long(ack.getDeliveryID()));
/*      */ 
/* 1764 */     if (rec == null)
/*      */     {
/* 1767 */       log.debug("Cannot find " + ack + " to acknowledge, it was probably acknowledged before");
/* 1768 */       return false;
/*      */     }
/*      */ 
/* 1771 */     rec.del.acknowledge(null);
/*      */ 
/* 1775 */     if ((rec.replicating) && (this.replicating))
/*      */     {
/* 1777 */       this.postOffice.sendReplicateAckMessage(rec.queueName, rec.del.getReference().getMessage().getMessageID());
/*      */     }
/*      */ 
/* 1780 */     if (this.trace) log.trace(this + " acknowledged delivery " + ack);
/*      */ 
/* 1782 */     return true;
/*      */   }
/*      */ 
/*      */   private ConsumerDelegate createConsumerDelegateDirect(String queueName, String selectorString)
/*      */     throws Throwable
/*      */   {
/* 1790 */     if (this.closed)
/*      */     {
/* 1792 */       throw new IllegalStateException("Session is closed");
/*      */     }
/*      */ 
/* 1795 */     if ("".equals(selectorString))
/*      */     {
/* 1797 */       selectorString = null;
/*      */     }
/*      */ 
/* 1800 */     if (this.trace)
/*      */     {
/* 1802 */       log.trace(this + " creating direct consumer for " + queueName + (selectorString == null ? "" : new StringBuilder().append(", selector '").append(selectorString).append("'").toString()));
/*      */     }
/*      */ 
/* 1806 */     Binding binding = this.postOffice.getBindingForQueueName(queueName);
/*      */ 
/* 1808 */     if (binding == null)
/*      */     {
/* 1810 */       throw new IllegalArgumentException("Cannot find queue with name " + queueName);
/*      */     }
/*      */ 
/* 1813 */     String consumerID = GUIDGenerator.generateGUID();
/*      */ 
/* 1815 */     int prefetchSize = this.connectionEndpoint.getPrefetchSize();
/*      */ 
/* 1817 */     JBossDestination dest = new JBossQueue(queueName);
/*      */ 
/* 1821 */     ServerConsumerEndpoint ep = new ServerConsumerEndpoint(consumerID, binding.queue, binding.queue.getName(), this, selectorString, false, dest, null, null, 0L, -1, true, false);
/*      */     ConsumerAdvised advised;
/* 1830 */     synchronized (AspectManager.instance())
/*      */     {
/* 1832 */       advised = new ConsumerAdvised(ep);
/*      */     }
/*      */ 
/* 1835 */     Dispatcher.instance.registerTarget(consumerID, advised);
/*      */ 
/* 1837 */     ClientConsumerDelegate stub = new ClientConsumerDelegate(consumerID, prefetchSize, -1, 0L);
/*      */ 
/* 1840 */     synchronized (this.consumers)
/*      */     {
/* 1842 */       this.consumers.put(consumerID, ep);
/*      */     }
/*      */ 
/* 1845 */     log.trace(this + " created and registered " + ep);
/*      */ 
/* 1847 */     return (ConsumerDelegate)stub;
/*      */   }
/*      */ 
/*      */   private ConsumerDelegate createConsumerDelegateInternal(JBossDestination jmsDestination, String selectorString, boolean noLocal, String subscriptionName)
/*      */     throws Throwable
/*      */   {
/* 1856 */     if (this.closed)
/*      */     {
/* 1858 */       throw new IllegalStateException("Session is closed");
/*      */     }
/*      */ 
/* 1861 */     if ("".equals(selectorString))
/*      */     {
/* 1863 */       selectorString = null;
/*      */     }
/*      */ 
/* 1866 */     if (this.trace)
/*      */     {
/* 1868 */       log.trace(this + " creating consumer for " + jmsDestination + (selectorString == null ? "" : new StringBuilder().append(", selector '").append(selectorString).append("'").toString()) + (subscriptionName == null ? "" : new StringBuilder().append(", subscription '").append(subscriptionName).append("'").toString()) + (noLocal ? ", noLocal" : ""));
/*      */     }
/*      */ 
/* 1874 */     ManagedDestination mDest = this.dm.getDestination(jmsDestination.getName(), jmsDestination.isQueue());
/*      */ 
/* 1876 */     if (mDest == null)
/*      */     {
/* 1878 */       throw new InvalidDestinationException("No such destination: " + jmsDestination + " has it been deployed?");
/*      */     }
/*      */ 
/* 1881 */     if (jmsDestination.isTemporary())
/*      */     {
/* 1885 */       if (!this.connectionEndpoint.hasTemporaryDestination(jmsDestination))
/*      */       {
/* 1887 */         String msg = "Cannot create a message consumer on a different connection to that which created the temporary destination";
/*      */ 
/* 1889 */         throw new IllegalStateException(msg);
/*      */       }
/*      */     }
/*      */ 
/* 1893 */     String consumerID = GUIDGenerator.generateGUID();
/*      */ 
/* 1896 */     Selector selector = null;
/*      */ 
/* 1898 */     if (selectorString != null)
/*      */     {
/* 1900 */       selector = new Selector(selectorString);
/*      */     }
/*      */     Queue queue;
/* 1905 */     if (jmsDestination.isTopic())
/*      */     {
/* 1907 */       if (subscriptionName == null)
/*      */       {
/* 1910 */         if (log.isTraceEnabled()) log.trace(this + " creating new non-durable subscription on " + jmsDestination);
/*      */ 
/* 1914 */         Queue queue = new MessagingQueue(this.nodeId, GUIDGenerator.generateGUID(), this.idm.getID(), this.ms, this.pm, false, mDest.getMaxSize(), selector, mDest.getFullSize(), mDest.getPageSize(), mDest.getDownCacheSize(), mDest.isClustered(), this.sp.getRecoverDeliveriesTimeout());
/*      */ 
/* 1923 */         JMSCondition topicCond = new JMSCondition(false, jmsDestination.getName());
/*      */ 
/* 1925 */         this.postOffice.addBinding(new Binding(topicCond, queue, false), false);
/*      */ 
/* 1927 */         queue.activate();
/*      */ 
/* 1929 */         String counterName = "Subscription." + queue.getName();
/*      */ 
/* 1931 */         int dayLimitToUse = mDest.getMessageCounterHistoryDayLimit();
/* 1932 */         if (dayLimitToUse == -1)
/*      */         {
/* 1935 */           dayLimitToUse = this.sp.getDefaultMessageCounterHistoryDayLimit();
/*      */         }
/*      */ 
/* 1939 */         if (!mDest.isTemporary())
/*      */         {
/* 1941 */           MessageCounter counter = new MessageCounter(counterName, null, queue, true, false, dayLimitToUse);
/*      */ 
/* 1943 */           this.sp.getMessageCounterManager().registerMessageCounter(counterName, counter);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1948 */         if (jmsDestination.isTemporary())
/*      */         {
/* 1950 */           throw new InvalidDestinationException("Cannot create a durable subscription on a temporary topic");
/*      */         }
/*      */ 
/* 1954 */         String clientID = this.connectionEndpoint.getClientID();
/* 1955 */         if (clientID == null)
/*      */         {
/* 1957 */           throw new JMSException("Cannot create durable subscriber without a valid client ID");
/*      */         }
/*      */ 
/* 1962 */         String name = MessageQueueNameHelper.createSubscriptionName(clientID, subscriptionName);
/*      */ 
/* 1964 */         Binding binding = this.postOffice.getBindingForQueueName(name);
/*      */ 
/* 1966 */         if (binding == null)
/*      */         {
/* 1970 */           if (this.trace) log.trace(this + " creating new durable subscription on " + jmsDestination);
/*      */ 
/* 1972 */           Queue queue = new MessagingQueue(this.nodeId, name, this.idm.getID(), this.ms, this.pm, true, mDest.getMaxSize(), selector, mDest.getFullSize(), mDest.getPageSize(), mDest.getDownCacheSize(), mDest.isClustered(), this.sp.getRecoverDeliveriesTimeout());
/*      */ 
/* 1983 */           this.postOffice.addBinding(new Binding(new JMSCondition(false, jmsDestination.getName()), queue, true), (this.postOffice.isClustered()) && (mDest.isClustered()));
/*      */ 
/* 1986 */           queue.activate();
/*      */ 
/* 1989 */           if (!mDest.isTemporary())
/*      */           {
/* 1991 */             String counterName = "Subscription." + queue.getName();
/*      */ 
/* 1993 */             MessageCounter counter = new MessageCounter(counterName, subscriptionName, queue, true, true, mDest.getMessageCounterHistoryDayLimit());
/*      */ 
/* 1997 */             this.sp.getMessageCounterManager().registerMessageCounter(counterName, counter);
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/* 2004 */           Queue queue = binding.queue;
/*      */ 
/* 2006 */           if (this.trace) log.trace(this + " subscription " + subscriptionName + " already exists");
/*      */ 
/* 2011 */           if (queue.getLocalDistributor().getNumberOfReceivers() > 0)
/*      */           {
/* 2013 */             throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
/*      */           }
/*      */ 
/* 2019 */           String counterName = "Subscription." + queue.getName();
/*      */ 
/* 2021 */           boolean createCounter = false;
/*      */ 
/* 2023 */           if (this.sp.getMessageCounterManager().getMessageCounter(counterName) == null)
/*      */           {
/* 2025 */             createCounter = true;
/*      */           }
/*      */ 
/* 2034 */           String filterString = queue.getFilter() != null ? queue.getFilter().getFilterString() : null;
/*      */ 
/* 2036 */           boolean selectorChanged = ((selectorString == null) && (filterString != null)) || ((filterString == null) && (selectorString != null)) || ((filterString != null) && (selectorString != null) && (!filterString.equals(selectorString)));
/*      */ 
/* 2042 */           if (this.trace) log.trace("selector " + (selectorChanged ? "has" : "has NOT") + " changed");
/*      */ 
/* 2044 */           String oldTopicName = ((JMSCondition)binding.condition).getName();
/*      */ 
/* 2046 */           boolean topicChanged = !oldTopicName.equals(jmsDestination.getName());
/*      */ 
/* 2048 */           if (log.isTraceEnabled()) log.trace("topic " + (topicChanged ? "has" : "has NOT") + " changed");
/*      */ 
/* 2050 */           if ((selectorChanged) || (topicChanged))
/*      */           {
/* 2052 */             if (this.trace) log.trace("topic or selector changed so deleting old subscription");
/*      */ 
/* 2058 */             this.postOffice.removeBinding(queue.getName(), (this.postOffice.isClustered()) && (mDest.isClustered()));
/*      */ 
/* 2062 */             queue = new MessagingQueue(this.nodeId, name, this.idm.getID(), this.ms, this.pm, true, mDest.getMaxSize(), selector, mDest.getFullSize(), mDest.getPageSize(), mDest.getDownCacheSize(), mDest.isClustered(), this.sp.getRecoverDeliveriesTimeout());
/*      */ 
/* 2072 */             this.postOffice.addBinding(new Binding(new JMSCondition(false, jmsDestination.getName()), queue, true), (this.postOffice.isClustered()) && (mDest.isClustered()));
/*      */ 
/* 2075 */             queue.activate();
/*      */ 
/* 2077 */             if (!mDest.isTemporary())
/*      */             {
/* 2079 */               createCounter = true;
/*      */             }
/*      */           }
/*      */ 
/* 2083 */           if (createCounter)
/*      */           {
/* 2085 */             MessageCounter counter = new MessageCounter(counterName, subscriptionName, queue, true, true, mDest.getMessageCounterHistoryDayLimit());
/*      */ 
/* 2089 */             this.sp.getMessageCounterManager().registerMessageCounter(counterName, counter);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 2100 */       queue = this.postOffice.getBindingForQueueName(jmsDestination.getName()).queue;
/*      */ 
/* 2102 */       if (queue == null)
/*      */       {
/* 2104 */         throw new IllegalStateException("Cannot find queue: " + jmsDestination.getName());
/*      */       }
/*      */     }
/*      */ 
/* 2108 */     int prefetchSize = this.connectionEndpoint.getPrefetchSize();
/*      */ 
/* 2110 */     Queue dlqToUse = mDest.getDLQ() == null ? this.defaultDLQ : mDest.getDLQ();
/*      */ 
/* 2112 */     Queue expiryQueueToUse = mDest.getExpiryQueue() == null ? this.defaultExpiryQueue : mDest.getExpiryQueue();
/*      */ 
/* 2114 */     int maxDeliveryAttemptsToUse = mDest.getMaxDeliveryAttempts() == -1 ? this.defaultMaxDeliveryAttempts : mDest.getMaxDeliveryAttempts();
/*      */ 
/* 2116 */     long redeliveryDelayToUse = mDest.getRedeliveryDelay() == -1L ? this.defaultRedeliveryDelay : mDest.getRedeliveryDelay();
/*      */ 
/* 2120 */     boolean replicating = (this.supportsFailover) && (queue.isClustered()) && ((!jmsDestination.isTopic()) || (queue.isRecoverable()));
/*      */ 
/* 2122 */     ServerConsumerEndpoint ep = new ServerConsumerEndpoint(consumerID, queue, queue.getName(), this, selectorString, noLocal, jmsDestination, dlqToUse, expiryQueueToUse, redeliveryDelayToUse, maxDeliveryAttemptsToUse, false, replicating);
/*      */ 
/* 2128 */     if ((queue.isClustered()) && (this.postOffice.isClustered()) && (jmsDestination.isTopic()) && (subscriptionName != null))
/*      */     {
/* 2137 */       Replicator rep = (Replicator)this.postOffice;
/*      */ 
/* 2139 */       rep.put(queue.getName(), "C");
/*      */     }
/*      */     ConsumerAdvised advised;
/* 2146 */     synchronized (AspectManager.instance())
/*      */     {
/* 2148 */       advised = new ConsumerAdvised(ep);
/*      */     }
/*      */ 
/* 2151 */     Dispatcher.instance.registerTarget(consumerID, advised);
/*      */ 
/* 2153 */     ClientConsumerDelegate stub = new ClientConsumerDelegate(consumerID, prefetchSize, maxDeliveryAttemptsToUse, redeliveryDelayToUse);
/*      */ 
/* 2156 */     synchronized (this.consumers)
/*      */     {
/* 2158 */       this.consumers.put(consumerID, ep);
/*      */     }
/*      */ 
/* 2161 */     log.trace(this + " created and registered " + ep);
/*      */ 
/* 2163 */     return (ConsumerDelegate)stub;
/*      */   }
/*      */ 
/*      */   private BrowserDelegate createBrowserDelegateInternal(JBossDestination jmsDestination, String selector)
/*      */     throws Throwable
/*      */   {
/* 2169 */     if (this.closed)
/*      */     {
/* 2171 */       throw new IllegalStateException("Session is closed");
/*      */     }
/*      */ 
/* 2174 */     if (jmsDestination == null)
/*      */     {
/* 2176 */       throw new InvalidDestinationException("null destination");
/*      */     }
/*      */ 
/* 2179 */     if (jmsDestination.isTopic())
/*      */     {
/* 2181 */       throw new IllegalStateException("Cannot browse a topic");
/*      */     }
/*      */ 
/* 2184 */     if (this.dm.getDestination(jmsDestination.getName(), jmsDestination.isQueue()) == null)
/*      */     {
/* 2186 */       throw new InvalidDestinationException("No such destination: " + jmsDestination);
/*      */     }
/*      */ 
/* 2189 */     log.trace(this + " creating browser for " + jmsDestination + (selector == null ? "" : new StringBuilder().append(", selector '").append(selector).append("'").toString()));
/*      */ 
/* 2192 */     Binding binding = this.postOffice.getBindingForQueueName(jmsDestination.getName());
/*      */ 
/* 2194 */     if (binding == null)
/*      */     {
/* 2196 */       throw new IllegalStateException("Cannot find queue with name " + jmsDestination.getName());
/*      */     }
/*      */ 
/* 2199 */     String browserID = GUIDGenerator.generateGUID();
/*      */ 
/* 2201 */     ServerBrowserEndpoint ep = new ServerBrowserEndpoint(this, browserID, binding.queue, selector);
/*      */ 
/* 2204 */     synchronized (this.browsers)
/*      */     {
/* 2206 */       this.browsers.put(browserID, ep);
/*      */     }
/*      */     BrowserAdvised advised;
/* 2213 */     synchronized (AspectManager.instance())
/*      */     {
/* 2215 */       advised = new BrowserAdvised(ep);
/*      */     }
/*      */ 
/* 2218 */     Dispatcher.instance.registerTarget(browserID, advised);
/*      */ 
/* 2220 */     ClientBrowserDelegate stub = new ClientBrowserDelegate(browserID);
/*      */ 
/* 2222 */     log.trace(this + " created and registered " + ep);
/*      */ 
/* 2224 */     return (BrowserDelegate)stub;
/*      */   }
/*      */ 
/*      */   private void promptDelivery(Set channels)
/*      */   {
/* 2230 */     Iterator iter = channels.iterator();
/*      */ 
/* 2232 */     while (iter.hasNext())
/*      */     {
/* 2234 */       DeliveryObserver observer = (DeliveryObserver)iter.next();
/*      */ 
/* 2236 */       promptDelivery((Channel)observer);
/*      */     }
/*      */   }
/*      */ 
/*      */   private class DeliveryCallback
/*      */     implements TxCallback
/*      */   {
/* 2339 */     List delList = new ArrayList();
/*      */ 
/*      */     private DeliveryCallback()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void beforePrepare()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void beforeCommit(boolean onePhase)
/*      */     {
/*      */     }
/*      */ 
/*      */     public void beforeRollback(boolean onePhase)
/*      */     {
/*      */     }
/*      */ 
/*      */     public void afterPrepare()
/*      */     {
/*      */     }
/*      */ 
/*      */     public synchronized void afterCommit(boolean onePhase)
/*      */       throws TransactionException
/*      */     {
/* 2364 */       Iterator iter = this.delList.iterator();
/* 2365 */       while (iter.hasNext())
/*      */       {
/* 2367 */         Long deliveryId = (Long)iter.next();
/*      */ 
/* 2369 */         ServerSessionEndpoint.DeliveryRecord del = (ServerSessionEndpoint.DeliveryRecord)ServerSessionEndpoint.this.deliveries.remove(deliveryId);
/*      */ 
/* 2371 */         if ((del != null) && (del.replicating))
/*      */         {
/*      */           try
/*      */           {
/* 2376 */             ServerSessionEndpoint.this.postOffice.sendReplicateAckMessage(del.queueName, del.del.getReference().getMessage().getMessageID());
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/* 2380 */             throw new TransactionException("Failed to handle send ack", e);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     public void afterRollback(boolean onePhase)
/*      */       throws TransactionException
/*      */     {
/*      */     }
/*      */ 
/*      */     synchronized void addDeliveryId(Long deliveryId)
/*      */     {
/* 2396 */       this.delList.add(deliveryId);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class DeliveryRecord
/*      */   {
/*      */     Delivery del;
/*      */     Queue dlq;
/*      */     Queue expiryQueue;
/*      */     long redeliveryDelay;
/*      */     int maxDeliveryAttempts;
/*      */     WeakReference consumerRef;
/*      */     String queueName;
/*      */     boolean replicating;
/*      */     volatile boolean waitingForResponse;
/*      */     long deliveryID;
/*      */ 
/*      */     ServerConsumerEndpoint getConsumer()
/*      */     {
/* 2280 */       if (this.consumerRef != null)
/*      */       {
/* 2282 */         return (ServerConsumerEndpoint)this.consumerRef.get();
/*      */       }
/*      */ 
/* 2286 */       return null;
/*      */     }
/*      */ 
/*      */     DeliveryRecord(Delivery del, Queue dlq, Queue expiryQueue, long redeliveryDelay, int maxDeliveryAttempts, String queueName, boolean replicating, long deliveryID)
/*      */     {
/* 2293 */       this.del = del;
/*      */ 
/* 2295 */       this.dlq = dlq;
/*      */ 
/* 2297 */       this.expiryQueue = expiryQueue;
/*      */ 
/* 2299 */       this.redeliveryDelay = redeliveryDelay;
/*      */ 
/* 2301 */       this.maxDeliveryAttempts = maxDeliveryAttempts;
/*      */ 
/* 2303 */       this.queueName = queueName;
/*      */ 
/* 2305 */       this.replicating = replicating;
/*      */ 
/* 2307 */       this.deliveryID = deliveryID;
/*      */     }
/*      */ 
/*      */     DeliveryRecord(Delivery del, ServerConsumerEndpoint consumer, long deliveryID)
/*      */     {
/* 2312 */       this(del, consumer.getDLQ(), consumer.getExpiryQueue(), consumer.getRedliveryDelay(), consumer.getMaxDeliveryAttempts(), consumer.getQueueName(), consumer.isReplicating(), deliveryID);
/*      */ 
/* 2322 */       this.consumerRef = new WeakReference(consumer);
/*      */     }
/*      */ 
/*      */     public String toString()
/*      */     {
/* 2327 */       return "DeliveryRecord " + System.identityHashCode(this) + " del: " + this.del + " queueName: " + this.queueName;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.endpoint.ServerSessionEndpoint
 * JD-Core Version:    0.6.0
 */