/*     */ package org.jboss.jms.server.endpoint;
/*     */ 
/*     */ import javax.jms.IllegalStateException;
/*     */ import javax.jms.InvalidSelectorException;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.jms.delegate.ConsumerEndpoint;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.server.DestinationManager;
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.jms.server.destination.ManagedDestination;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounter;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounterManager;
/*     */ import org.jboss.jms.server.selector.Selector;
/*     */ import org.jboss.jms.wireformat.Dispatcher;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Binding;
/*     */ import org.jboss.messaging.core.contract.Delivery;
/*     */ import org.jboss.messaging.core.contract.DeliveryObserver;
/*     */ import org.jboss.messaging.core.contract.Distributor;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ import org.jboss.messaging.core.contract.MessageReference;
/*     */ import org.jboss.messaging.core.contract.PostOffice;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ import org.jboss.messaging.core.contract.Receiver;
/*     */ import org.jboss.messaging.core.contract.Replicator;
/*     */ import org.jboss.messaging.core.impl.SimpleDelivery;
/*     */ import org.jboss.messaging.core.impl.tx.Transaction;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ 
/*     */ public class ServerConsumerEndpoint
/*     */   implements Receiver, ConsumerEndpoint
/*     */ {
/*  62 */   private static final Logger log = Logger.getLogger(ServerConsumerEndpoint.class);
/*     */ 
/*  68 */   private boolean trace = log.isTraceEnabled();
/*     */   private String id;
/*     */   private Queue messageQueue;
/*     */   private String queueName;
/*     */   private ServerSessionEndpoint sessionEndpoint;
/*     */   private boolean noLocal;
/*     */   private Selector messageSelector;
/*     */   private JBossDestination destination;
/*     */   private Queue dlq;
/*     */   private Queue expiryQueue;
/*     */   private long redeliveryDelay;
/*     */   private int maxDeliveryAttempts;
/*     */   private boolean started;
/*     */   private Object startStopLock;
/*     */   private volatile boolean clientAccepting;
/*     */   private boolean retainDeliveries;
/* 102 */   private long lastDeliveryID = -1L;
/*     */   private boolean remote;
/*     */   private boolean preserveOrdering;
/*     */   private boolean replicating;
/*     */   private boolean slow;
/*     */   private volatile boolean dead;
/*     */ 
/*     */   ServerConsumerEndpoint(String id, Queue messageQueue, String queueName, ServerSessionEndpoint sessionEndpoint, String selector, boolean noLocal, JBossDestination dest, Queue dlq, Queue expiryQueue, long redeliveryDelay, int maxDeliveryAttempts, boolean remote, boolean replicating)
/*     */     throws InvalidSelectorException
/*     */   {
/* 122 */     if (this.trace)
/*     */     {
/* 124 */       log.trace("constructing consumer endpoint " + id);
/*     */     }
/*     */ 
/* 127 */     this.id = id;
/*     */ 
/* 129 */     this.messageQueue = messageQueue;
/*     */ 
/* 131 */     this.queueName = queueName;
/*     */ 
/* 133 */     this.sessionEndpoint = sessionEndpoint;
/*     */ 
/* 135 */     this.noLocal = noLocal;
/*     */ 
/* 137 */     this.destination = dest;
/*     */ 
/* 139 */     this.dlq = dlq;
/*     */ 
/* 141 */     this.redeliveryDelay = redeliveryDelay;
/*     */ 
/* 143 */     this.expiryQueue = expiryQueue;
/*     */ 
/* 145 */     this.maxDeliveryAttempts = maxDeliveryAttempts;
/*     */ 
/* 148 */     this.clientAccepting = false;
/*     */ 
/* 150 */     this.remote = remote;
/*     */ 
/* 152 */     this.startStopLock = new Object();
/*     */ 
/* 154 */     this.preserveOrdering = sessionEndpoint.getConnectionEndpoint().getServerPeer().isDefaultPreserveOrdering();
/*     */ 
/* 156 */     this.replicating = replicating;
/*     */ 
/* 158 */     this.slow = sessionEndpoint.getConnectionEndpoint().getConnectionFactoryEndpoint().isSlowConsumers();
/*     */ 
/* 160 */     if ((dest.isTopic()) && (!messageQueue.isRecoverable()))
/*     */     {
/* 164 */       this.retainDeliveries = false;
/*     */     }
/*     */     else
/*     */     {
/* 168 */       this.retainDeliveries = true;
/*     */     }
/*     */ 
/* 171 */     if (selector != null)
/*     */     {
/* 173 */       if (this.trace) log.trace("creating selector:" + selector);
/*     */ 
/* 175 */       this.messageSelector = new Selector(selector);
/* 176 */       if (this.trace) log.trace("created selector");
/*     */     }
/*     */ 
/* 179 */     this.started = this.sessionEndpoint.getConnectionEndpoint().isStarted();
/*     */ 
/* 182 */     if (remote)
/*     */     {
/* 184 */       this.messageQueue.getRemoteDistributor().add(this);
/*     */     }
/*     */     else
/*     */     {
/* 188 */       this.messageQueue.getLocalDistributor().add(this);
/*     */     }
/*     */ 
/* 193 */     log.trace(this + " constructed");
/*     */   }
/*     */ 
/*     */   public Delivery handle(DeliveryObserver observer, MessageReference ref, Transaction tx)
/*     */   {
/* 204 */     if (this.trace)
/*     */     {
/* 206 */       log.trace(this + " receives " + ref + " for delivery");
/*     */     }
/*     */ 
/* 210 */     if (!this.clientAccepting)
/*     */     {
/* 212 */       if (this.trace) log.trace(this + "'s client is NOT accepting messages!");
/*     */ 
/* 214 */       return null;
/*     */     }
/*     */ 
/* 217 */     if (ref.getMessage().isExpired())
/*     */     {
/* 219 */       SimpleDelivery delivery = new SimpleDelivery(observer, ref, true, false);
/*     */       try
/*     */       {
/* 223 */         this.sessionEndpoint.expireDelivery(delivery, this.expiryQueue);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 227 */         log.error("Failed to expire delivery: " + delivery, t);
/*     */       }
/*     */ 
/* 230 */       return delivery;
/*     */     }
/*     */ 
/* 233 */     if ((this.preserveOrdering) && (this.remote))
/*     */     {
/* 237 */       if (ref.getMessage().getHeader("CLUSTER_SUCKED") != null)
/*     */       {
/* 239 */         if (this.trace) log.trace("Message has already been sucked once - not sucking again");
/*     */ 
/* 241 */         return null;
/*     */       }
/*     */     }
/*     */ 
/* 245 */     synchronized (this.startStopLock)
/*     */     {
/* 249 */       if (!this.started)
/*     */       {
/* 251 */         if (this.trace) log.trace(this + " NOT started!");
/*     */ 
/* 253 */         return null;
/*     */       }
/*     */ 
/* 256 */       if (this.trace) log.trace(this + " has startStopLock lock, preparing the message for delivery");
/*     */ 
/* 258 */       Message message = ref.getMessage();
/*     */ 
/* 260 */       boolean selectorRejected = !accept(message);
/*     */ 
/* 262 */       SimpleDelivery delivery = new SimpleDelivery(observer, ref, !selectorRejected, false);
/*     */ 
/* 264 */       if (selectorRejected)
/*     */       {
/* 266 */         return delivery;
/*     */       }
/*     */ 
/* 269 */       if (this.noLocal)
/*     */       {
/* 271 */         String conId = ((JBossMessage)message).getConnectionID();
/*     */ 
/* 273 */         if (this.trace) log.trace("message connection id: " + conId + " current connection connection id: " + this.sessionEndpoint.getConnectionEndpoint().getConnectionID());
/*     */ 
/* 275 */         if (this.sessionEndpoint.getConnectionEndpoint().getConnectionID().equals(conId))
/*     */         {
/* 277 */           if (this.trace) log.trace("Message from local connection so rejecting");
/*     */ 
/*     */           try
/*     */           {
/* 281 */             delivery.acknowledge(null);
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 285 */             log.error("Failed to acknowledge delivery", t);
/*     */ 
/* 287 */             return null;
/*     */           }
/*     */ 
/* 290 */           return delivery;
/*     */         }
/*     */       }
/*     */ 
/* 294 */       if (this.slow)
/*     */       {
/* 302 */         this.clientAccepting = false;
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 307 */         this.sessionEndpoint.handleDelivery(delivery, this);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 311 */         log.error("Failed to handle delivery", e);
/*     */ 
/* 313 */         this.started = false;
/*     */       }
/*     */ 
/* 316 */       return delivery;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean accept(Message msg)
/*     */   {
/* 324 */     boolean accept = true;
/*     */ 
/* 326 */     if (this.destination.isQueue())
/*     */     {
/* 330 */       if (this.messageSelector != null)
/*     */       {
/* 332 */         accept = this.messageSelector.accept(msg);
/*     */ 
/* 334 */         if (this.trace) log.trace("message selector " + (accept ? "accepts " : "DOES NOT accept ") + "the message");
/*     */       }
/*     */     }
/*     */ 
/* 338 */     return accept;
/*     */   }
/*     */ 
/*     */   public long closing(long sequence)
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 347 */       if (this.trace) log.trace(this + " closing");
/*     */ 
/* 349 */       stop();
/*     */ 
/* 351 */       return this.lastDeliveryID;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 355 */     throw ExceptionUtil.handleJMSInvocation(t, this + " closing");
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 363 */       if (this.trace)
/*     */       {
/* 365 */         log.trace(this + " close");
/*     */       }
/*     */ 
/* 368 */       localClose();
/*     */ 
/* 370 */       this.sessionEndpoint.removeConsumer(this.id);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 374 */       throw ExceptionUtil.handleJMSInvocation(t, this + " close");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void changeRate(float newRate)
/*     */     throws JMSException
/*     */   {
/* 382 */     if (this.trace)
/*     */     {
/* 384 */       log.trace(this + " changing rate to " + newRate);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 402 */       if (newRate > 0.0F)
/*     */       {
/* 404 */         this.clientAccepting = true;
/*     */       }
/*     */       else
/*     */       {
/* 408 */         this.clientAccepting = false;
/*     */       }
/*     */ 
/* 411 */       if (this.clientAccepting)
/*     */       {
/* 413 */         promptDelivery();
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 418 */       throw ExceptionUtil.handleJMSInvocation(t, this + " changeRate");
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 426 */     return "ConsumerEndpoint[" + this.id + "]";
/*     */   }
/*     */ 
/*     */   public JBossDestination getDestination()
/*     */   {
/* 431 */     return this.destination;
/*     */   }
/*     */ 
/*     */   public ServerSessionEndpoint getSessionEndpoint()
/*     */   {
/* 436 */     return this.sessionEndpoint;
/*     */   }
/*     */ 
/*     */   boolean isReplicating()
/*     */   {
/* 443 */     return this.replicating;
/*     */   }
/*     */ 
/*     */   String getID()
/*     */   {
/* 448 */     return this.id;
/*     */   }
/*     */ 
/*     */   boolean isRetainDeliveries()
/*     */   {
/* 453 */     return this.retainDeliveries;
/*     */   }
/*     */ 
/*     */   void setLastDeliveryID(long id)
/*     */   {
/* 458 */     this.lastDeliveryID = id;
/*     */   }
/*     */ 
/*     */   void setStarted(boolean started)
/*     */   {
/* 464 */     this.started = started;
/*     */   }
/*     */ 
/*     */   void setDead()
/*     */   {
/* 469 */     this.dead = true;
/*     */   }
/*     */ 
/*     */   boolean isDead()
/*     */   {
/* 474 */     return this.dead;
/*     */   }
/*     */ 
/*     */   Queue getDLQ()
/*     */   {
/* 479 */     return this.dlq;
/*     */   }
/*     */ 
/*     */   Queue getExpiryQueue()
/*     */   {
/* 484 */     return this.expiryQueue;
/*     */   }
/*     */ 
/*     */   long getRedliveryDelay()
/*     */   {
/* 489 */     return this.redeliveryDelay;
/*     */   }
/*     */ 
/*     */   int getMaxDeliveryAttempts()
/*     */   {
/* 494 */     return this.maxDeliveryAttempts;
/*     */   }
/*     */ 
/*     */   String getQueueName()
/*     */   {
/* 499 */     return this.queueName;
/*     */   }
/*     */ 
/*     */   void localClose() throws Throwable
/*     */   {
/* 504 */     if (this.trace) log.trace(this + " grabbed the main lock in close() " + this);
/*     */ 
/* 506 */     if (this.remote)
/*     */     {
/* 508 */       this.messageQueue.getRemoteDistributor().remove(this);
/*     */     }
/*     */     else
/*     */     {
/* 512 */       this.messageQueue.getLocalDistributor().remove(this);
/*     */     }
/*     */ 
/* 515 */     Dispatcher.instance.unregisterTarget(this.id, this);
/*     */ 
/* 520 */     if (this.destination.isTopic())
/*     */     {
/* 522 */       PostOffice postOffice = this.sessionEndpoint.getConnectionEndpoint().getServerPeer().getPostOfficeInstance();
/*     */ 
/* 524 */       ServerPeer sp = this.sessionEndpoint.getConnectionEndpoint().getServerPeer();
/*     */ 
/* 526 */       Queue queue = postOffice.getBindingForQueueName(this.queueName).queue;
/*     */ 
/* 528 */       ManagedDestination mDest = sp.getDestinationManager().getDestination(this.destination.getName(), false);
/*     */ 
/* 530 */       if (!queue.isRecoverable())
/*     */       {
/* 532 */         postOffice.removeBinding(this.queueName, false);
/*     */ 
/* 534 */         if (!mDest.isTemporary())
/*     */         {
/* 536 */           String counterName = "Subscription." + this.queueName;
/*     */ 
/* 538 */           MessageCounter counter = sp.getMessageCounterManager().unregisterMessageCounter(counterName);
/*     */ 
/* 540 */           if (counter == null)
/*     */           {
/* 542 */             throw new IllegalStateException("Cannot find counter to remove " + counterName);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/* 550 */       else if ((queue.isClustered()) && (postOffice.isClustered()))
/*     */       {
/* 554 */         Replicator rep = (Replicator)postOffice;
/*     */ 
/* 556 */         rep.remove(queue.getName());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void start()
/*     */   {
/* 565 */     synchronized (this.startStopLock)
/*     */     {
/* 567 */       if (this.started)
/*     */       {
/* 569 */         return;
/*     */       }
/*     */ 
/* 572 */       this.started = true;
/*     */     }
/*     */ 
/* 576 */     promptDelivery();
/*     */   }
/*     */ 
/*     */   void stop() throws Throwable
/*     */   {
/* 581 */     synchronized (this.startStopLock)
/*     */     {
/* 583 */       if (!this.started)
/*     */       {
/* 585 */         return;
/*     */       }
/*     */ 
/* 588 */       this.started = false;
/*     */     }
/*     */ 
/* 619 */     if (this.replicating)
/*     */     {
/* 621 */       this.sessionEndpoint.waitForDeliveriesFromConsumer(this.id);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void promptDelivery()
/*     */   {
/* 631 */     this.sessionEndpoint.promptDelivery(this.messageQueue);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.endpoint.ServerConsumerEndpoint
 * JD-Core Version:    0.6.0
 */