/*     */ package org.jboss.jms.server.endpoint;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.IllegalStateException;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.jms.client.delegate.ClientSessionDelegate;
/*     */ import org.jboss.jms.delegate.ConnectionEndpoint;
/*     */ import org.jboss.jms.delegate.IDBlock;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.server.ConnectionManager;
/*     */ import org.jboss.jms.server.JMSCondition;
/*     */ import org.jboss.jms.server.SecurityStore;
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.jms.server.endpoint.advised.SessionAdvised;
/*     */ import org.jboss.jms.tx.ClientTransaction;
/*     */ import org.jboss.jms.tx.ClientTransaction.SessionTxState;
/*     */ import org.jboss.jms.tx.MessagingXid;
/*     */ import org.jboss.jms.tx.TransactionRequest;
/*     */ import org.jboss.jms.wireformat.Dispatcher;
/*     */ import org.jboss.jms.wireformat.JMSWireFormat;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Binding;
/*     */ import org.jboss.messaging.core.contract.Delivery;
/*     */ import org.jboss.messaging.core.contract.MessageReference;
/*     */ import org.jboss.messaging.core.contract.MessageStore;
/*     */ import org.jboss.messaging.core.contract.PersistenceManager;
/*     */ import org.jboss.messaging.core.contract.PostOffice;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ import org.jboss.messaging.core.impl.IDManager;
/*     */ import org.jboss.messaging.core.impl.tx.Transaction;
/*     */ import org.jboss.messaging.core.impl.tx.TransactionRepository;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ import org.jboss.messaging.util.GUIDGenerator;
/*     */ import org.jboss.messaging.util.Util;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
/*     */ 
/*     */ public class ServerConnectionEndpoint
/*     */   implements ConnectionEndpoint
/*     */ {
/*  85 */   private static final Logger log = Logger.getLogger(ServerConnectionEndpoint.class);
/*     */ 
/*  89 */   private static boolean trace = log.isTraceEnabled();
/*     */   private String id;
/*     */   private volatile boolean closed;
/*     */   private volatile boolean started;
/*     */   private String clientID;
/*     */   private String username;
/*     */   private String password;
/*     */   private String remotingClientSessionID;
/*     */   private String jmsClientVMID;
/*     */   private ServerPeer serverPeer;
/*     */   private PostOffice postOffice;
/*     */   private SecurityStore sm;
/*     */   private ConnectionManager cm;
/*     */   private TransactionRepository tr;
/*     */   private MessageStore ms;
/*     */   private ServerInvokerCallbackHandler callbackHandler;
/*     */   private Map sessions;
/*     */   private Set temporaryDestinations;
/*     */   private int prefetchSize;
/*     */   private int defaultTempQueueFullSize;
/*     */   private int defaultTempQueuePageSize;
/*     */   private int defaultTempQueueDownCacheSize;
/*     */   private int dupsOKBatchSize;
/*     */   private ServerConnectionFactoryEndpoint cfendpoint;
/*     */   private byte usingVersion;
/*     */   private Integer failedNodeID;
/*     */ 
/*     */   public ServerConnectionEndpoint(ServerPeer serverPeer, String clientID, String username, String password, int prefetchSize, int defaultTempQueueFullSize, int defaultTempQueuePageSize, int defaultTempQueueDownCacheSize, int failedNodeID, ServerConnectionFactoryEndpoint cfendpoint, String remotingSessionID, String clientVMID, byte versionToUse, ServerInvokerCallbackHandler callbackHandler, int dupsOKBatchSize)
/*     */     throws Exception
/*     */   {
/* 154 */     this.serverPeer = serverPeer;
/*     */ 
/* 156 */     this.cfendpoint = cfendpoint;
/*     */ 
/* 158 */     this.sm = serverPeer.getSecurityManager();
/* 159 */     this.tr = serverPeer.getTxRepository();
/* 160 */     this.cm = serverPeer.getConnectionManager();
/* 161 */     this.ms = serverPeer.getMessageStore();
/* 162 */     this.postOffice = serverPeer.getPostOfficeInstance();
/*     */ 
/* 164 */     this.started = false;
/*     */ 
/* 166 */     this.id = GUIDGenerator.generateGUID();
/* 167 */     this.clientID = clientID;
/* 168 */     this.prefetchSize = prefetchSize;
/*     */ 
/* 170 */     this.defaultTempQueueFullSize = defaultTempQueueFullSize;
/* 171 */     this.defaultTempQueuePageSize = defaultTempQueuePageSize;
/* 172 */     this.defaultTempQueueDownCacheSize = defaultTempQueueDownCacheSize;
/*     */ 
/* 174 */     this.dupsOKBatchSize = dupsOKBatchSize;
/*     */ 
/* 176 */     this.sessions = new HashMap();
/* 177 */     this.temporaryDestinations = new HashSet();
/*     */ 
/* 179 */     this.username = username;
/* 180 */     this.password = password;
/*     */ 
/* 182 */     if (failedNodeID > 0)
/*     */     {
/* 184 */       this.failedNodeID = new Integer(failedNodeID);
/*     */     }
/*     */ 
/* 187 */     this.remotingClientSessionID = remotingSessionID;
/*     */ 
/* 189 */     this.jmsClientVMID = clientVMID;
/* 190 */     this.usingVersion = versionToUse;
/*     */ 
/* 192 */     this.serverPeer.getConnectionManager().registerConnection(this.jmsClientVMID, this.remotingClientSessionID, this);
/*     */ 
/* 195 */     this.callbackHandler = callbackHandler;
/*     */ 
/* 197 */     Client callbackClient = callbackHandler.getCallbackClient();
/*     */ 
/* 199 */     if (callbackClient != null)
/*     */     {
/* 204 */       callbackClient.setSubsystem("CALLBACK");
/*     */ 
/* 211 */       callbackClient.setMarshaller(new JMSWireFormat());
/* 212 */       callbackClient.setUnMarshaller(new JMSWireFormat());
/*     */     }
/*     */     else
/*     */     {
/* 216 */       log.trace("ServerInvokerCallbackHandler callback Client is not available: must be using pull callbacks");
/*     */     }
/*     */   }
/*     */ 
/*     */   public SessionDelegate createSessionDelegate(boolean transacted, int acknowledgmentMode, boolean isXA)
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 230 */       log.trace(this + " creating " + (transacted ? "transacted" : "non transacted") + " session, " + Util.acknowledgmentMode(acknowledgmentMode) + ", " + (isXA ? "XA" : "non XA"));
/*     */ 
/* 234 */       if (this.closed)
/*     */       {
/* 236 */         throw new IllegalStateException("Connection is closed");
/*     */       }
/*     */ 
/* 239 */       String sessionID = GUIDGenerator.generateGUID();
/*     */ 
/* 245 */       ServerSessionEndpoint ep = new ServerSessionEndpoint(sessionID, this, (transacted) || (acknowledgmentMode == 2));
/*     */ 
/* 248 */       synchronized (this.sessions)
/*     */       {
/* 250 */         this.sessions.put(sessionID, ep);
/*     */       }
/*     */       SessionAdvised advised;
/* 257 */       synchronized (AspectManager.instance())
/*     */       {
/* 259 */         advised = new SessionAdvised(ep);
/*     */       }
/*     */ 
/* 262 */       SessionAdvised sessionAdvised = advised;
/*     */ 
/* 264 */       this.serverPeer.addSession(sessionID, ep);
/*     */ 
/* 266 */       Dispatcher.instance.registerTarget(sessionID, sessionAdvised);
/*     */ 
/* 268 */       log.trace("created and registered " + ep);
/*     */ 
/* 270 */       ClientSessionDelegate d = new ClientSessionDelegate(sessionID, this.dupsOKBatchSize);
/*     */ 
/* 272 */       log.trace("created " + d);
/*     */ 
/* 274 */       return d;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 278 */     throw ExceptionUtil.handleJMSInvocation(t, this + " createSessionDelegate");
/*     */   }
/*     */ 
/*     */   public String getClientID()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 286 */       if (this.closed)
/*     */       {
/* 288 */         throw new IllegalStateException("Connection is closed");
/*     */       }
/* 290 */       return this.clientID;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 294 */     throw ExceptionUtil.handleJMSInvocation(t, this + " getClientID");
/*     */   }
/*     */ 
/*     */   public void setClientID(String clientID)
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 302 */       if (this.closed)
/*     */       {
/* 304 */         throw new IllegalStateException("Connection is closed");
/*     */       }
/*     */ 
/* 307 */       if (this.clientID != null)
/*     */       {
/* 309 */         throw new IllegalStateException("Cannot set clientID, already set as " + this.clientID);
/*     */       }
/*     */ 
/* 312 */       log.trace(this + "setting client ID to " + clientID);
/*     */ 
/* 314 */       this.clientID = clientID;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 318 */       throw ExceptionUtil.handleJMSInvocation(t, this + " setClientID");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start() throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 326 */       if (this.closed)
/*     */       {
/* 328 */         throw new IllegalStateException("Connection is closed");
/*     */       }
/* 330 */       setStarted(true);
/* 331 */       log.trace(this + " started");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 335 */       throw ExceptionUtil.handleJMSInvocation(t, this + " start");
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void stop() throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 343 */       if (this.closed)
/*     */       {
/* 345 */         throw new IllegalStateException("Connection is closed");
/*     */       }
/*     */ 
/* 348 */       setStarted(false);
/*     */ 
/* 350 */       log.trace("Connection " + this.id + " stopped");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 354 */       throw ExceptionUtil.handleJMSInvocation(t, this + " stop");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void close() throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 362 */       if (trace) log.trace(this + " close()");
/*     */ 
/* 364 */       if (this.closed)
/*     */       {
/* 366 */         log.warn("Connection is already closed");
/* 367 */         return;
/*     */       }
/*     */       Map sessionsClone;
/* 372 */       synchronized (this.sessions)
/*     */       {
/* 374 */         sessionsClone = new HashMap(this.sessions);
/*     */       }
/*     */ 
/* 377 */       for (Iterator i = sessionsClone.values().iterator(); i.hasNext(); )
/*     */       {
/* 379 */         ServerSessionEndpoint sess = (ServerSessionEndpoint)i.next();
/*     */ 
/* 381 */         sess.localClose();
/*     */       }
/*     */ 
/* 384 */       this.sessions.clear();
/*     */ 
/* 386 */       synchronized (this.temporaryDestinations)
/*     */       {
/* 388 */         for (Iterator i = this.temporaryDestinations.iterator(); i.hasNext(); )
/*     */         {
/* 390 */           JBossDestination dest = (JBossDestination)i.next();
/*     */ 
/* 392 */           if (dest.isQueue())
/*     */           {
/* 396 */             this.postOffice.removeBinding(dest.getName(), this.postOffice.isClustered());
/*     */           }
/*     */           else
/*     */           {
/* 407 */             Collection queues = this.serverPeer.getPostOfficeInstance().getQueuesForCondition(new JMSCondition(false, dest.getName()), true);
/*     */ 
/* 409 */             if (!queues.isEmpty())
/*     */             {
/* 412 */               throw new IllegalStateException("Cannot delete temporary destination if it has consumer(s)");
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/* 417 */         this.temporaryDestinations.clear();
/*     */       }
/*     */ 
/* 420 */       this.cm.unregisterConnection(this.jmsClientVMID, this.remotingClientSessionID);
/*     */ 
/* 422 */       Dispatcher.instance.unregisterTarget(this.id, this);
/*     */ 
/* 424 */       this.closed = true;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 428 */       throw ExceptionUtil.handleJMSInvocation(t, this + " close");
/*     */     }
/*     */   }
/*     */ 
/*     */   public long closing(long sequence) throws JMSException
/*     */   {
/* 434 */     log.trace(this + " closing (noop)");
/*     */ 
/* 436 */     return -1L;
/*     */   }
/*     */ 
/*     */   public void sendTransaction(TransactionRequest request, boolean checkForDuplicates)
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 444 */       if (this.closed)
/*     */       {
/* 446 */         throw new IllegalStateException("Connection is closed");
/*     */       }
/*     */ 
/* 449 */       if (request.getRequestType() == 0)
/*     */       {
/* 451 */         if (trace) log.trace(this + " received ONE_PHASE_COMMIT request");
/*     */ 
/* 453 */         Transaction tx = this.tr.createTransaction();
/* 454 */         processTransaction(request.getState(), tx, checkForDuplicates);
/* 455 */         tx.commit();
/*     */       }
/* 457 */       else if (request.getRequestType() == 2)
/*     */       {
/* 459 */         if (trace) log.trace(this + " received TWO_PHASE_COMMIT prepare request");
/*     */ 
/* 461 */         Transaction tx = this.tr.createTransaction(request.getXid());
/* 462 */         processTransaction(request.getState(), tx, checkForDuplicates);
/* 463 */         tx.prepare();
/*     */       }
/* 465 */       else if (request.getRequestType() == 3)
/*     */       {
/* 467 */         if (trace) log.trace(this + " received TWO_PHASE_COMMIT commit request");
/*     */ 
/* 469 */         Transaction tx = this.tr.getPreparedTx(request.getXid());
/* 470 */         if (trace) log.trace("Committing " + tx);
/* 471 */         tx.commit();
/*     */       }
/* 473 */       else if (request.getRequestType() == 4)
/*     */       {
/* 475 */         if (trace) log.trace(this + " received TWO_PHASE_COMMIT rollback request");
/*     */ 
/* 480 */         Transaction tx = this.tr.getPreparedTx(request.getXid());
/*     */ 
/* 482 */         if (trace) log.trace(this + " rolling back " + tx);
/*     */ 
/* 484 */         tx.rollback();
/*     */       }
/*     */ 
/* 487 */       if (trace) log.trace(this + " processed transaction successfully");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 491 */       throw ExceptionUtil.handleJMSInvocation(t, this + " sendTransaction");
/*     */     }
/*     */   }
/*     */ 
/*     */   public MessagingXid[] getPreparedTransactions()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 504 */       List xids = this.tr.recoverPreparedTransactions();
/*     */ 
/* 506 */       return (MessagingXid[])(MessagingXid[])xids.toArray(new MessagingXid[xids.size()]);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 510 */     throw ExceptionUtil.handleJMSInvocation(t, this + " getPreparedTransactions");
/*     */   }
/*     */ 
/*     */   public IDBlock getIdBlock(int size)
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 518 */       return this.serverPeer.getMessageIDManager().getIDBlock(size);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 522 */     throw ExceptionUtil.handleJMSInvocation(t, this + " getIdBlock");
/*     */   }
/*     */ 
/*     */   public String getUsername()
/*     */   {
/* 530 */     return this.username;
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/* 535 */     return this.password;
/*     */   }
/*     */ 
/*     */   public SecurityStore getSecurityManager()
/*     */   {
/* 540 */     return this.sm;
/*     */   }
/*     */ 
/*     */   public ServerInvokerCallbackHandler getCallbackHandler()
/*     */   {
/* 545 */     return this.callbackHandler;
/*     */   }
/*     */ 
/*     */   public ServerPeer getServerPeer()
/*     */   {
/* 550 */     return this.serverPeer;
/*     */   }
/*     */ 
/*     */   public ServerConnectionFactoryEndpoint getConnectionFactoryEndpoint()
/*     */   {
/* 555 */     return this.cfendpoint;
/*     */   }
/*     */ 
/*     */   public Collection getSessions()
/*     */   {
/* 560 */     ArrayList list = new ArrayList();
/* 561 */     synchronized (this.sessions)
/*     */     {
/* 563 */       list.addAll(this.sessions.values());
/*     */     }
/* 565 */     return list;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 570 */     return "ConnectionEndpoint[" + this.id + "]";
/*     */   }
/*     */ 
/*     */   byte getUsingVersion()
/*     */   {
/* 577 */     return this.usingVersion;
/*     */   }
/*     */ 
/*     */   int getPrefetchSize()
/*     */   {
/* 582 */     return this.prefetchSize;
/*     */   }
/*     */ 
/*     */   int getDefaultTempQueueFullSize()
/*     */   {
/* 587 */     return this.defaultTempQueueFullSize;
/*     */   }
/*     */ 
/*     */   int getDefaultTempQueuePageSize()
/*     */   {
/* 592 */     return this.defaultTempQueuePageSize;
/*     */   }
/*     */ 
/*     */   int getDefaultTempQueueDownCacheSize()
/*     */   {
/* 597 */     return this.defaultTempQueueDownCacheSize;
/*     */   }
/*     */ 
/*     */   String getConnectionID()
/*     */   {
/* 602 */     return this.id;
/*     */   }
/*     */ 
/*     */   boolean isStarted()
/*     */   {
/* 607 */     return this.started;
/*     */   }
/*     */ 
/*     */   void removeSession(String sessionId) throws Exception
/*     */   {
/* 612 */     synchronized (this.sessions)
/*     */     {
/* 614 */       if (this.sessions.remove(sessionId) == null)
/*     */       {
/* 616 */         throw new IllegalStateException("Cannot find session with id " + sessionId + " to remove");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void addTemporaryDestination(Destination dest)
/*     */   {
/* 623 */     synchronized (this.temporaryDestinations)
/*     */     {
/* 625 */       this.temporaryDestinations.add(dest);
/*     */     }
/*     */   }
/*     */ 
/*     */   void removeTemporaryDestination(Destination dest)
/*     */   {
/* 631 */     synchronized (this.temporaryDestinations)
/*     */     {
/* 633 */       this.temporaryDestinations.remove(dest);
/*     */     }
/*     */   }
/*     */ 
/*     */   boolean hasTemporaryDestination(Destination dest)
/*     */   {
/* 639 */     synchronized (this.temporaryDestinations)
/*     */     {
/* 641 */       return this.temporaryDestinations.contains(dest);
/*     */     }
/*     */   }
/*     */ 
/*     */   String getRemotingClientSessionID()
/*     */   {
/* 647 */     return this.remotingClientSessionID;
/*     */   }
/*     */ 
/*     */   void sendMessage(JBossMessage msg, Transaction tx, boolean checkForDuplicates) throws Exception
/*     */   {
/* 652 */     if (trace) log.trace(this + " sending message " + msg + (tx == null ? " non-transactionally" : new StringBuilder().append(" in ").append(tx).toString()));
/*     */ 
/* 654 */     if (checkForDuplicates)
/*     */     {
/* 656 */       if (msg.isReliable())
/*     */       {
/* 658 */         if (this.serverPeer.getPersistenceManagerInstance().referenceExists(msg.getMessageID()))
/*     */         {
/* 661 */           if (trace) log.trace("Duplicate of " + msg + " exists in database - probably sent before failover");
/*     */ 
/* 663 */           return;
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 669 */         if (trace) log.trace("Rejecting NP message " + msg + " after failover");
/*     */ 
/* 671 */         return;
/*     */       }
/*     */     }
/*     */ 
/* 675 */     JBossDestination dest = (JBossDestination)msg.getJMSDestination();
/*     */ 
/* 681 */     msg.setConnectionID(this.id);
/*     */ 
/* 689 */     MessageReference ref = msg.createReference();
/*     */ 
/* 691 */     long schedDeliveryTime = msg.getScheduledDeliveryTime();
/*     */ 
/* 693 */     if (schedDeliveryTime > 0L)
/*     */     {
/* 695 */       ref.setScheduledDeliveryTime(schedDeliveryTime);
/*     */     }
/*     */ 
/* 698 */     if (dest.isDirect())
/*     */     {
/* 702 */       Binding binding = this.postOffice.getBindingForQueueName(dest.getName());
/*     */ 
/* 704 */       if (binding == null)
/*     */       {
/* 706 */         throw new IllegalArgumentException("Cannot find binding for queue " + dest.getName());
/*     */       }
/*     */ 
/* 709 */       Queue queue = binding.queue;
/*     */ 
/* 711 */       Delivery del = queue.handle(null, ref, tx);
/*     */ 
/* 713 */       if (del == null)
/*     */       {
/* 715 */         throw new JMSException("Failed to route " + ref + " to " + dest.getName());
/*     */       }
/*     */     }
/* 718 */     else if (dest.isQueue())
/*     */     {
/* 720 */       if (!this.postOffice.route(ref, new JMSCondition(true, dest.getName()), tx))
/*     */       {
/* 722 */         throw new JMSException("Failed to route " + ref + " to " + dest.getName());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 727 */       this.postOffice.route(ref, new JMSCondition(false, dest.getName()), tx);
/*     */     }
/*     */ 
/* 730 */     if (trace) log.trace("sent " + msg);
/*     */   }
/*     */ 
/*     */   Integer getFailedNodeID()
/*     */   {
/* 741 */     return this.failedNodeID;
/*     */   }
/*     */ 
/*     */   boolean isFailoverConnection()
/*     */   {
/* 750 */     return this.failedNodeID != null;
/*     */   }
/*     */ 
/*     */   private void setStarted(boolean s)
/*     */     throws Throwable
/*     */   {
/* 758 */     Map sessionsClone = null;
/*     */ 
/* 760 */     synchronized (this.sessions)
/*     */     {
/* 762 */       sessionsClone = new HashMap(this.sessions);
/*     */     }
/*     */ 
/* 765 */     for (Iterator i = sessionsClone.values().iterator(); i.hasNext(); )
/*     */     {
/* 767 */       ServerSessionEndpoint sd = (ServerSessionEndpoint)i.next();
/*     */ 
/* 769 */       sd.setStarted(s);
/*     */     }
/* 771 */     this.started = s;
/*     */   }
/*     */ 
/*     */   private void processTransaction(ClientTransaction txState, Transaction tx, boolean checkForDuplicates)
/*     */     throws Throwable
/*     */   {
/* 777 */     if (trace) log.trace(this + " processing transaction " + tx);
/*     */ 
/* 779 */     for (Iterator i = txState.getSessionStates().iterator(); i.hasNext(); )
/*     */     {
/* 781 */       ClientTransaction.SessionTxState sessionState = (ClientTransaction.SessionTxState)i.next();
/*     */ 
/* 785 */       for (Iterator j = sessionState.getMsgs().iterator(); j.hasNext(); )
/*     */       {
/* 787 */         JBossMessage message = (JBossMessage)j.next();
/*     */ 
/* 789 */         sendMessage(message, tx, checkForDuplicates);
/*     */       }
/*     */ 
/* 799 */       ServerSessionEndpoint session = this.serverPeer.getSession(sessionState.getSessionId());
/*     */ 
/* 801 */       if (session == null)
/*     */       {
/* 803 */         throw new IllegalStateException("Cannot find session with id " + sessionState.getSessionId());
/*     */       }
/*     */ 
/* 807 */       session.acknowledgeTransactionally(sessionState.getAcks(), tx);
/*     */     }
/*     */ 
/* 810 */     if (trace) log.trace(this + " processed transaction " + tx);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.endpoint.ServerConnectionEndpoint
 * JD-Core Version:    0.6.0
 */