/*     */ package org.jboss.jms.server.endpoint;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   static void pushSubjectContext(Principal principal, Object credential, Subject subject)
/*     */   {
/* 112 */     if (System.getSecurityManager() == null)
/*     */     {
/* 114 */       PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
/*     */     }
/*     */     else
/*     */     {
/* 118 */       PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
/*     */     }
/*     */   }
/*     */ 
/*     */   static void popSubjectContext()
/*     */   {
/* 124 */     if (System.getSecurityManager() == null)
/*     */     {
/* 126 */       PrincipalInfoAction.NON_PRIVILEGED.pop();
/*     */     }
/*     */     else
/*     */     {
/* 130 */       PrincipalInfoAction.PRIVILEGED.pop();
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface PrincipalInfoAction
/*     */   {
/*  44 */     public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction()
/*     */     {
/*     */       public void push(Principal principal, Object credential, Subject subject)
/*     */       {
/*  49 */         AccessController.doPrivileged(new PrivilegedAction(subject, principal, credential)
/*     */         {
/*     */           public Object run()
/*     */           {
/*  54 */             SecurityAssociation.pushSubjectContext(this.val$subject, this.val$principal, this.val$credential);
/*  55 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void dup() {
/*  62 */         AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/*  67 */             SecurityAssociation.dupSubjectContext();
/*  68 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void pop() {
/*  75 */         AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/*  80 */             SecurityAssociation.popSubjectContext();
/*  81 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*  44 */     };
/*     */ 
/*  88 */     public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction()
/*     */     {
/*     */       public void push(Principal principal, Object credential, Subject subject)
/*     */       {
/*  92 */         SecurityAssociation.pushSubjectContext(subject, principal, credential);
/*     */       }
/*     */ 
/*     */       public void dup() {
/*  96 */         SecurityAssociation.dupSubjectContext();
/*     */       }
/*     */ 
/*     */       public void pop() {
/* 100 */         SecurityAssociation.popSubjectContext();
/*     */       }
/*  88 */     };
/*     */ 
/*     */     public abstract void push(Principal paramPrincipal, Object paramObject, Subject paramSubject);
/*     */ 
/*     */     public abstract void dup();
/*     */ 
/*     */     public abstract void pop();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.endpoint.SecurityActions
 * JD-Core Version:    0.6.0
 */