/*     */ package org.jboss.jms.server.destination;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.jms.server.DestinationManager;
/*     */ import org.jboss.jms.server.JMSCondition;
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounter;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounterManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.PostOffice;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ import org.jboss.messaging.util.MessageQueueNameHelper;
/*     */ import org.jboss.messaging.util.XMLUtil;
/*     */ 
/*     */ public class TopicService extends DestinationServiceSupport
/*     */   implements TopicMBean
/*     */ {
/*     */   public static final String SUBSCRIPTION_MESSAGECOUNTER_PREFIX = "Subscription.";
/*     */ 
/*     */   public TopicService()
/*     */   {
/*  49 */     this.destination = new ManagedTopic();
/*     */   }
/*     */ 
/*     */   public TopicService(boolean createdProgrammatically)
/*     */   {
/*  54 */     super(createdProgrammatically);
/*     */ 
/*  56 */     this.destination = new ManagedTopic();
/*     */   }
/*     */ 
/*     */   public synchronized void startService()
/*     */     throws Exception
/*     */   {
/*  63 */     super.startService();
/*     */     try
/*     */     {
/*  67 */       PostOffice po = this.serverPeer.getPostOfficeInstance();
/*     */ 
/*  71 */       Collection queues = po.getQueuesForCondition(new JMSCondition(false, this.destination.getName()), true);
/*     */ 
/*  73 */       Iterator iter = queues.iterator();
/*  74 */       while (iter.hasNext())
/*     */       {
/*  76 */         Queue queue = (Queue)iter.next();
/*     */ 
/*  80 */         queue.setPagingParams(this.destination.getFullSize(), this.destination.getPageSize(), this.destination.getDownCacheSize());
/*     */ 
/*  82 */         queue.load();
/*     */ 
/*  84 */         queue.activate();
/*     */ 
/*  87 */         queue.setMaxSize(this.destination.getMaxSize());
/*     */ 
/*  90 */         String counterName = "Subscription." + queue.getName();
/*     */ 
/*  92 */         String subName = MessageQueueNameHelper.createHelper(queue.getName()).getSubName();
/*     */ 
/*  94 */         int dayLimitToUse = this.destination.getMessageCounterHistoryDayLimit();
/*  95 */         if (dayLimitToUse == -1)
/*     */         {
/*  98 */           dayLimitToUse = this.serverPeer.getDefaultMessageCounterHistoryDayLimit();
/*     */         }
/*     */ 
/* 101 */         MessageCounter counter = new MessageCounter(counterName, subName, queue, true, true, dayLimitToUse);
/*     */ 
/* 105 */         this.serverPeer.getMessageCounterManager().registerMessageCounter(counterName, counter);
/*     */       }
/*     */ 
/* 108 */       this.serverPeer.getDestinationManager().registerDestination(this.destination);
/*     */ 
/* 110 */       this.log.debug(this + " security configuration: " + (this.destination.getSecurityConfig() == null ? "null" : new StringBuilder().append("\n").append(XMLUtil.elementToString(this.destination.getSecurityConfig())).toString()));
/*     */ 
/* 113 */       this.started = true;
/*     */ 
/* 115 */       this.log.info(this + " started, fullSize=" + this.destination.getFullSize() + ", pageSize=" + this.destination.getPageSize() + ", downCacheSize=" + this.destination.getDownCacheSize());
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 119 */       ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void stopService() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 127 */       this.serverPeer.getDestinationManager().unregisterDestination(this.destination);
/*     */ 
/* 136 */       PostOffice po = this.serverPeer.getPostOfficeInstance();
/*     */ 
/* 138 */       Collection queues = this.serverPeer.getPostOfficeInstance().getQueuesForCondition(new JMSCondition(false, this.destination.getName()), true);
/*     */ 
/* 140 */       Iterator iter = queues.iterator();
/*     */ 
/* 142 */       while (iter.hasNext())
/*     */       {
/* 144 */         Queue queue = (Queue)iter.next();
/*     */ 
/* 146 */         if (!queue.isRecoverable())
/*     */         {
/* 149 */           po.removeBinding(queue.getName(), false);
/*     */         }
/*     */ 
/* 152 */         queue.deactivate();
/*     */ 
/* 154 */         queue.unload();
/*     */ 
/* 157 */         String counterName = "Subscription." + queue.getName();
/*     */ 
/* 159 */         this.serverPeer.getMessageCounterManager().unregisterMessageCounter(counterName);
/*     */       }
/*     */ 
/* 162 */       this.started = false;
/* 163 */       this.log.info(this + " stopped");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 167 */       ExceptionUtil.handleJMXInvocation(t, this + " stopService");
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getAllMessageCount()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 177 */       if (!this.started)
/*     */       {
/* 179 */         this.log.warn("Topic is stopped.");
/* 180 */         return -1;
/*     */       }
/*     */ 
/* 183 */       return ((ManagedTopic)this.destination).getAllMessageCount();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 187 */     throw ExceptionUtil.handleJMXInvocation(t, this + " getAllMessageCount");
/*     */   }
/*     */ 
/*     */   public int getDurableMessageCount()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 196 */       if (!this.started)
/*     */       {
/* 198 */         this.log.warn("Topic is stopped.");
/* 199 */         return -1;
/*     */       }
/*     */ 
/* 202 */       return ((ManagedTopic)this.destination).getDurableMessageCount();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 206 */     throw ExceptionUtil.handleJMXInvocation(t, this + " getDurableMessageCount");
/*     */   }
/*     */ 
/*     */   public int getNonDurableMessageCount()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 214 */       if (!this.started)
/*     */       {
/* 216 */         this.log.warn("Topic is stopped.");
/* 217 */         return -1;
/*     */       }
/*     */ 
/* 220 */       return ((ManagedTopic)this.destination).getNonDurableMessageCount();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 224 */     throw ExceptionUtil.handleJMXInvocation(t, this + " getNonDurableMessageCount");
/*     */   }
/*     */ 
/*     */   public int getAllSubscriptionsCount()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 237 */       if (!this.started)
/*     */       {
/* 239 */         this.log.warn("Topic is stopped.");
/* 240 */         return 0;
/*     */       }
/*     */ 
/* 243 */       return ((ManagedTopic)this.destination).getAllSubscriptionsCount();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 247 */     throw ExceptionUtil.handleJMXInvocation(t, this + " getAllSubscriptionsCount");
/*     */   }
/*     */ 
/*     */   public int getDurableSubscriptionsCount()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 255 */       if (!this.started)
/*     */       {
/* 257 */         this.log.warn("Topic is stopped.");
/* 258 */         return 0;
/*     */       }
/*     */ 
/* 261 */       return ((ManagedTopic)this.destination).getDurableSubscriptionsCount();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 265 */     throw ExceptionUtil.handleJMXInvocation(t, this + " getDurableSubscriptionsCount");
/*     */   }
/*     */ 
/*     */   public int getNonDurableSubscriptionsCount()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 273 */       if (!this.started)
/*     */       {
/* 275 */         this.log.warn("Topic is stopped.");
/* 276 */         return 0;
/*     */       }
/*     */ 
/* 279 */       return ((ManagedTopic)this.destination).getNonDurableSubscriptionsCount();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 283 */     throw ExceptionUtil.handleJMXInvocation(t, this + " getNonDurableSubscriptionsCount");
/*     */   }
/*     */ 
/*     */   public void removeAllMessages()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 297 */       if (!this.started)
/*     */       {
/* 299 */         this.log.warn("Topic is stopped.");
/* 300 */         return;
/*     */       }
/*     */ 
/* 303 */       ((ManagedTopic)this.destination).removeAllMessages();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 307 */       throw ExceptionUtil.handleJMXInvocation(t, this + " removeAllMessages");
/*     */     }
/*     */   }
/*     */ 
/*     */   public List listAllSubscriptions() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 315 */       if (!this.started)
/*     */       {
/* 317 */         this.log.warn("Topic is stopped.");
/* 318 */         return null;
/*     */       }
/*     */ 
/* 321 */       return ((ManagedTopic)this.destination).listAllSubscriptions();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 325 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listAllSubscriptions");
/*     */   }
/*     */ 
/*     */   public List listDurableSubscriptions()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 333 */       if (!this.started)
/*     */       {
/* 335 */         this.log.warn("Topic is stopped.");
/* 336 */         return null;
/*     */       }
/*     */ 
/* 339 */       return ((ManagedTopic)this.destination).listDurableSubscriptions();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 343 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableSubscriptions");
/*     */   }
/*     */ 
/*     */   public List listNonDurableSubscriptions()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 351 */       if (!this.started)
/*     */       {
/* 353 */         this.log.warn("Topic is stopped.");
/* 354 */         return null;
/*     */       }
/*     */ 
/* 357 */       return ((ManagedTopic)this.destination).listNonDurableSubscriptions();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 361 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableSubscriptions");
/*     */   }
/*     */ 
/*     */   public String listAllSubscriptionsAsHTML()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 369 */       if (!this.started)
/*     */       {
/* 371 */         this.log.warn("Topic is stopped.");
/* 372 */         return "";
/*     */       }
/*     */ 
/* 375 */       return ((ManagedTopic)this.destination).listAllSubscriptionsAsHTML();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 379 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listAllSubscriptionsAsHTML");
/*     */   }
/*     */ 
/*     */   public String listDurableSubscriptionsAsHTML()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 387 */       if (!this.started)
/*     */       {
/* 389 */         this.log.warn("Topic is stopped.");
/* 390 */         return "";
/*     */       }
/*     */ 
/* 393 */       return ((ManagedTopic)this.destination).listDurableSubscriptionsAsHTML();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 397 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableSubscriptionsAsHTML");
/*     */   }
/*     */ 
/*     */   public String listNonDurableSubscriptionsAsHTML()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 405 */       if (!this.started)
/*     */       {
/* 407 */         this.log.warn("Topic is stopped.");
/* 408 */         return "";
/*     */       }
/*     */ 
/* 411 */       return ((ManagedTopic)this.destination).listNonDurableSubscriptionsAsHTML();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 415 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableSubscriptionsAsHTML");
/*     */   }
/*     */ 
/*     */   public List listAllMessages(String subscriptionId)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 423 */       if (!this.started)
/*     */       {
/* 425 */         this.log.warn("Topic is stopped.");
/* 426 */         return null;
/*     */       }
/*     */ 
/* 429 */       return ((ManagedTopic)this.destination).listAllMessages(subscriptionId, null);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 433 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listMessages");
/*     */   }
/*     */ 
/*     */   public List listAllMessages(String subscriptionId, String selector)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 441 */       if (!this.started)
/*     */       {
/* 443 */         this.log.warn("Topic is stopped.");
/* 444 */         return null;
/*     */       }
/*     */ 
/* 447 */       return ((ManagedTopic)this.destination).listAllMessages(subscriptionId, selector);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 451 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listMessages");
/*     */   }
/*     */ 
/*     */   public List listDurableMessages(String subscriptionId)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 460 */       if (!this.started)
/*     */       {
/* 462 */         this.log.warn("Topic is stopped.");
/* 463 */         return null;
/*     */       }
/*     */ 
/* 466 */       return ((ManagedTopic)this.destination).listDurableMessages(subscriptionId, null);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 470 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableMessages");
/*     */   }
/*     */ 
/*     */   public List listDurableMessages(String subscriptionId, String selector)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 478 */       if (!this.started)
/*     */       {
/* 480 */         this.log.warn("Topic is stopped.");
/* 481 */         return null;
/*     */       }
/*     */ 
/* 484 */       return ((ManagedTopic)this.destination).listDurableMessages(subscriptionId, selector);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 488 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableMessages");
/*     */   }
/*     */ 
/*     */   public List listNonDurableMessages(String subscriptionId)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 496 */       if (!this.started)
/*     */       {
/* 498 */         this.log.warn("Topic is stopped.");
/* 499 */         return null;
/*     */       }
/*     */ 
/* 502 */       return ((ManagedTopic)this.destination).listNonDurableMessages(subscriptionId, null);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 506 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableMessages");
/*     */   }
/*     */ 
/*     */   public List listNonDurableMessages(String subscriptionId, String selector)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 514 */       if (!this.started)
/*     */       {
/* 516 */         this.log.warn("Topic is stopped.");
/* 517 */         return null;
/*     */       }
/*     */ 
/* 520 */       return ((ManagedTopic)this.destination).listNonDurableMessages(subscriptionId, selector);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 524 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableMessages");
/*     */   }
/*     */ 
/*     */   public List getMessageCounters()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 533 */       return ((ManagedTopic)this.destination).getMessageCounters();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 537 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listMessagesNonDurableSub");
/*     */   }
/*     */ 
/*     */   protected boolean isQueue()
/*     */   {
/* 549 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.destination.TopicService
 * JD-Core Version:    0.6.0
 */