/*     */ package org.jboss.jms.server.destination;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.jms.IllegalStateException;
/*     */ import org.jboss.jms.server.DestinationManager;
/*     */ import org.jboss.jms.server.JMSCondition;
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounter;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounterManager;
/*     */ import org.jboss.jms.server.messagecounter.MessageStatistics;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Binding;
/*     */ import org.jboss.messaging.core.contract.PostOffice;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ import org.jboss.messaging.core.impl.IDManager;
/*     */ import org.jboss.messaging.core.impl.MessagingQueue;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ import org.jboss.messaging.util.XMLUtil;
/*     */ 
/*     */ public class QueueService extends DestinationServiceSupport
/*     */   implements QueueMBean
/*     */ {
/*     */   private static final String QUEUE_MESSAGECOUNTER_PREFIX = "Queue.";
/*     */ 
/*     */   public QueueService()
/*     */   {
/*  48 */     this.destination = new ManagedQueue();
/*     */   }
/*     */ 
/*     */   public QueueService(boolean createdProgrammatically)
/*     */   {
/*  53 */     super(createdProgrammatically);
/*     */ 
/*  55 */     this.destination = new ManagedQueue();
/*     */   }
/*     */ 
/*     */   public synchronized void startService()
/*     */     throws Exception
/*     */   {
/*  62 */     super.startService();
/*     */     try
/*     */     {
/*  70 */       PostOffice po = this.serverPeer.getPostOfficeInstance();
/*     */ 
/*  72 */       Binding binding = po.getBindingForQueueName(this.destination.getName());
/*     */       Queue queue;
/*  76 */       if (binding != null)
/*     */       {
/*  78 */         Queue queue = binding.queue;
/*     */ 
/*  80 */         if (queue.isActive())
/*     */         {
/*  82 */           throw new IllegalStateException("Cannot deploy queue " + this.destination.getName() + " it is already deployed");
/*     */         }
/*     */ 
/*  85 */         queue.setPagingParams(this.destination.getFullSize(), this.destination.getPageSize(), this.destination.getDownCacheSize());
/*     */ 
/*  89 */         queue.load();
/*     */ 
/*  92 */         queue.setMaxSize(this.destination.getMaxSize());
/*     */ 
/*  94 */         queue.activate();
/*     */       }
/*     */       else
/*     */       {
/* 100 */         JMSCondition queueCond = new JMSCondition(true, this.destination.getName());
/*     */ 
/* 102 */         queue = new MessagingQueue(this.nodeId, this.destination.getName(), this.serverPeer.getChannelIDManager().getID(), this.serverPeer.getMessageStore(), this.serverPeer.getPersistenceManagerInstance(), true, this.destination.getMaxSize(), null, this.destination.getFullSize(), this.destination.getPageSize(), this.destination.getDownCacheSize(), this.destination.isClustered(), this.serverPeer.getRecoverDeliveriesTimeout());
/*     */ 
/* 110 */         po.addBinding(new Binding(queueCond, queue, false), false);
/*     */ 
/* 112 */         queue.activate();
/*     */       }
/*     */ 
/* 115 */       ((ManagedQueue)this.destination).setQueue(queue);
/*     */ 
/* 117 */       String counterName = "Queue." + this.destination.getName();
/*     */ 
/* 119 */       int dayLimitToUse = this.destination.getMessageCounterHistoryDayLimit();
/* 120 */       if (dayLimitToUse == -1)
/*     */       {
/* 123 */         dayLimitToUse = this.serverPeer.getDefaultMessageCounterHistoryDayLimit();
/*     */       }
/*     */ 
/* 126 */       MessageCounter counter = new MessageCounter(counterName, null, queue, false, false, dayLimitToUse);
/*     */ 
/* 130 */       ((ManagedQueue)this.destination).setMessageCounter(counter);
/*     */ 
/* 132 */       this.serverPeer.getMessageCounterManager().registerMessageCounter(counterName, counter);
/*     */ 
/* 134 */       this.serverPeer.getDestinationManager().registerDestination(this.destination);
/*     */ 
/* 136 */       this.log.debug(this + " security configuration: " + (this.destination.getSecurityConfig() == null ? "null" : new StringBuilder().append("\n").append(XMLUtil.elementToString(this.destination.getSecurityConfig())).toString()));
/*     */ 
/* 139 */       this.started = true;
/*     */ 
/* 141 */       this.log.info(this + " started, fullSize=" + this.destination.getFullSize() + ", pageSize=" + this.destination.getPageSize() + ", downCacheSize=" + this.destination.getDownCacheSize());
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 146 */       ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void stopService() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 154 */       this.serverPeer.getDestinationManager().unregisterDestination(this.destination);
/*     */ 
/* 156 */       Queue queue = ((ManagedQueue)this.destination).getQueue();
/*     */ 
/* 158 */       String counterName = "Queue." + this.destination.getName();
/*     */ 
/* 160 */       MessageCounter counter = this.serverPeer.getMessageCounterManager().unregisterMessageCounter(counterName);
/*     */ 
/* 162 */       if (counter == null)
/*     */       {
/* 164 */         throw new IllegalStateException("Cannot find counter to unregister " + counterName);
/*     */       }
/*     */ 
/* 167 */       queue.deactivate();
/*     */ 
/* 169 */       queue.unload();
/*     */ 
/* 171 */       this.started = false;
/*     */ 
/* 173 */       this.log.info(this + " stopped");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 177 */       ExceptionUtil.handleJMXInvocation(t, this + " stopService");
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getMessageCount()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 187 */       if (!this.started)
/*     */       {
/* 189 */         this.log.warn("Queue is stopped");
/* 190 */         return 0;
/*     */       }
/*     */ 
/* 193 */       return ((ManagedQueue)this.destination).getMessageCount();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 197 */     throw ExceptionUtil.handleJMXInvocation(t, this + " getMessageCount");
/*     */   }
/*     */ 
/*     */   public int getDeliveringCount()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 205 */       if (!this.started)
/*     */       {
/* 207 */         this.log.warn("Queue is stopped");
/* 208 */         return 0;
/*     */       }
/*     */ 
/* 211 */       return ((ManagedQueue)this.destination).getDeliveringCount();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 215 */     throw ExceptionUtil.handleJMXInvocation(t, this + " getDeliveringCount");
/*     */   }
/*     */ 
/*     */   public int getScheduledMessageCount()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 223 */       if (!this.started)
/*     */       {
/* 225 */         this.log.warn("Queue is stopped");
/* 226 */         return 0;
/*     */       }
/*     */ 
/* 229 */       return ((ManagedQueue)this.destination).getScheduledMessageCount();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 233 */     throw ExceptionUtil.handleJMXInvocation(t, this + " getMessageCount");
/*     */   }
/*     */ 
/*     */   public MessageCounter getMessageCounter()
/*     */   {
/* 239 */     return ((ManagedQueue)this.destination).getMessageCounter();
/*     */   }
/*     */ 
/*     */   public MessageStatistics getMessageStatistics() throws Exception
/*     */   {
/* 244 */     List counters = new ArrayList();
/* 245 */     counters.add(getMessageCounter());
/*     */ 
/* 247 */     List stats = MessageCounter.getMessageStatistics(counters);
/*     */ 
/* 249 */     return (MessageStatistics)stats.get(0);
/*     */   }
/*     */ 
/*     */   public String listMessageCounterAsHTML()
/*     */   {
/* 254 */     return super.listMessageCounterAsHTML(new MessageCounter[] { getMessageCounter() });
/*     */   }
/*     */ 
/*     */   public int getConsumerCount() throws Exception
/*     */   {
/* 259 */     return ((ManagedQueue)this.destination).getConsumersCount();
/*     */   }
/*     */ 
/*     */   public void removeAllMessages()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 268 */       if (!this.started)
/*     */       {
/* 270 */         this.log.warn("Queue is stopped.");
/* 271 */         return;
/*     */       }
/*     */ 
/* 274 */       ((ManagedQueue)this.destination).removeAllMessages();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 278 */       throw ExceptionUtil.handleJMXInvocation(t, this + " removeAllMessages");
/*     */     }
/*     */   }
/*     */ 
/*     */   public List listAllMessages() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 286 */       if (!this.started)
/*     */       {
/* 288 */         this.log.warn("Queue is stopped.");
/* 289 */         return null;
/*     */       }
/*     */ 
/* 292 */       return ((ManagedQueue)this.destination).listAllMessages(null);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 296 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listAllMessages");
/*     */   }
/*     */ 
/*     */   public List listAllMessages(String selector)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 304 */       if (!this.started)
/*     */       {
/* 306 */         this.log.warn("Queue is stopped.");
/* 307 */         return null;
/*     */       }
/*     */ 
/* 310 */       return ((ManagedQueue)this.destination).listAllMessages(selector);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 314 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listAllMessages");
/*     */   }
/*     */ 
/*     */   public List listDurableMessages()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 322 */       if (!this.started)
/*     */       {
/* 324 */         this.log.warn("Queue is stopped.");
/* 325 */         return null;
/*     */       }
/*     */ 
/* 328 */       return ((ManagedQueue)this.destination).listDurableMessages(null);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 332 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableMessages");
/*     */   }
/*     */ 
/*     */   public List listDurableMessages(String selector)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 340 */       if (!this.started)
/*     */       {
/* 342 */         this.log.warn("Queue is stopped.");
/* 343 */         return null;
/*     */       }
/*     */ 
/* 346 */       return ((ManagedQueue)this.destination).listDurableMessages(selector);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 350 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableMessages");
/*     */   }
/*     */ 
/*     */   public List listNonDurableMessages()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 358 */       if (!this.started)
/*     */       {
/* 360 */         this.log.warn("Queue is stopped.");
/* 361 */         return null;
/*     */       }
/*     */ 
/* 364 */       return ((ManagedQueue)this.destination).listNonDurableMessages(null);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 368 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableMessages");
/*     */   }
/*     */ 
/*     */   public List listNonDurableMessages(String selector)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 376 */       if (!this.started)
/*     */       {
/* 378 */         this.log.warn("Queue is stopped.");
/* 379 */         return null;
/*     */       }
/*     */ 
/* 382 */       return ((ManagedQueue)this.destination).listNonDurableMessages(selector);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 386 */     throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableMessages");
/*     */   }
/*     */ 
/*     */   public void resetMessageCounter()
/*     */   {
/* 392 */     ((ManagedQueue)this.destination).getMessageCounter().resetCounter();
/*     */   }
/*     */ 
/*     */   public String listMessageCounterHistoryAsHTML()
/*     */   {
/* 397 */     return super.listMessageCounterHistoryAsHTML(new MessageCounter[] { getMessageCounter() });
/*     */   }
/*     */ 
/*     */   public void resetMessageCounterHistory()
/*     */   {
/* 402 */     ((ManagedQueue)this.destination).getMessageCounter().resetHistory();
/*     */   }
/*     */ 
/*     */   protected boolean isQueue()
/*     */   {
/* 413 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.destination.QueueService
 * JD-Core Version:    0.6.0
 */