/*     */ package org.jboss.jms.server.destination;
/*     */ 
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.messaging.core.contract.Binding;
/*     */ import org.jboss.messaging.core.contract.MessagingComponent;
/*     */ import org.jboss.messaging.core.contract.PostOffice;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public abstract class ManagedDestination
/*     */   implements MessagingComponent
/*     */ {
/*     */   protected static final int ALL = 0;
/*     */   protected static final int DURABLE = 1;
/*     */   protected static final int NON_DURABLE = 2;
/*     */   private static final int DEFAULT_FULL_SIZE = 200000;
/*     */   private static final int DEFAULT_PAGE_SIZE = 2000;
/*     */   private static final int DEFAULT_DOWN_CACHE_SIZE = 2000;
/*     */   protected String name;
/*     */   protected String jndiName;
/*     */   protected boolean clustered;
/*     */   protected boolean temporary;
/*  70 */   protected int fullSize = 200000;
/*     */ 
/*  73 */   protected int pageSize = 2000;
/*     */ 
/*  76 */   protected int downCacheSize = 2000;
/*     */   protected Element securityConfig;
/*     */   protected ServerPeer serverPeer;
/*     */   protected ManagedQueue dlq;
/*     */   protected ManagedQueue expiryQueue;
/*  86 */   protected long redeliveryDelay = -1L;
/*     */ 
/*  88 */   protected int maxSize = -1;
/*     */ 
/*  90 */   protected int messageCounterHistoryDayLimit = -1;
/*     */ 
/*  92 */   protected int maxDeliveryAttempts = -1;
/*     */ 
/*     */   public ManagedDestination()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ManagedDestination(String name, int fullSize, int pageSize, int downCacheSize, boolean clustered)
/*     */   {
/* 103 */     this.name = name;
/* 104 */     this.fullSize = fullSize;
/* 105 */     this.pageSize = pageSize;
/* 106 */     this.downCacheSize = downCacheSize;
/* 107 */     this.clustered = clustered;
/*     */   }
/*     */ 
/*     */   public boolean isClustered()
/*     */   {
/* 112 */     return this.clustered;
/*     */   }
/*     */ 
/*     */   public void setClustered(boolean clustered)
/*     */   {
/* 117 */     this.clustered = clustered;
/*     */   }
/*     */ 
/*     */   public int getDownCacheSize()
/*     */   {
/* 122 */     return this.downCacheSize;
/*     */   }
/*     */ 
/*     */   public void setDownCacheSize(int downCacheSize)
/*     */   {
/* 127 */     this.downCacheSize = downCacheSize;
/*     */   }
/*     */ 
/*     */   public int getFullSize()
/*     */   {
/* 132 */     return this.fullSize;
/*     */   }
/*     */ 
/*     */   public void setFullSize(int fullSize)
/*     */   {
/* 137 */     this.fullSize = fullSize;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 142 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 147 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 152 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 157 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public int getPageSize()
/*     */   {
/* 162 */     return this.pageSize;
/*     */   }
/*     */ 
/*     */   public void setPageSize(int pageSize)
/*     */   {
/* 167 */     this.pageSize = pageSize;
/*     */   }
/*     */ 
/*     */   public Element getSecurityConfig()
/*     */   {
/* 172 */     return this.securityConfig;
/*     */   }
/*     */ 
/*     */   public void setSecurityConfig(Element securityConfig)
/*     */   {
/* 177 */     this.securityConfig = securityConfig;
/*     */   }
/*     */ 
/*     */   public ServerPeer getServerPeer()
/*     */   {
/* 182 */     return this.serverPeer;
/*     */   }
/*     */ 
/*     */   public void setServerPeer(ServerPeer serverPeer)
/*     */   {
/* 187 */     this.serverPeer = serverPeer;
/*     */   }
/*     */ 
/*     */   public boolean isTemporary()
/*     */   {
/* 192 */     return this.temporary;
/*     */   }
/*     */ 
/*     */   public void setTemporary(boolean temporary)
/*     */   {
/* 197 */     this.temporary = temporary;
/*     */   }
/*     */ 
/*     */   public Queue getDLQ()
/*     */     throws Exception
/*     */   {
/* 203 */     Queue theQueue = null;
/*     */ 
/* 205 */     if (this.dlq != null)
/*     */     {
/* 207 */       Binding binding = this.serverPeer.getPostOfficeInstance().getBindingForQueueName(this.dlq.getName());
/*     */ 
/* 209 */       if (binding == null)
/*     */       {
/* 211 */         throw new IllegalStateException("Cannot find binding for queue " + this.dlq.getName());
/*     */       }
/*     */ 
/* 214 */       Queue queue = binding.queue;
/*     */ 
/* 216 */       if (queue.isActive())
/*     */       {
/* 218 */         theQueue = queue;
/*     */       }
/*     */     }
/*     */ 
/* 222 */     return theQueue;
/*     */   }
/*     */ 
/*     */   public void setDLQ(ManagedQueue dlq)
/*     */   {
/* 227 */     this.dlq = dlq;
/*     */   }
/*     */ 
/*     */   public Queue getExpiryQueue()
/*     */     throws Exception
/*     */   {
/* 233 */     Queue theQueue = null;
/*     */ 
/* 235 */     if (this.expiryQueue != null)
/*     */     {
/* 237 */       Binding binding = this.serverPeer.getPostOfficeInstance().getBindingForQueueName(this.expiryQueue.getName());
/*     */ 
/* 239 */       if (binding == null)
/*     */       {
/* 241 */         throw new IllegalStateException("Cannot find binding for queue " + this.expiryQueue.getName());
/*     */       }
/*     */ 
/* 244 */       Queue queue = binding.queue;
/*     */ 
/* 247 */       if (queue.isActive())
/*     */       {
/* 249 */         theQueue = queue;
/*     */       }
/*     */     }
/*     */ 
/* 253 */     return theQueue;
/*     */   }
/*     */ 
/*     */   public void setExpiryQueue(ManagedQueue expiryQueue)
/*     */   {
/* 258 */     this.expiryQueue = expiryQueue;
/*     */   }
/*     */ 
/*     */   public long getRedeliveryDelay()
/*     */   {
/* 263 */     return this.redeliveryDelay;
/*     */   }
/*     */ 
/*     */   public void setRedeliveryDelay(long delay)
/*     */   {
/* 268 */     this.redeliveryDelay = delay;
/*     */   }
/*     */ 
/*     */   public int getMaxSize()
/*     */   {
/* 273 */     return this.maxSize;
/*     */   }
/*     */ 
/*     */   public void setMaxSize(int maxSize)
/*     */     throws Exception
/*     */   {
/* 287 */     this.maxSize = maxSize;
/*     */   }
/*     */ 
/*     */   public int getMessageCounterHistoryDayLimit()
/*     */   {
/* 292 */     return this.messageCounterHistoryDayLimit;
/*     */   }
/*     */ 
/*     */   public void setMessageCounterHistoryDayLimit(int limit) throws Exception
/*     */   {
/* 297 */     this.messageCounterHistoryDayLimit = limit;
/*     */   }
/*     */ 
/*     */   public int getMaxDeliveryAttempts()
/*     */   {
/* 302 */     return this.maxDeliveryAttempts;
/*     */   }
/*     */ 
/*     */   public void setMaxDeliveryAttempts(int maxDeliveryAttempts)
/*     */   {
/* 307 */     this.maxDeliveryAttempts = maxDeliveryAttempts;
/*     */   }
/*     */ 
/*     */   public abstract boolean isQueue();
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.destination.ManagedDestination
 * JD-Core Version:    0.6.0
 */