/*     */ package org.jboss.jms.server.destination;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.jms.server.JMSCondition;
/*     */ import org.jboss.jms.server.SecurityStore;
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounter;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Condition;
/*     */ import org.jboss.messaging.core.contract.MessagingComponent;
/*     */ import org.jboss.messaging.core.contract.PostOffice;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ import org.jboss.messaging.util.JMXAccessor;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public abstract class DestinationServiceSupport extends ServiceMBeanSupport
/*     */   implements DestinationMBean
/*     */ {
/*     */   private ObjectName serverPeerObjectName;
/*     */   private ObjectName dlqObjectName;
/*     */   private ObjectName expiryQueueObjectName;
/*  54 */   protected boolean started = false;
/*     */   protected ManagedDestination destination;
/*     */   protected ServerPeer serverPeer;
/*     */   protected int nodeId;
/*     */   private boolean createdProgrammatically;
/*     */ 
/*     */   public DestinationServiceSupport(boolean createdProgrammatically)
/*     */   {
/*  69 */     this.createdProgrammatically = createdProgrammatically;
/*     */   }
/*     */ 
/*     */   public DestinationServiceSupport()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MessagingComponent getInstance()
/*     */   {
/*  80 */     return this.destination;
/*     */   }
/*     */ 
/*     */   public synchronized void startService()
/*     */     throws Exception
/*     */   {
/*  87 */     super.startService();
/*     */     try
/*     */     {
/*  91 */       this.serverPeer = ((ServerPeer)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.serverPeerObjectName, "Instance"));
/*     */ 
/*  93 */       this.destination.setServerPeer(this.serverPeer);
/*     */ 
/*  95 */       this.nodeId = this.serverPeer.getServerPeerID();
/*     */ 
/* 100 */       String name = null;
/*     */ 
/* 102 */       if (this.serviceName != null)
/*     */       {
/* 104 */         name = this.serviceName.getKeyProperty("name");
/*     */       }
/*     */ 
/* 107 */       if ((name == null) || (name.length() == 0))
/*     */       {
/* 109 */         throw new IllegalStateException("The " + (isQueue() ? "queue" : "topic") + " " + "name was not properly set in the service's" + "ObjectName");
/*     */       }
/*     */ 
/* 114 */       this.destination.setName(name);
/*     */ 
/* 119 */       setMaxSizeForQueues();
/*     */ 
/* 121 */       if (this.destination.getSecurityConfig() != null)
/*     */       {
/* 123 */         this.serverPeer.getSecurityManager().setSecurityConfig(isQueue(), this.destination.getName(), this.destination.getSecurityConfig());
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 128 */       ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void stopService() throws Exception
/*     */   {
/* 134 */     super.stopService();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 141 */     return this.destination.getName();
/*     */   }
/*     */ 
/*     */   public String getJNDIName()
/*     */   {
/* 146 */     return this.destination.getJndiName();
/*     */   }
/*     */ 
/*     */   public void setJNDIName(String jndiName) throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 153 */       if (this.started)
/*     */       {
/* 155 */         this.log.warn("Cannot change the value of the JNDI name after initialization!");
/* 156 */         return;
/*     */       }
/*     */ 
/* 159 */       this.destination.setJndiName(jndiName);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 163 */       throw ExceptionUtil.handleJMXInvocation(t, this + " setJNDIName");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setServerPeer(ObjectName on)
/*     */   {
/* 169 */     if (this.started)
/*     */     {
/* 171 */       this.log.warn("Cannot change the value of associated server's ObjectName after initialization!");
/*     */ 
/* 173 */       return;
/*     */     }
/*     */ 
/* 176 */     this.serverPeerObjectName = on;
/*     */   }
/*     */ 
/*     */   public ObjectName getServerPeer()
/*     */   {
/* 181 */     return this.serverPeerObjectName;
/*     */   }
/*     */ 
/*     */   public void setDLQ(ObjectName on) throws Exception
/*     */   {
/* 186 */     this.dlqObjectName = on;
/*     */ 
/* 188 */     ManagedQueue dest = null;
/*     */     try
/*     */     {
/*     */       try
/*     */       {
/* 195 */         dest = (ManagedQueue)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.dlqObjectName, "Instance");
/*     */       }
/*     */       catch (InstanceNotFoundException e)
/*     */       {
/*     */       }
/*     */ 
/* 203 */       this.destination.setDLQ(dest);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 207 */       throw ExceptionUtil.handleJMXInvocation(t, " setDLQ");
/*     */     }
/*     */   }
/*     */ 
/*     */   public ObjectName getDLQ()
/*     */   {
/* 213 */     return this.dlqObjectName;
/*     */   }
/*     */ 
/*     */   public void setExpiryQueue(ObjectName on) throws Exception
/*     */   {
/* 218 */     this.expiryQueueObjectName = on;
/*     */ 
/* 220 */     ManagedQueue dest = null;
/*     */     try
/*     */     {
/*     */       try
/*     */       {
/* 226 */         dest = (ManagedQueue)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.expiryQueueObjectName, "Instance");
/*     */       }
/*     */       catch (InstanceNotFoundException e)
/*     */       {
/*     */       }
/*     */ 
/* 233 */       this.destination.setExpiryQueue(dest);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 237 */       throw ExceptionUtil.handleJMXInvocation(t, this + " setExpiryQueue");
/*     */     }
/*     */   }
/*     */ 
/*     */   public ObjectName getExpiryQueue()
/*     */   {
/* 243 */     return this.expiryQueueObjectName;
/*     */   }
/*     */ 
/*     */   public long getRedeliveryDelay()
/*     */   {
/* 248 */     return this.destination.getRedeliveryDelay();
/*     */   }
/*     */ 
/*     */   public void setRedeliveryDelay(long delay)
/*     */   {
/* 253 */     this.destination.setRedeliveryDelay(delay);
/*     */   }
/*     */ 
/*     */   public int getMaxSize()
/*     */   {
/* 258 */     return this.destination.getMaxSize();
/*     */   }
/*     */ 
/*     */   private void setMaxSizeForQueues()
/*     */     throws Exception
/*     */   {
/* 269 */     Condition cond = new JMSCondition(isQueue(), getName());
/* 270 */     PostOffice postOffice = this.serverPeer.getPostOfficeInstance();
/* 271 */     Collection subs = postOffice.getQueuesForCondition(cond, true);
/* 272 */     Iterator iter = subs.iterator();
/* 273 */     while (iter.hasNext())
/*     */     {
/* 275 */       Queue queue = (Queue)iter.next();
/* 276 */       queue.setMaxSize(getMaxSize());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMaxSize(int maxSize) throws Exception
/*     */   {
/* 282 */     this.destination.setMaxSize(maxSize);
/*     */ 
/* 285 */     if (this.started)
/*     */     {
/* 287 */       setMaxSizeForQueues();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Element getSecurityConfig()
/*     */   {
/* 293 */     return this.destination.getSecurityConfig();
/*     */   }
/*     */ 
/*     */   public void setSecurityConfig(Element securityConfig) throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 300 */       if (this.started)
/*     */       {
/* 303 */         this.serverPeer.getSecurityManager().setSecurityConfig(isQueue(), this.destination.getName(), securityConfig);
/*     */       }
/*     */ 
/* 306 */       this.destination.setSecurityConfig(securityConfig);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 310 */       ExceptionUtil.handleJMXInvocation(t, this + " setSecurityConfig");
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getFullSize()
/*     */   {
/* 320 */     return this.destination.getFullSize();
/*     */   }
/*     */ 
/*     */   public void setFullSize(int fullSize)
/*     */   {
/* 329 */     if (this.started)
/*     */     {
/* 331 */       this.log.warn("FullSize can only be changed when destination is stopped");
/* 332 */       return;
/*     */     }
/* 334 */     this.destination.setFullSize(fullSize);
/*     */   }
/*     */ 
/*     */   public int getPageSize()
/*     */   {
/* 343 */     return this.destination.getPageSize();
/*     */   }
/*     */ 
/*     */   public void setPageSize(int pageSize)
/*     */   {
/* 352 */     if (this.started)
/*     */     {
/* 354 */       this.log.warn("PageSize can only be changed when destination is stopped");
/* 355 */       return;
/*     */     }
/* 357 */     this.destination.setPageSize(pageSize);
/*     */   }
/*     */ 
/*     */   public int getDownCacheSize()
/*     */   {
/* 366 */     return this.destination.getDownCacheSize();
/*     */   }
/*     */ 
/*     */   public void setDownCacheSize(int downCacheSize)
/*     */   {
/* 375 */     if (this.started)
/*     */     {
/* 377 */       this.log.warn("DownCacheSize can only be changed when destination is stopped");
/* 378 */       return;
/*     */     }
/* 380 */     this.destination.setDownCacheSize(downCacheSize);
/*     */   }
/*     */ 
/*     */   public boolean isClustered()
/*     */   {
/* 385 */     return this.destination.isClustered();
/*     */   }
/*     */ 
/*     */   public void setClustered(boolean clustered)
/*     */   {
/* 390 */     if (this.started)
/*     */     {
/* 392 */       this.log.warn("Clustered can only be changed when destination is stopped");
/* 393 */       return;
/*     */     }
/* 395 */     this.destination.setClustered(clustered);
/*     */   }
/*     */ 
/*     */   public boolean isCreatedProgrammatically()
/*     */   {
/* 400 */     return this.createdProgrammatically;
/*     */   }
/*     */ 
/*     */   public int getMessageCounterHistoryDayLimit()
/*     */   {
/* 405 */     return this.destination.getMessageCounterHistoryDayLimit();
/*     */   }
/*     */ 
/*     */   public void setMessageCounterHistoryDayLimit(int limit) throws Exception
/*     */   {
/* 410 */     this.destination.setMessageCounterHistoryDayLimit(limit);
/*     */   }
/*     */ 
/*     */   public int getMaxDeliveryAttempts()
/*     */   {
/* 415 */     return this.destination.getMaxDeliveryAttempts();
/*     */   }
/*     */ 
/*     */   public void setMaxDeliveryAttempts(int maxDeliveryAttempts)
/*     */   {
/* 420 */     this.destination.setMaxDeliveryAttempts(maxDeliveryAttempts);
/*     */   }
/*     */ 
/*     */   public abstract void removeAllMessages()
/*     */     throws Exception;
/*     */ 
/*     */   public String toString()
/*     */   {
/* 432 */     String nameFromJNDI = this.destination.getJndiName();
/* 433 */     int idx = -1;
/* 434 */     if (nameFromJNDI != null)
/*     */     {
/* 436 */       idx = nameFromJNDI.lastIndexOf('/');
/*     */     }
/* 438 */     if (idx != -1)
/*     */     {
/* 440 */       nameFromJNDI = nameFromJNDI.substring(idx + 1);
/*     */     }
/* 442 */     StringBuffer sb = new StringBuffer();
/* 443 */     if (isQueue())
/*     */     {
/* 445 */       sb.append("Queue");
/*     */     }
/*     */     else
/*     */     {
/* 449 */       sb.append("Topic");
/*     */     }
/* 451 */     sb.append('[');
/* 452 */     if (this.destination == null)
/*     */     {
/* 454 */       sb.append("(NULL Destination)");
/*     */     }
/* 456 */     else if (this.destination.getName() == null)
/*     */     {
/* 458 */       sb.append("(destination.getName() == NULL)");
/*     */     }
/* 462 */     else if (this.destination.getName().equals(nameFromJNDI))
/*     */     {
/* 464 */       sb.append(this.destination.getJndiName());
/*     */     }
/*     */     else
/*     */     {
/* 468 */       sb.append(this.destination.getJndiName()).append(", name=").append(this.destination.getName());
/*     */     }
/*     */ 
/* 471 */     sb.append(']');
/* 472 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   protected String listMessageCounterAsHTML(MessageCounter[] counters)
/*     */   {
/* 486 */     if (counters == null) {
/* 487 */       return null;
/*     */     }
/* 489 */     String ret = "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Type</th><th>Name</th><th>Subscription</th><th>Durable</th><th>Count</th><th>CountDelta</th><th>Depth</th><th>DepthDelta</th><th>Last Add</th></tr>";
/*     */ 
/* 502 */     for (int i = 0; i < counters.length; i++)
/*     */     {
/* 504 */       String data = counters[i].getCounterAsString();
/* 505 */       StringTokenizer token = new StringTokenizer(data, ",");
/*     */ 
/* 508 */       ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
/*     */ 
/* 510 */       ret = ret + "<td>" + token.nextToken() + "</td>";
/* 511 */       ret = ret + "<td>" + token.nextToken() + "</td>";
/* 512 */       ret = ret + "<td>" + token.nextToken() + "</td>";
/* 513 */       ret = ret + "<td>" + token.nextToken() + "</td>";
/*     */ 
/* 515 */       ret = ret + "<td>" + token.nextToken() + "</td>";
/*     */ 
/* 517 */       String value = token.nextToken();
/*     */ 
/* 519 */       if (value.equalsIgnoreCase("0")) {
/* 520 */         value = "-";
/*     */       }
/* 522 */       ret = ret + "<td>" + value + "</td>";
/*     */ 
/* 524 */       ret = ret + "<td>" + token.nextToken() + "</td>";
/*     */ 
/* 526 */       value = token.nextToken();
/*     */ 
/* 528 */       if (value.equalsIgnoreCase("0")) {
/* 529 */         value = "-";
/*     */       }
/* 531 */       ret = ret + "<td>" + value + "</td>";
/*     */ 
/* 533 */       ret = ret + "<td>" + token.nextToken() + "</td>";
/*     */ 
/* 535 */       ret = ret + "</tr>";
/*     */     }
/*     */ 
/* 538 */     ret = ret + "</table>";
/*     */ 
/* 540 */     return ret;
/*     */   }
/*     */ 
/*     */   protected String listMessageCounterHistoryAsHTML(MessageCounter[] counters)
/*     */   {
/* 550 */     if (counters == null) {
/* 551 */       return null;
/*     */     }
/* 553 */     String ret = "";
/*     */ 
/* 555 */     for (int i = 0; i < counters.length; i++)
/*     */     {
/* 558 */       ret = ret + (counters[i].getDestinationTopic() ? "Topic '" : "Queue '");
/* 559 */       ret = ret + counters[i].getDestinationName() + "'";
/*     */ 
/* 561 */       if (counters[i].getDestinationSubscription() != null) {
/* 562 */         ret = ret + "Subscription '" + counters[i].getDestinationSubscription() + "'";
/*     */       }
/*     */ 
/* 566 */       ret = ret + "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Date</th>";
/*     */ 
/* 570 */       for (int j = 0; j < 24; j++) {
/* 571 */         ret = ret + "<th width=\"4%\">" + j + "</th>";
/*     */       }
/* 573 */       ret = ret + "<th>Total</th></tr>";
/*     */ 
/* 576 */       StringTokenizer tokens = new StringTokenizer(counters[i].getHistoryAsString(), ",\n");
/*     */ 
/* 579 */       int days = Integer.parseInt(tokens.nextToken());
/*     */ 
/* 581 */       for (int j = 0; j < days; j++)
/*     */       {
/* 584 */         ret = ret + "<tr bgcolor=\"#" + (j % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
/*     */ 
/* 587 */         ret = ret + "<td>" + tokens.nextToken() + "</td>";
/*     */ 
/* 590 */         int total = 0;
/*     */ 
/* 592 */         for (int k = 0; k < 24; k++)
/*     */         {
/* 594 */           int value = Integer.parseInt(tokens.nextToken().trim());
/*     */ 
/* 596 */           if (value == -1)
/*     */           {
/* 598 */             ret = ret + "<td></td>";
/*     */           }
/*     */           else
/*     */           {
/* 602 */             ret = ret + "<td>" + value + "</td>";
/*     */ 
/* 604 */             total += value;
/*     */           }
/*     */         }
/*     */ 
/* 608 */         ret = ret + "<td>" + total + "</td></tr>";
/*     */       }
/*     */ 
/* 611 */       ret = ret + "</table><br><br>";
/*     */     }
/*     */ 
/* 614 */     return ret;
/*     */   }
/*     */ 
/*     */   protected abstract boolean isQueue();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.destination.DestinationServiceSupport
 * JD-Core Version:    0.6.0
 */